/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.graphql.AbstractGraphQLSearchEndpointTest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class GraphQLNodeLanguageSearchEnpointTest
extends AbstractGraphQLSearchEndpointTest {
    @Parameterized.Parameters(name="query={0}")
    public static List<String> paramData() {
        return Collections.singletonList("node-elasticsearch-language-query");
    }

    public GraphQLNodeLanguageSearchEnpointTest(String queryName) {
        super(queryName);
    }

    @Before
    public void createNodes() {
        String parentNodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Arrays.asList("de", "en").forEach(lang -> {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNode(new NodeReference().setUuid(parentNodeUuid));
            nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            nodeCreateRequest.setLanguage(lang);
            nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)("test" + lang)));
            nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{lang})}));
        });
    }
}

