/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.graphql.AbstractGraphQLNodeTest;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLNodePermissionTest
extends AbstractGraphQLNodeTest {
    private PermissionScenario perm;
    private ContentSetupType setup;
    public static final String CHECK_PERM = "checkperm:";

    public GraphQLNodePermissionTest(PermissionScenario perm, ContentSetupType setup) {
        this.perm = perm;
        this.setup = setup;
    }

    @Parameterized.Parameters(name="permission={0},content={1}")
    public static Collection<Object[]> paramData() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (PermissionScenario perm : PermissionScenario.values()) {
            for (ContentSetupType content : ContentSetupType.values()) {
                data.add(new Object[]{perm, content});
            }
        }
        return data;
    }

    @Test
    public void testPermissions() throws IOException {
        switch (this.setup) {
            case PUBLISH_SELECT_DRAFT: 
            case PUBLISH_SELECT_PUBLISHED: {
                this.setupContents(true);
                break;
            }
            case NO_PUBLISH_SELECT_DRAFT: 
            case NO_PUBLISH_SELECT_PUBLISHED: {
                this.setupContents(false);
            }
        }
        this.applyVariations();
        GraphQLRequest request = new GraphQLRequest();
        JsonObject vars = new JsonObject();
        ContainerType selectedType = this.setup == ContentSetupType.PUBLISH_SELECT_DRAFT || this.setup == ContentSetupType.NO_PUBLISH_SELECT_DRAFT ? ContainerType.DRAFT : ContainerType.PUBLISHED;
        vars.put("type", (Object)selectedType.getHumanCode());
        vars.put("invType", (Object)(selectedType == ContainerType.DRAFT ? ContainerType.PUBLISHED.getHumanCode() : ContainerType.DRAFT.getHumanCode()));
        request.setVariables(vars);
        for (TestQuery field : TestQuery.values()) {
            String queryName = "node/permissions/" + field.path();
            request.setQuery(this.getGraphQLQuery(queryName));
            GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
            JsonObject jsonResponse = new JsonObject(response.toJson());
            System.out.println(jsonResponse.encodePrettily());
            System.out.println("Query: " + queryName);
            this.compliesToAssertions(jsonResponse, queryName);
            MeshAssertions.assertThat((JsonObject)jsonResponse).hasNoGraphQLSyntaxError();
        }
    }

    private void compliesToAssertions(JsonObject jsonResponse, String queryName) throws IOException {
        String query = this.getGraphQLQuery(queryName);
        try (Scanner scanner = new Scanner(query);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!(line = line.trim()).startsWith("# [")) continue;
                int start = line.indexOf("# [") + 3;
                int end = line.lastIndexOf("]");
                String selector = line.substring(start, end);
                int ab = line.indexOf("=", end) + 1;
                String assertion = line.substring(ab);
                String currentSelector = this.perm.name() + "," + this.setup.name();
                if (!currentSelector.equalsIgnoreCase(selector)) continue;
                if (assertion.startsWith(CHECK_PERM)) {
                    String permPath = assertion.substring(CHECK_PERM.length());
                    MeshAssertions.assertThat((JsonObject)jsonResponse).hasPermFailure(permPath);
                    continue;
                }
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo(assertion);
            }
        }
    }

    private void applyVariations() {
        RolePermissionRequest permRequest = new RolePermissionRequest();
        PermissionInfo permissionsInfo = permRequest.getPermissions();
        switch (this.perm) {
            case ONLY_READ: {
                permissionsInfo.set(Permission.READ, true);
                break;
            }
            case ONLY_READ_PUBLISHED: {
                permissionsInfo.set(Permission.READ_PUBLISHED, true);
                break;
            }
        }
        permissionsInfo.setOthers(false);
        permRequest.setRecursive(Boolean.valueOf(true));
        this.adminCall(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes", permRequest));
        if (PermissionScenario.NO_PERM == this.perm) {
            RolePermissionRequest permRequest2 = new RolePermissionRequest();
            permRequest2.setRecursive(Boolean.valueOf(false));
            permRequest2.getPermissions().set(Permission.READ, true);
            permRequest2.getPermissions().setOthers(false);
            this.adminCall(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/02e3982b6ad14c1fa4a0b5998a02ff92", permRequest2));
        }
    }

    public static enum PermissionScenario {
        NO_PERM,
        ONLY_READ,
        ONLY_READ_PUBLISHED;

    }

    public static enum ContentSetupType {
        PUBLISH_SELECT_DRAFT,
        PUBLISH_SELECT_PUBLISHED,
        NO_PUBLISH_SELECT_DRAFT,
        NO_PUBLISH_SELECT_PUBLISHED;

    }

    public static enum TestQuery {
        ME_NODE_REFERENCE("me.nodeReference"),
        NODE_UUID("nodePerUuid"),
        NODE_UUID_PARENT("nodePerUuid.parent"),
        NODE_UUID_BREADCRUMB("nodePerUuid.breadcrumb"),
        NODE_UUID_LANGUAGES("nodePerUuid.languages"),
        NODE_UUID_FIELDS_NODE("nodePerUuid.fields.node"),
        NODE_UUID_FIELDS_NODE_LIST("nodePerUuid.fields.nodeList"),
        NODE_UUID_CHILD("nodePerUuid.child"),
        NODE_UUID_NOLANG("nodePerUuid.nolang"),
        SCHEMA_NODES("schema.nodes.elements"),
        ROOT_NODE("rootNode"),
        TAG_NODES("tag.nodes.elements"),
        TAGS_NODES("tags.elements[0].nodes.elements"),
        PROJECT_ROOT_NODE("project.rootNode"),
        NODE_UUID_REFERENCED_BY("nodePerUuid.referencedBy.elements"),
        NODE_UUID_CHILDREN("nodePerUuid.children.elements"),
        NODE_PATH("nodePerPath"),
        NODES("nodes.elements"),
        NODE_UUIDS("uuidNodes.elements"),
        NODE_UUID_INVERTED("nodePerUuid.invNodeType"),
        NODE_INVERTED_UUID("nodePerUuidInverted"),
        NODE_INVERTED_UUID_NOLANG("nodePerUuidInverted.nolang"),
        NODE_INVERTED_UUID_PARENT("nodePerUuidInverted.parent"),
        NODE_INVERTED_UUID_LANGUAGES("nodePerUuidInverted.languages"),
        NODE_INVERTED_UUID_CHILD("nodePerUuidInverted.child"),
        NODE_INVERTED_UUID_BREADCRUMB("nodePerUuidInverted.breadcrumb"),
        NODE_INVERTED_UUID_REFERENCED_BY("nodePerUuidInverted.referencedBy.elements"),
        NODE_INVERTED_UUID_CHILDREN("nodePerUuidInverted.children.elements"),
        NODE_INVERTED_UUID_FIELDS_NODE("nodePerUuidInverted.fields.node"),
        NODE_INVERTED_UUID_FIELDS_NODE_LIST("nodePerUuidInverted.fields.nodeList");

        private String path;

        private TestQuery(String path) {
            this.path = path;
        }

        String path() {
            return this.path;
        }

        public String toString() {
            return this.path();
        }
    }
}

