/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.graphql.AbstractGraphQLSearchEndpointTest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
@RunWith(value=Parameterized.class)
public class GraphQLNodeScrollSearchEndpointTest
extends AbstractGraphQLSearchEndpointTest {
    @Parameterized.Parameters(name="query={0}")
    public static List<String> paramData() {
        ArrayList<String> testQueries = new ArrayList<String>();
        testQueries.add("node-elasticsearch-scroll-query");
        return testQueries;
    }

    public GraphQLNodeScrollSearchEndpointTest(String queryName) {
        super(queryName);
    }

    @Before
    public void createNodes() {
        String parentNodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        for (int i = 0; i < 100; ++i) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNode(new NodeReference().setUuid(parentNodeUuid));
            nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)("test" + i)));
            nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        }
    }
}

