/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class GraphQLNodeSearchEndpointTest
extends AbstractMeshTest {
    @Test
    public void testNodeQueryWithManySchemas() throws Exception {
        this.recreateIndices();
        for (int i = 0; i < 45; ++i) {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("dummy" + i);
            request.addField((FieldSchema)FieldUtil.createHtmlFieldSchema((String)"content"));
            SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        }
        this.waitForSearchIdleEvent();
        String queryName = "node-elasticsearch-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        System.out.println(json.encodePrettily());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions(queryName);
    }
}

