/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.graphql.AbstractGraphQLNodeTest;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.VersioningParameters;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLNodeVersionArgInheritance
extends AbstractGraphQLNodeTest {
    private String version;

    public GraphQLNodeVersionArgInheritance(String version) {
        this.version = version;
    }

    @Parameterized.Parameters(name="params={0}")
    public static Collection<Object[]> paramData() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"none"});
        data.add(new Object[]{"draft"});
        data.add(new Object[]{"published"});
        return data;
    }

    @Before
    public void setupContent() {
        this.setupContents(true);
    }

    @Test
    public void testPermissions() throws IOException {
        String queryName = "node/version-arg";
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery(this.getGraphQLQuery(queryName));
        GraphQLResponse response = null;
        switch (this.version) {
            case "none": {
                response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
                break;
            }
            case "draft": 
            case "published": {
                VersioningParametersImpl params = new VersioningParametersImpl();
                params.setVersion(this.version);
                response = (GraphQLResponse)ClientHelper.call(() -> this.lambda$testPermissions$1(request, (VersioningParameters)params));
            }
        }
        JsonObject jsonResponse = new JsonObject(response.toJson());
        System.out.println(jsonResponse.encodePrettily());
        MeshAssertions.assertThat((JsonObject)jsonResponse).compliesToAssertions(queryName);
        switch (this.version) {
            case "none": {
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.version=1.1");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.version=1.1");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.child.version=1.1");
                break;
            }
            case "draft": {
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.version=1.1");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.version=1.1");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.child.version=1.1");
                break;
            }
            case "published": {
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.version=1.0");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.version=1.0");
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo("$.data.noType.child.child.version=1.1");
            }
        }
    }

    private /* synthetic */ MeshRequest lambda$testPermissions$1(GraphQLRequest request, VersioningParameters params) throws Exception {
        return this.client().graphql("dummy", request, new ParameterProvider[]{params});
    }
}

