/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.rest.common.ObjectPermissionGrantRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.group.GroupCreateRequest;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.role.RoleCreateRequest;
import com.gentics.mesh.core.rest.role.RoleListResponse;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLPermissionQueryTest
extends AbstractMeshTest {
    private final String queryName = "rolePerms";

    @Test
    public void testReadPublishedNodeChildren() throws IOException {
        RoleResponse anonymousRole = ((RoleListResponse)this.client().findRoles(new ParameterProvider[0]).toSingle().blockingGet()).getData().stream().filter(role -> role.getName().equals("anonymous")).findAny().get();
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery(this.getGraphQLQuery("rolePerms"));
        request.setVariables(new JsonObject().put("roleUuid", (Object)anonymousRole.getUuid()));
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        System.out.println(json.encodePrettily());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions("rolePerms");
    }

    @Test
    public void testReadChildrenPermissionsFromDifferentRoles() throws IOException {
        HibProject project = this.project();
        String baseNodeUuid = (String)this.tx(() -> project.getBaseNode().getUuid());
        String userUuid = (String)this.tx(() -> this.user().getUuid());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNode(new NodeReference().setUuid(baseNodeUuid));
        create.setLanguage("en");
        create.setSchemaName("folder");
        create.setGrant(new ObjectPermissionGrantRequest().setExclusive(true).setReadPublished(Arrays.asList((RoleReference)new RoleReference().setName("anonymous"))));
        NodeResponse testNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
        HashMap<String, String> nodeUuids = new HashMap<String, String>();
        for (String string : Arrays.asList("role_one", "role_two", "role_three")) {
            RoleResponse role = (RoleResponse)ClientHelper.call(() -> this.client().createRole(new RoleCreateRequest().setName(name)));
            GroupResponse group = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(new GroupCreateRequest().setName(name)));
            ClientHelper.call(() -> this.client().addRoleToGroup(group.getUuid(), role.getUuid()));
            ClientHelper.call(() -> this.client().addUserToGroup(group.getUuid(), userUuid));
            create.setParentNode(new NodeReference().setUuid(testNode.getUuid()));
            create.setLanguage("en");
            create.setSchemaName("folder");
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)string));
            create.setGrant(new ObjectPermissionGrantRequest().setExclusive(true).setRead(Arrays.asList((RoleReference)new RoleReference().setName(string))).setOthers(true));
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
            nodeUuids.put(string, node.getUuid());
        }
        for (Map.Entry entry : nodeUuids.entrySet()) {
            String name = (String)entry.getKey();
            String nodeUuid = (String)entry.getValue();
            ArrayList<String> granted = new ArrayList<String>(Arrays.asList("role_one", "role_two", "role_three"));
            granted.remove(name);
            List grantedRoles = granted.stream().map(n -> (RoleReference)new RoleReference().setName(n)).collect(Collectors.toList());
            ClientHelper.call(() -> this.client().grantNodeRolePermissions("dummy", nodeUuid, new ObjectPermissionGrantRequest().setExclusive(true).setUpdate(grantedRoles)));
        }
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery(this.getGraphQLQuery("childrenPerms"));
        request.setVariables(new JsonObject().put("nodeUuid", (Object)testNode.getUuid()));
        GraphQLResponse graphQLResponse = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
        JsonObject json = new JsonObject(graphQLResponse.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions("childrenPerms");
        Collection nodeNames = (Collection)JsonPath.read((String)json.encodePrettily(), (String)"$.data.node.children.elements[*].fields.name", (Predicate[])new Predicate[0]);
        MeshAssertions.assertThat((Iterable)nodeNames).as("Returned nodes", new Object[0]).containsOnly((Object[])new String[]{"role_one", "role_two", "role_three"});
    }
}

