/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
@RunWith(value=Parameterized.class)
public class GraphQLPermissionTest
extends AbstractMeshTest {
    @Parameterized.Parameter(value=0)
    public String version;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> paramData() {
        return Arrays.asList({"draft"}, {"published"});
    }

    @Test
    public void testReadPublishedNodeChildren() throws IOException {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().publishNode("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        String dealsUuid = (String)this.tx(() -> this.folder("deals").getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", dealsUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            NodeDao nodeDao = tx.nodeDao();
            for (HibNode node : nodeDao.findAll((HibCoreElement)this.project())) {
                roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("news"), new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        String queryName2 = "node-perm-children-query." + this.version;
        GraphQLResponse response2 = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName2), new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        JsonObject json2 = new JsonObject(response2.toJson());
        System.out.println(json2.encodePrettily());
        MeshAssertions.assertThat((JsonObject)json2).compliesToAssertions(queryName2);
    }
}

