/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.plugin.AbstractPluginTest;
import com.gentics.mesh.plugin.ClonePlugin;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.PluginTests;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={PluginTests.class})
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLPluginTest
extends AbstractPluginTest {
    @Test
    public void testGraphQL() throws IOException {
        this.grantAdmin();
        for (int i = 1; i <= 100; ++i) {
            this.deployPlugin(ClonePlugin.class, "clone" + i);
        }
        this.waitForPluginRegistration();
        String queryName = "plugin/plugin-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions(queryName);
    }

    @Test
    public void testGraphQLPlugin() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/graphql/target/graphql-plugin-0.0.1-SNAPSHOT.jar", "graphql.jar");
        this.waitForPluginRegistration();
        String queryName = "plugin/graphql-plugin-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions(queryName);
    }

    @Test
    public void testInvalidGraphQLPlugin() throws IOException {
        this.grantAdmin();
        this.copyAndDeploy("/test-plugins/invalid-graphql/target/invalid-graphql-plugin-0.0.1-SNAPSHOT.jar", "graphql.jar", HttpResponseStatus.BAD_REQUEST, "admin_plugin_error_invalid_gql_name", "invalid-plugin");
    }
}

