/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.graphql.AbstractGraphQLNodeTest;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLPublishedMatchingDraftNodePermissionTest
extends AbstractGraphQLNodeTest {
    private final String query;
    private final String version;
    public static final String CHECK_PERM = "checkperm:";

    public GraphQLPublishedMatchingDraftNodePermissionTest(String query, String version) {
        this.query = query;
        this.version = version;
    }

    @Parameterized.Parameters(name="query={0}, version={1}")
    public static Collection<Object[]> parameters() {
        List<String> queries = Arrays.asList("rootNode", "nodePerUuid", "nodePerPath");
        List<String> versions = Arrays.asList("draft", "published");
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String query : queries) {
            for (String version : versions) {
                data.add(new Object[]{query, version});
            }
        }
        return data;
    }

    private void setupContent() {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest schemaRequest = new SchemaCreateRequest();
        schemaRequest.setName("test");
        schemaRequest.setContainer(Boolean.valueOf(true));
        schemaRequest.setSegmentField("name");
        schemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"extra"));
        schemaRequest.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"node"));
        schemaRequest.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"nodeList").setListType("node"));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        NodeUpdateRequest rootNodeUpdateRequest = new NodeUpdateRequest();
        rootNodeUpdateRequest.setLanguage("en");
        rootNodeUpdateRequest.getFields().putString("name", "root");
        ClientHelper.call(() -> this.client().updateNode("dummy", baseNodeUuid, rootNodeUpdateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
    }

    public void setupPermissions() {
        RolePermissionRequest permRequest = new RolePermissionRequest();
        PermissionInfo permissionsInfo = permRequest.getPermissions();
        permissionsInfo.set(Permission.READ_PUBLISHED, true);
        permissionsInfo.setOthers(false);
        permRequest.setRecursive(Boolean.valueOf(true));
        this.adminCall(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes", permRequest));
    }

    @Test
    public void test() throws IOException {
        this.setupContent();
        this.setupPermissions();
        GraphQLRequest request = new GraphQLRequest();
        String queryName = "node/publishedmatchingdraft/" + this.query;
        JsonObject var = new JsonObject();
        var.put("uuid", this.tx(() -> this.project().getBaseNode().getUuid()));
        var.put("type", (Object)this.version);
        request.setVariables(var);
        request.setQuery(this.getGraphQLQuery(queryName));
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
        JsonObject jsonResponse = new JsonObject(response.toJson());
        System.out.println(jsonResponse.encodePrettily());
        System.out.println("Query: " + queryName);
        this.compliesToAssertions(jsonResponse, queryName);
    }

    private void compliesToAssertions(JsonObject jsonResponse, String queryName) throws IOException {
        String query = this.getGraphQLQuery(queryName);
        try (Scanner scanner = new Scanner(query);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!(line = line.trim()).startsWith("# [")) continue;
                int start = line.indexOf("# [") + 3;
                int end = line.lastIndexOf("]");
                String selector = line.substring(start, end);
                int ab = line.indexOf("=", end) + 1;
                String assertion = line.substring(ab);
                String currentSelector = "select_" + this.version;
                if (!currentSelector.equalsIgnoreCase(selector)) continue;
                if (assertion.startsWith(CHECK_PERM)) {
                    String permPath = assertion.substring(CHECK_PERM.length());
                    MeshAssertions.assertThat((JsonObject)jsonResponse).hasPermFailure(permPath);
                    continue;
                }
                MeshAssertions.assertThat((JsonObject)jsonResponse).compliesTo(assertion);
            }
        }
    }
}

