/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.Rug;
import com.gentics.mesh.test.util.TestUtils;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLReferencedByTest
extends AbstractMeshTest {
    private NodeResponse sourceNode;
    private NodeResponse targetNode;

    @Before
    public void setUp() throws Exception {
        this.createSchema();
        this.targetNode = this.readNode(this.projectName(), (String)this.tx(() -> this.folder("2015").getUuid()));
        this.sourceNode = this.createReferenceNode(this.targetNode.getUuid());
    }

    @Test
    public void testAllReferences() throws IOException {
        JsonArray responseData = this.query("basic-query");
        String sourceUuid = this.sourceNode.getUuid();
        MeshAssertions.assertThat((JsonArray)responseData).containsJsonObjectHashesInAnyOrder(obj -> Objects.hash(obj.getString("fieldName"), obj.getString("micronodeFieldName"), obj.getJsonObject("node").getString("uuid")), new Integer[]{Objects.hash("simpleNodeRef", null, sourceUuid), Objects.hash("listNodeRef", null, sourceUuid), Objects.hash("simpleMicronode", "microSimpleNodeRef", sourceUuid), Objects.hash("simpleMicronode", "microListNodeRef", sourceUuid), Objects.hash("listMicronode", "microSimpleNodeRef", sourceUuid), Objects.hash("listMicronode", "microListNodeRef", sourceUuid)});
    }

    @Test
    public void testPagedReferences() throws IOException {
        JsonArray responseData = this.query("paged-query");
        Assert.assertEquals((String)"The array should only contain two elements.", (long)2L, (long)responseData.size());
    }

    @Test
    public void testPermissions() throws IOException {
        Rug tester = this.createUserGroupRole("tester");
        this.client().updateRolePermissions(tester.getRole().getUuid(), String.format("/projects/%s/nodes/%s", this.projectUuid(), this.targetNode.getUuid()), RolePermissionRequest.withPermissions((Permission[])new Permission[]{Permission.READ})).blockingAwait();
        this.client().setLogin(tester.getUser().getUsername(), "test1234");
        this.client().login().blockingGet();
        JsonArray resultData = this.query("basic-query");
        MeshAssertions.assertThat((List)resultData.getList()).isEmpty();
    }

    private JsonArray query(String queryCaseName) throws IOException {
        String queryName = "referencedBy/" + queryCaseName;
        GraphQLResponse response = this.graphQl(this.getGraphQLQuery(queryName), Collections.singletonMap("uuid", this.targetNode.getUuid()));
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions(queryName);
        return response.getData().getJsonObject("node").getJsonObject("referencedBy").getJsonArray("elements");
    }

    private GraphQLResponse graphQl(String query, Map<String, Object> variables) {
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery(query);
        request.setVariables(new JsonObject(variables));
        return (GraphQLResponse)this.client().graphql("dummy", request, new ParameterProvider[0]).blockingGet();
    }

    private SchemaResponse createSchema() {
        String projectName = this.projectName();
        SchemaCreateRequest schemaRequest = (SchemaCreateRequest)JsonUtil.readValue((String)TestUtils.getResourceAsString((String)"/graphql/referencedBy/schema.json"), SchemaCreateRequest.class);
        MicroschemaCreateRequest microschemaRequest = (MicroschemaCreateRequest)JsonUtil.readValue((String)TestUtils.getResourceAsString((String)"/graphql/referencedBy/microschema.json"), MicroschemaCreateRequest.class);
        return (SchemaResponse)Single.zip((SingleSource)this.client().createSchema(schemaRequest, new ParameterProvider[0]).toSingle().flatMap(schemaResponse -> this.client().assignSchemaToProject(projectName, schemaResponse.getUuid()).toSingle()), (SingleSource)this.client().createMicroschema(microschemaRequest).toSingle().flatMap(microschemaResponse -> this.client().assignMicroschemaToProject(projectName, microschemaResponse.getUuid()).toSingle()), (schema, ignore) -> schema).blockingGet();
    }

    private NodeResponse createReferenceNode(String uuid) {
        NodeCreateRequest request = (NodeCreateRequest)JsonUtil.readValue((String)TestUtils.getResourceAsString((String)"/graphql/referencedBy/refNode.json").replaceAll("%UUID%", uuid), NodeCreateRequest.class);
        return (NodeResponse)this.client().createNode(this.projectName(), request, new ParameterProvider[0]).blockingGet();
    }
}

