/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class GraphQLSearchPermissionTest
extends AbstractMeshTest {
    @Test
    public void testReadPublishPerm() throws Exception {
        try (Tx tx2 = this.tx();){
            this.recreateIndices();
        }
        String queryName = "node-elasticsearch-perm-query";
        NodeResponse response = this.createNode("slug", (Field)FieldUtil.createStringField((String)"blaar"));
        ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.getFields().putString("name", "ABCD");
        nodeUpdateRequest.setLanguage("en");
        ClientHelper.call(() -> this.client().updateNode("dummy", response.getUuid(), nodeUpdateRequest, new ParameterProvider[0]));
        this.assertSearch(queryName, 1, 1);
        RolePermissionRequest request = new RolePermissionRequest();
        request.getPermissions().setRead(Boolean.valueOf(false));
        request.getPermissions().setReadPublished(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        this.assertSearch(queryName, 0, 1);
        this.tx(tx -> tx.roleDao().grantPermissions(this.role(), (HibBaseElement)tx.nodeDao().findByUuid((HibCoreElement)this.project(), response.getUuid()), new InternalPermission[]{InternalPermission.READ_PERM}));
        request.getPermissions().setReadPublished(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "/projects/dummy/nodes/" + response.getUuid(), request));
        this.assertSearch(queryName, 0, 0);
    }

    private void assertSearch(String queryName, int expectedDraftResults, int expectedPublishedResults) throws IOException {
        String version;
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions(queryName);
        JsonArray draftElements = (JsonArray)JsonPointer.from((String)"/data/dresult/elements").queryJson((Object)json);
        JsonArray publishedElements = (JsonArray)JsonPointer.from((String)"/data/presult/elements").queryJson((Object)json);
        MeshAssertions.assertThat((int)draftElements.size()).isEqualTo(expectedDraftResults);
        if (expectedDraftResults != 0) {
            version = draftElements.getJsonObject(0).getString("version");
            Assert.assertEquals((Object)"1.1", (Object)version);
        }
        MeshAssertions.assertThat((int)publishedElements.size()).isEqualTo(expectedPublishedResults);
        if (expectedPublishedResults != 0) {
            version = publishedElements.getJsonObject(0).getString("version");
            Assert.assertEquals((Object)"1.0", (Object)version);
        }
    }
}

