/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.ParameterProviderContext;
import com.gentics.mesh.parameter.impl.SearchParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.MeshTestContextOverride;
import com.gentics.mesh.util.SearchWaitUtil;
import io.reactivex.Completable;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class GraphQLWaitSearchDurationEndpointTest
extends AbstractMeshTest {
    private static final String QUERY_WITH_ES_NAME = "wait-duration-query";
    private static final String QUERY_WITHOUT_ES_NAME = "wait-duration-filter-query";
    private static final String SEARCH_UUID = "00112233445566778899aabbccddeeff";
    private static final SearchWaitUtil waitUtil = (SearchWaitUtil)Mockito.mock(SearchWaitUtil.class);
    @Rule
    @ClassRule
    public static final MeshTestContextOverride testContext;
    @Parameterized.Parameter(value=0)
    public boolean searchWithQuery;
    @Parameterized.Parameter(value=1)
    public boolean waitForSearch;

    @Override
    public MeshTestContext getTestContext() {
        return testContext;
    }

    @Parameterized.Parameters(name="{index}: searchWithQuery={0}, waitForEach={1}")
    public static Collection<Object[]> paramData() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @Before
    public void setup() {
        Mockito.when((Object)waitUtil.delayRequested((ParameterProviderContext)Mockito.any())).thenReturn((Object)this.waitForSearch);
        Mockito.clearInvocations((Object[])new SearchWaitUtil[]{waitUtil});
    }

    @Test
    public void testGraphQLEndpointWaiting() {
        GraphQLResponse res = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", new GraphQLRequest().setQuery(this.getGraphQLQuery(this.searchWithQuery ? QUERY_WITH_ES_NAME : QUERY_WITHOUT_ES_NAME)).setVariables(this.buildVariables()), new ParameterProvider[]{new SearchParametersImpl().setWait(this.waitForSearch)}));
        Assert.assertTrue((res.getErrors() == null || res.getErrors().isEmpty() ? 1 : 0) != 0);
        if (this.searchWithQuery && this.waitForSearch) {
            ((SearchWaitUtil)Mockito.verify((Object)waitUtil)).awaitSync((ParameterProviderContext)Mockito.any());
        } else {
            ((SearchWaitUtil)Mockito.verify((Object)waitUtil, (VerificationMode)Mockito.never())).awaitSync((ParameterProviderContext)Mockito.any());
        }
    }

    private JsonObject buildVariables() {
        if (this.searchWithQuery) {
            return new JsonObject().put("query", (Object)"{\"query\":{\"term\":{\"uuid\":\"00112233445566778899aabbccddeeff\"}}}");
        }
        return new JsonObject().put("uuid", (Object)SEARCH_UUID);
    }

    static {
        Mockito.when((Object)waitUtil.awaitSync((ParameterProviderContext)Mockito.any())).thenAnswer(params -> Completable.complete());
        testContext = new MeshTestContextOverride().setWaitUtil(waitUtil);
    }
}

