/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.SearchParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class GraphQLWaitSearchEndpointTest
extends AbstractMultiESTest {
    private final String QUERY_NAME = "wait-query";
    private final String FIELD_NAME = "slug";
    private final String FIELD_VALUE = "waittest";

    public GraphQLWaitSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Before
    public void setUp() {
        this.createNode("slug", (Field)new StringFieldImpl().setString("waittest"));
    }

    @Test
    public void queryWithWait() {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery("wait-query"), new ParameterProvider[]{new SearchParametersImpl().setWait(true)}));
        JsonObject json = new JsonObject(response.toJson());
        Assertions.assertThat((Object)json.getValue("errors")).isNull();
        JsonArray elements = json.getJsonObject("data", new JsonObject()).getJsonObject("nodes", new JsonObject()).getJsonArray("elements", new JsonArray());
        Assertions.assertThat((int)elements.size()).isEqualTo(1);
        Assertions.assertThat((String)elements.getJsonObject(0).getJsonObject("fields").getString("slug")).isEqualTo((Object)"waittest");
    }

    @Test
    public void queryWithoutWait() {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery("wait-query"), new ParameterProvider[]{new SearchParametersImpl().setWait(false)}));
        JsonObject json = new JsonObject(response.toJson());
        Assertions.assertThat((Object)json.getValue("errors")).isNull();
        JsonArray elements = json.getJsonObject("data", new JsonObject()).getJsonObject("nodes", new JsonObject()).getJsonArray("elements", new JsonArray());
        Assertions.assertThat((int)elements.size()).isEqualTo(0);
    }
}

