/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.List;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLWebrootTest
extends AbstractMeshTest {
    @Test
    public void testWebrootPrefix() throws IOException {
        String queryName = "webroot/node-webroot-path-prefix-query";
        String prefix = "some/prefix";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix("some/prefix");
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery("webroot/node-webroot-path-prefix-query"), new ParameterProvider[0]));
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions("webroot/node-webroot-path-prefix-query");
    }

    @Test
    public void testSlashInPath() throws IOException {
        String getUuidByPath = "webroot/get-uuid-by-path";
        String getPathbyUuid = "webroot/get-path-by-uuid";
        String uuid = "54a49cc79c684a2da407710a39427f6b";
        String parentUuid = ((ProjectResponse)((ProjectListResponse)this.client().findProjects(new ParameterProvider[0]).blockingGet()).getData().get(0)).getRootNode().getUuid();
        NodeCreateRequest request = new NodeCreateRequest();
        request.setParentNodeUuid(parentUuid);
        request.setSchemaName("folder");
        request.setLanguage("en");
        request.getFields().put("slug", (Field)new StringFieldImpl().setString("2015/2016"));
        this.client().createNode("54a49cc79c684a2da407710a39427f6b", "dummy", request, new ParameterProvider[0]).blockingAwait();
        NodeResponse test = (NodeResponse)this.client().findNodeByUuid("dummy", "54a49cc79c684a2da407710a39427f6b", new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}).blockingGet();
        GraphQLResponse response = this.singleParameterQuery("webroot/get-path-by-uuid", "uuid", "54a49cc79c684a2da407710a39427f6b");
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions("webroot/get-path-by-uuid");
        String resultPath = response.getData().getJsonObject("node").getString("path");
        MeshAssertions.assertThat((String)resultPath).isEqualTo((Object)"/2015%2F2016");
        response = this.singleParameterQuery("webroot/get-uuid-by-path", "path", resultPath);
        MeshAssertions.assertThat((String)response.getData().getJsonObject("node").getString("uuid")).isEqualTo((Object)"54a49cc79c684a2da407710a39427f6b");
    }

    @Test
    public void testRootNodeInBranch() throws IOException {
        String getUuidByPath = "webroot/get-uuid-by-path";
        String projectName = "testProject";
        String newBranchName = "test1";
        ProjectResponse project = this.createProject("testProject");
        this.grantAdmin();
        this.waitForJobs(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName("test1");
            branchCreateRequest.setLatest(false);
            ClientHelper.call(() -> this.client().createBranch("testProject", branchCreateRequest, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        this.revokeAdmin();
        NodeResponse request = new NodeResponse();
        request.setUuid(project.getRootNode().getUuid());
        ClientHelper.call(() -> this.client().publishNode("testProject", project.getRootNode().getUuid(), new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("testProject", project.getRootNode().getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch("test1")}));
        RolePermissionRequest permissionRequest = new RolePermissionRequest();
        permissionRequest.getPermissions().setOthers(false, true).add(Permission.READ_PUBLISHED);
        ClientHelper.call(() -> this.client().updateRolePermissions(this.roleUuid(), "projects/testProject/nodes/" + project.getRootNode().getUuid(), permissionRequest));
        GraphQLResponse response = (GraphQLResponse)this.client().graphql("testProject", new GraphQLRequest().setQuery(this.getGraphQLQuery("webroot/get-uuid-by-path")).setVariables(new JsonObject().put("path", (Object)"/")), new ParameterProvider[]{new VersioningParametersImpl().published().setBranch("test1")}).blockingGet();
        MeshAssertions.assertThat((List)response.getErrors()).isNull();
        MeshAssertions.assertThat((String)response.getData().getJsonObject("node").getString("uuid")).isEqualTo((Object)project.getRootNode().getUuid());
    }

    private GraphQLResponse singleParameterQuery(String queryName, String parameterName, String parameterValue) throws IOException {
        return (GraphQLResponse)this.client().graphql("dummy", new GraphQLRequest().setQuery(this.getGraphQLQuery(queryName)).setVariables(new JsonObject().put(parameterName, (Object)parameterValue)), new ParameterProvider[0]).blockingGet();
    }
}

