/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.group;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GroupEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String etag = ClientHelper.callETag(() -> this.client().findGroups(new ParameterProvider[0]));
            Assert.assertNotNull((Object)etag);
            ClientHelper.callETag(() -> this.client().findGroups(new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadWithoutETag() {
        String etag = ClientHelper.callETagRaw(() -> this.client().findGroups(new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
        etag = ClientHelper.callETagRaw(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            HibGroup group = this.group();
            String actualEtag = ClientHelper.callETag(() -> this.client().findGroupByUuid(group.getUuid(), new ParameterProvider[0]));
            String etag = groupDao.getETag((HibTransformableElement)group, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)actualEtag);
            ClientHelper.callETag(() -> this.client().findGroupByUuid(group.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findGroupByUuid(group.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findGroupByUuid(group.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findGroupByUuid(group.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
        }
    }

    @Test
    public void testLinkingEtagHandling() {
        String groupUuid = this.groupUuid();
        UserResponse user2 = (UserResponse)ClientHelper.call(() -> this.client().createUser(new UserCreateRequest().setUsername("someUser").setPassword("test"), new ParameterProvider[0]));
        String userUuid = user2.getUuid();
        String before = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().addUserToGroup(groupUuid, userUuid));
        String after = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
        Assert.assertNotEquals((String)"Adding the user should have changed the etag.", (Object)before, (Object)after);
    }
}

