/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.group;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.group.GroupCreateRequest;
import com.gentics.mesh.core.rest.group.GroupListResponse;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.group.GroupUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT, startServer=true)
public class GroupEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Test
    public void testCreate() throws Exception {
        GroupCreateRequest request = new GroupCreateRequest();
        request.setName("test12345");
        this.expect(MeshEvent.GROUP_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("test12345")).uuidNotNull()).one();
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(request));
        MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibGroup.composeIndexName(), restGroup.getUuid());
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        this.trackingSearchProvider().clear().blockingAwait();
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)tx.groupDao().findByUuid(restGroup.getUuid()));
        }
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        GroupCreateRequest request = new GroupCreateRequest();
        request.setName("test12345");
        String groupRootUuid = (String)this.db().tx(tx -> tx.data().permissionRoots().group().getUuid());
        try (Tx tx2 = this.tx();){
            RoleDao roleDao = tx2.roleDao();
            roleDao.revokePermissions(this.role(), tx2.data().permissionRoots().group(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx2.success();
        }
        ClientHelper.call(() -> this.client().createGroup(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{groupRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        String name = "New Name";
        String uuid = UUIDUtil.randomUUID();
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("New Name");
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().updateGroup(uuid, request));
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibGroup.composeIndexName(), uuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
            HibGroup reloadedGroup = (HibGroup)tx.groupDao().findByUuid(uuid);
            Assert.assertEquals((String)"The group should have been updated", (Object)"New Name", (Object)reloadedGroup.getName());
        }
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        String name = "New Name";
        String uuid = this.projectUuid();
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("New Name");
        ClientHelper.call(() -> this.client().updateGroup(uuid, request), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
    }

    @Test
    public void testBatchCreation() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibBaseElement root = tx.data().permissionRoots().group();
            roleDao.grantPermissions(this.role(), root, new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        for (int i = 0; i < 10; ++i) {
            System.out.println(i);
            String name = "test_" + i;
            GroupCreateRequest request = new GroupCreateRequest();
            request.setName(name);
            GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(request));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
        }
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(10L, 0L, 0L, 0L, 0L);
    }

    @Test
    public void testConflicingGroupCreation() throws Exception {
        String name = "test12345";
        GroupCreateRequest request = new GroupCreateRequest();
        request.setName("test12345");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), tx.data().permissionRoots().group(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(request));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
            Assert.assertNotNull((Object)tx.groupDao().findByUuid(restGroup.getUuid()));
            ClientHelper.call(() -> this.client().createGroup(request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"group_conflicting_name", (String[])new String[]{"test12345"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        try (Tx tx = this.tx();){
            String name = "test12345";
            GroupCreateRequest request = new GroupCreateRequest();
            request.setName("test12345");
            GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(request));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
            HibGroup foundGroup = (HibGroup)tx.groupDao().findByUuid(restGroup.getUuid());
            Assert.assertNotNull((String)"Group should have been created.", (Object)foundGroup);
            ClientHelper.call(() -> this.client().findGroupByUuid(restGroup.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().deleteGroup(restGroup.getUuid()));
        }
    }

    @Test
    public void testCreateGroupWithMissingName() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        GroupCreateRequest request = new GroupCreateRequest();
        ClientHelper.call(() -> this.client().createGroup(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_name_must_be_set", (String[])new String[0]);
    }

    @Test
    public void testCreateGroupWithNoPerm() throws Exception {
        String name = "test12345";
        GroupCreateRequest request = new GroupCreateRequest();
        request.setName("test12345");
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibBaseElement root = tx.data().permissionRoots().group();
            roleDao.revokePermissions(this.role(), root, new InternalPermission[]{InternalPermission.CREATE_PERM});
            Assert.assertFalse((String)"The create permission to the groups root node should have been revoked.", (boolean)userDao.hasPermission(this.user(), root, InternalPermission.CREATE_PERM));
        });
        String rootUuid = (String)this.db().tx(() -> Tx.get().data().permissionRoots().group().getUuid());
        ClientHelper.call(() -> this.client().createGroup(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{rootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        int initialGroupCount = this.groups().size();
        String extraGroupName = "no_perm_group";
        int nGroups = 21;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            groupDao.create("no_perm_group", this.user());
            for (int i = 0; i < 21; ++i) {
                HibGroup group = groupDao.create("group_" + i, this.user());
                roleDao.grantPermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        int totalGroups = 0;
        totalGroups = 21 + this.data().getGroups().size();
        GroupListResponse listResponse = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[0]));
        Assert.assertNull((Object)listResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)listResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)(initialGroupCount + 21), (long)listResponse.getData().size());
        long perPage = 6L;
        listResponse = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(3, Long.valueOf(perPage))}));
        Assert.assertEquals((long)perPage, (long)listResponse.getData().size());
        int totalPages = (int)Math.ceil((double)totalGroups / (double)perPage);
        Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)perPage, (long)listResponse.getData().size());
        Assert.assertEquals((long)3L, (long)listResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)("We expect {" + totalGroups + "} groups and with a paging size of {" + perPage + "} exactly {" + totalPages + "} pages."), (long)totalPages, (long)listResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)perPage, (long)listResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)totalGroups, (long)listResponse.getMetainfo().getTotalCount());
        ArrayList allGroups = new ArrayList();
        int page = 1;
        while (page <= totalPages) {
            int currentPage = page++;
            listResponse = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(currentPage, Long.valueOf(perPage))}));
            allGroups.addAll(listResponse.getData());
        }
        Assert.assertEquals((String)"Somehow not all groups were loaded when loading all pages.", (long)totalGroups, (long)allGroups.size());
        List filteredUserList = allGroups.parallelStream().filter(restGroup -> restGroup.getName().equals("no_perm_group")).collect(Collectors.toList());
        Assert.assertTrue((String)"Extra group should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
        ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(perPage))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
        ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
        GroupListResponse response = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(1L))}));
        Assert.assertEquals((long)0L, (long)response.getData().size());
        Assert.assertEquals((long)4242L, (long)response.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)(21 + initialGroupCount), (long)response.getMetainfo().getPageCount());
        Assert.assertEquals((long)(21 + initialGroupCount), (long)response.getMetainfo().getTotalCount());
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getPerPage());
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{param})), GroupResponse::getName, "name", "List of group names");
    }

    @Test
    public void testReadMetaCountOnly() {
        GroupListResponse list = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}));
        Assert.assertEquals((long)0L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        GroupResponse response = (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((GroupResponse)response).matches(this.group());
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        GroupResponse response = (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}));
        Assert.assertNotNull((Object)response.getRolePerms());
        MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).hasPerm(new Permission[]{Permission.READ, Permission.UPDATE, Permission.DELETE, Permission.CREATE});
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibGroup group = this.group();
            roleDao.revokePermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.READ_PERM});
            Assert.assertNotNull((String)"The UUID of the group must not be null.", (Object)group.getUuid());
            tx.success();
        }
        ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadGroupWithBogusUUID() throws Exception {
        String bogusUuid = "sadgasdasdg";
        ClientHelper.call(() -> this.client().findGroupByUuid("sadgasdasdg", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"sadgasdasdg"});
    }

    @Override
    @Test
    public void testUpdate() throws GenericRestException, Exception {
        String name = "New Name";
        String groupUuid = this.groupUuid();
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("New Name");
        this.expect(MeshEvent.GROUP_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("New Name")).hasUuid(groupUuid)).total(1L);
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().updateGroup(groupUuid, request));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibGroup.composeIndexName(), groupUuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), this.userUuid());
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(2L, 0L, 0L, 0L, 0L);
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(request);
            HibGroup reloadedGroup = (HibGroup)tx.groupDao().findByUuid(groupUuid);
            Assert.assertEquals((String)"The group should have been updated", (Object)"New Name", (Object)reloadedGroup.getName());
        }
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("new Name");
        ClientHelper.call(() -> this.client().updateGroup(this.groupUuid(), request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testUpdateGroupWithEmptyName() throws GenericRestException, Exception {
        String oldName;
        String name = "";
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibGroup group = this.group();
            oldName = group.getName();
            roleDao.grantPermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().updateGroup(this.groupUuid(), request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_name_must_be_set", (String[])new String[0]);
        tx = this.tx();
        try {
            HibGroup reloadedGroup = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            Assert.assertEquals((String)"The group should not have been updated", (Object)oldName, (Object)reloadedGroup.getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUpdateGroupWithSameName() throws GenericRestException, Exception {
        String name = (String)this.tx(() -> this.group().getName());
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName(name);
        this.expect(MeshEvent.GROUP_UPDATED).none();
        ClientHelper.call(() -> this.client().updateGroup(this.groupUuid(), request));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            HibGroup reloadedGroup = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            Assert.assertEquals((String)"The group should be the same", (Object)name, (Object)reloadedGroup.getName());
        }
    }

    @Test
    public void testUpdateGroupWithConflictingName() throws GenericRestException, Exception {
        String alreadyUsedName = "extraGroup";
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("extraGroup");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            Assert.assertNotNull((Object)groupDao.create("extraGroup", this.user()));
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().updateGroup(this.groupUuid(), request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"group_conflicting_name", (String[])new String[]{"extraGroup"});
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            HibGroup reloadedGroup = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            Assert.assertEquals((String)"The group should not have been updated", (Object)this.group().getName(), (Object)reloadedGroup.getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadWithRolePermsSync() throws Exception {
        int groupCount = 100;
        GroupCreateRequest createReq = new GroupCreateRequest();
        for (int i = 0; i < groupCount; ++i) {
            createReq.setName("testGroup" + i);
            ClientHelper.call(() -> this.client().createGroup(createReq));
        }
        int readCount = 100;
        for (int i = 0; i < readCount; ++i) {
            GroupListResponse res = (GroupListResponse)ClientHelper.call(() -> this.client().findGroups(new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}));
            for (GroupResponse grp : res.getData()) {
                String msg = String.format("Role perms was null after try %d at %s (%s)", i + 1, grp.getName(), grp.getUuid());
                Assert.assertNotNull((String)msg, (Object)grp.getRolePerms());
            }
        }
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        String name = "New Name";
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("New Name");
        ClientHelper.call(() -> this.client().updateGroup("bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        String name = (String)this.tx(() -> this.group().getName());
        String uuid = this.groupUuid();
        this.expect(MeshEvent.GROUP_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(name)).hasUuid(uuid)).total(1L);
        ClientHelper.call(() -> this.client().deleteGroup(uuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibGroup.composeIndexName(), uuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), this.userUuid());
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 1L, 0L, 0L);
        try (Tx tx = this.tx();){
            Assert.assertNull((Object)tx.groupDao().findByUuid(uuid));
        }
    }

    @Test
    public void testDeleteCase2() {
        GroupResponse group2 = (GroupResponse)ClientHelper.call(() -> this.client().createGroup(new GroupCreateRequest().setName("group2")));
        String groupUuid = group2.getUuid();
        ClientHelper.call(() -> this.client().addRoleToGroup(groupUuid, this.roleUuid()));
        ClientHelper.call(() -> this.client().addUserToGroup(groupUuid, this.userUuid()));
        ClientHelper.call(() -> this.client().deleteGroup(this.groupUuid()));
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().deleteGroup(this.groupUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
            Assert.assertNotNull((Object)tx.groupDao().findByUuid(this.groupUuid()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testUpdateMultithreaded() throws InterruptedException {
        GroupUpdateRequest request = new GroupUpdateRequest();
        request.setName("changed");
        int nJobs = 5;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().updateGroup(this.group().getUuid(), request));
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testReadByUuidMultithreaded() throws InterruptedException {
        int nJobs = 10;
        String uuid = this.user().getUuid();
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findGroupByUuid(uuid, new ParameterProvider[0]));
    }

    @Override
    @Test
    public void testDeleteByUUIDMultithreaded() throws InterruptedException {
        int nJobs = 10;
        String uuid = (String)this.tx(() -> this.group().getUuid());
        ClientHelper.validateDeletion(i -> this.client().deleteGroup(uuid), (int)nJobs);
    }

    @Override
    @Test
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 50;
        MeshTestHelper.validateCreation(nJobs, i -> {
            GroupCreateRequest request = new GroupCreateRequest();
            request.setName("test12345_" + i);
            return this.client().createGroup(request);
        });
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws InterruptedException {
        int nJobs = 200;
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]).toCompletable()).blockingAwait();
    }

    @Override
    @Test
    public void testPermissionResponse() {
        GroupResponse group = (GroupResponse)((GroupListResponse)this.client().findGroups(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)group.getPermissions()).hasNoPublishPermsSet();
    }
}

