/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.group;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.PersistingGroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.AbstractNameUuidReference;
import com.gentics.mesh.core.rest.event.group.GroupRoleAssignModel;
import com.gentics.mesh.core.rest.group.GroupReference;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.role.RoleListResponse;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PagingParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT, startServer=true)
public class GroupRolesEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadRolesByGroup() throws Exception {
        String roleUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            HibRole extraRole = roleDao.create("extraRole", this.user());
            HibGroup group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            groupDao.addRole(group, extraRole);
            groupDao.mergeIntoPersisted((HibBaseElement)group);
            roleUuid = extraRole.getUuid();
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        RoleListResponse roleList = (RoleListResponse)ClientHelper.call(() -> this.client().findRolesForGroup(this.groupUuid(), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(25L))}));
        ((AbstractLongAssert)MeshAssertions.assertThat((long)roleList.getMetainfo().getTotalCount()).as("Total count", new Object[0])).isEqualTo(2L);
        RoleResponse expectedTestRole = new RoleResponse();
        RoleResponse expectedExtraRole = new RoleResponse();
        try (Tx tx = this.tx();){
            expectedTestRole.setUuid(this.role().getUuid());
            expectedTestRole.setName(this.role().getName());
            expectedExtraRole.setUuid(roleUuid);
            expectedExtraRole.setName("extraRole");
        }
        ((AbstractListAssert)MeshAssertions.assertThat((List)roleList.getData()).as("Roles of group", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new RoleResponse[]{expectedTestRole, expectedExtraRole});
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            HibRole extraRole = (HibRole)roleDao.findByUuid(roleUuid);
            roleDao.revokePermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        roleList = (RoleListResponse)ClientHelper.call(() -> this.client().findRolesForGroup(this.groupUuid(), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(25L))}));
        ((AbstractLongAssert)MeshAssertions.assertThat((long)roleList.getMetainfo().getTotalCount()).as("Total count", new Object[0])).isEqualTo(1L);
        ((AbstractListAssert)MeshAssertions.assertThat((List)roleList.getData()).as("Roles of group", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new RoleResponse[]{expectedTestRole});
    }

    @Test
    public void testAddRoleToGroup() throws Exception {
        String roleName = "extraRole";
        String groupName = (String)this.tx(() -> this.group().getName());
        String groupUuid = this.groupUuid();
        String roleUuid = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            HibRole extraRole = roleDao.create(roleName, this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            Assert.assertEquals((long)1L, (long)groupDao.getRoles(this.group()).count());
            return extraRole.getUuid();
        });
        this.waitAndClearSearchIdleEvents();
        this.expect(MeshEvent.GROUP_ROLE_ASSIGNED).match(1, GroupRoleAssignModel.class, event -> {
            GroupReference group = event.getGroup();
            Assert.assertNotNull((Object)group);
            Assert.assertEquals((String)"The group name was not set.", (Object)groupName, (Object)group.getName());
            Assert.assertEquals((String)"The group uuid was not set.", (Object)groupUuid, (Object)group.getUuid());
            RoleReference role = event.getRole();
            Assert.assertNotNull((Object)role);
            Assert.assertEquals((String)"The role name was not set.", (Object)roleName, (Object)role.getName());
            Assert.assertEquals((String)"The role uuid was not set.", (Object)roleUuid, (Object)role.getUuid());
        }).one();
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        this.expect(MeshEvent.GROUP_ROLE_ASSIGNED).none();
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleUuid));
        this.awaitEvents();
        try (Tx tx2 = this.tx();){
            GroupDao groupDao = tx2.groupDao();
            Assert.assertEquals((long)1L, (long)restGroup.getRoles().stream().filter(ref -> ref.getName().equals("extraRole")).count());
            Assert.assertEquals((long)2L, (long)groupDao.getRoles(this.group()).count());
        }
    }

    @Test
    public void testAddBogusRoleToGroup() throws Exception {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            Assert.assertEquals((long)1L, (long)groupDao.getRoles(this.group()).count());
        }
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), "bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testAddNoPermissionRoleToGroup() throws Exception {
        String roleUuid;
        HibRole extraRole;
        GroupDao groupDao;
        try (Tx tx = this.tx();){
            groupDao = tx.groupDao();
            RoleDao roleDao = tx.roleDao();
            extraRole = roleDao.create("extraRole", this.user());
            roleUuid = extraRole.getUuid();
            Assert.assertEquals((long)1L, (long)groupDao.getRoles(this.group()).count());
            tx.success();
        }
        this.expect(MeshEvent.GROUP_ROLE_ASSIGNED).none();
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{roleUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        this.awaitEvents();
        tx = this.tx();
        try {
            groupDao = tx.groupDao();
            Assert.assertEquals((long)1L, (long)groupDao.getRoles(this.group()).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.expect(MeshEvent.GROUP_ROLE_ASSIGNED).one();
        ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), roleUuid));
        this.awaitEvents();
        tx = this.tx();
        try {
            groupDao = tx.groupDao();
            Assert.assertEquals((long)2L, (long)groupDao.getRoles(this.group()).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveRoleFromGroup() throws Exception {
        String groupName = (String)this.tx(() -> this.group().getName());
        String groupUuid = this.groupUuid();
        String roleName = "extraRole";
        String roleUuid = (String)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            HibRole extraRole = roleDao.create(roleName, this.user());
            HibGroup group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            groupDao.addRole(group, extraRole);
            groupDao.mergeIntoPersisted((HibBaseElement)group);
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            Assert.assertEquals((long)2L, (long)groupDao.getRoles(this.group()).count());
            this.searchProvider().reset();
            return extraRole.getUuid();
        });
        this.expect(MeshEvent.GROUP_ROLE_UNASSIGNED).match(1, GroupRoleAssignModel.class, event -> {
            GroupReference group = event.getGroup();
            Assert.assertNotNull((Object)group);
            Assert.assertEquals((String)"The group name was not set.", (Object)groupName, (Object)group.getName());
            Assert.assertEquals((String)"The group uuid was not set.", (Object)groupUuid, (Object)group.getUuid());
            RoleReference role = event.getRole();
            Assert.assertNotNull((Object)role);
            Assert.assertEquals((String)"The role name was not set.", (Object)roleName, (Object)role.getName());
            Assert.assertEquals((String)"The role uuid was not set.", (Object)roleUuid, (Object)role.getUuid());
        }).total(1L);
        ClientHelper.call(() -> this.client().removeRoleFromGroup(this.groupUuid(), roleUuid));
        this.awaitEvents();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]));
        Assert.assertFalse((boolean)restGroup.getRoles().stream().map(AbstractNameUuidReference::getName).anyMatch("extraRole"::equals));
        try (Tx tx2 = this.tx();){
            GroupDao groupDao = tx2.groupDao();
            Assert.assertEquals((long)1L, (long)groupDao.getRoles(this.group()).count());
        }
        this.expect(MeshEvent.GROUP_ROLE_UNASSIGNED).none();
        ClientHelper.call(() -> this.client().removeRoleFromGroup(this.groupUuid(), roleUuid));
        this.awaitEvents();
    }

    @Test
    public void testAddRoleToGroupWithPerm() throws Exception {
        HibRole extraRole;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            extraRole = roleDao.create("extraRole", this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().addRoleToGroup(this.group().getUuid(), extraRole.getUuid()));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(this.group());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            HibGroup group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            Assert.assertTrue((String)"Role should be assigned to group.", (boolean)groupDao.hasRole(group, (HibRole)tx.roleDao().findByUuid(extraRole.getUuid())));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddRoleToGroupWithoutPermOnGroup() throws Exception {
        HibRole extraRole;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibGroup group = this.group();
            extraRole = roleDao.create("extraRole", this.user());
            roleDao.revokePermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().addRoleToGroup(this.groupUuid(), extraRole.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            Assert.assertFalse((String)"Role should not be assigned to group.", (boolean)groupDao.hasRole(this.group(), extraRole));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddRoleToGroupWithBogusRoleUUID() throws Exception {
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().addRoleToGroup(this.group().getUuid(), "bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
        }
    }

    @Test
    public void testRemoveRoleFromGroupWithPerm() throws Exception {
        GroupResponse restGroup;
        HibGroup group;
        GroupDao groupDao;
        HibRole extraRole;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao2 = ((CommonTx)tx.unwrap()).groupDao();
            HibGroup group2 = this.group();
            extraRole = roleDao.create("extraRole", this.user());
            groupDao2.addRole(group2, extraRole);
            groupDao2.mergeIntoPersisted((HibBaseElement)group2);
            Assert.assertNotNull((Object)group2.getUuid());
            Assert.assertNotNull((Object)extraRole.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraRole, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)group2, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            groupDao = tx.groupDao();
            group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            restGroup = (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(this.group());
            Assert.assertTrue((String)"Role should now be assigned to group.", (boolean)groupDao.hasRole(group, (HibRole)tx.roleDao().findByUuid(extraRole.getUuid())));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().removeRoleFromGroup(this.groupUuid(), extraRole.getUuid()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            groupDao = tx.groupDao();
            group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            restGroup = (GroupResponse)ClientHelper.call(() -> this.client().findGroupByUuid(this.groupUuid(), new ParameterProvider[0]));
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(this.group());
            Assert.assertFalse((String)"Role should now no longer be assigned to group.", (boolean)groupDao.hasRole(group, (HibRole)tx.roleDao().findByUuid(extraRole.getUuid())));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveRoleFromGroupWithoutPerm() throws Exception {
        String extraRoleUuid;
        HibRole extraRole;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            HibGroup group = this.group();
            extraRole = roleDao.create("extraRole", this.user());
            extraRoleUuid = extraRole.getUuid();
            groupDao.addRole(group, extraRole);
            roleDao.revokePermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().removeRoleFromGroup(this.groupUuid(), extraRoleUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            Assert.assertTrue((String)"Role should be stil assigned to group.", (boolean)groupDao.hasRole(this.group(), extraRole));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

