/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.group;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.group.GroupReference;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.MeshAssert;
import io.vertx.ext.web.RoutingContext;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class GroupTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            GroupReference reference = (GroupReference)this.group().transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)this.group().getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)this.group().getName(), (Object)reference.getName());
        }
    }

    @Test
    public void testUserGroup() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            GroupDao groupDao = tx.groupDao();
            HibGroup group = groupDao.create("test group", this.user());
            HibUser user = userDao.create("testuser", this.user());
            groupDao.addUser(group, user);
            groupDao.addUser(group, user);
            groupDao.addUser(group, user);
            Assert.assertEquals((String)"The group should contain one member.", (long)1L, (long)groupDao.getUsers(group).count());
            HibUser userOfGroup = (HibUser)groupDao.getUsers(group).iterator().next();
            Assert.assertEquals((String)"Username did not match the expected one.", (Object)user.getUsername(), (Object)userOfGroup.getUsername());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        int groupCount = this.groups().size();
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            Page page = groupDao.findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(19L)));
            Assert.assertEquals((long)groupCount, (long)page.getTotalElements());
            Assert.assertEquals((long)groupCount, (long)page.getSize());
            page = groupDao.findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(3L)));
            Assert.assertEquals((long)groupCount, (long)page.getTotalElements());
            Assert.assertEquals((String)"We expected one page per group.", (long)groupCount, (long)page.getSize());
        }
    }

    @Override
    @Test
    public void testFindAll() {
        try (Tx tx = this.tx();){
            long size = tx.groupDao().count();
            Assert.assertEquals((long)this.groups().size(), (long)size);
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            long nGroupsBefore = groupDao.count();
            Assert.assertNotNull((Object)groupDao.create("test group2", this.user()));
            long nGroupsAfter = groupDao.count();
            Assert.assertEquals((long)(nGroupsBefore + 1L), (long)nGroupsAfter);
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)tx.groupDao().findByName(this.group().getName()));
        }
    }

    @Override
    @Test
    public void testFindByUUID() {
        try (Tx tx = this.tx();){
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.group().getUuid());
            Assert.assertNotNull((Object)group);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            GroupDao groupDao = tx.groupDao();
            GroupResponse response = (GroupResponse)groupDao.transformToRestSync((Object)this.group(), (InternalActionContext)ac, 0, new String[0]);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)this.group().getUuid(), (Object)response.getUuid());
            Assert.assertEquals((Object)this.group().getName(), (Object)response.getName());
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            HibGroup group = groupDao.create("newGroup", this.user());
            Assert.assertNotNull((Object)group);
            String uuid = group.getUuid();
            groupDao.delete((HibBaseElement)group, this.createBulkContext());
            group = (HibGroup)groupDao.findByUuid(uuid);
            Assert.assertNull((Object)group);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            GroupDao groupDao = tx.groupDao();
            HibUser user = this.user();
            InternalActionContext ac = this.mockActionContext();
            HibGroup group = groupDao.create("newGroup", user);
            Assert.assertFalse((boolean)userDao.hasPermission(user, (HibBaseElement)group, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(user, tx.data().permissionRoots().group(), (HibBaseElement)group);
            ac.data().clear();
            Assert.assertTrue((boolean)userDao.hasPermission(user, (HibBaseElement)group, InternalPermission.CREATE_PERM));
        }
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            HibGroup group = this.group();
            Assert.assertEquals((Object)"joe1_group", (Object)group.getName());
            Assert.assertNotNull((Object)groupDao.getUsers(group));
            Assert.assertEquals((long)1L, (long)groupDao.getUsers(group).count());
            Assert.assertNotNull((Object)group.getUuid());
        }
    }

    @Override
    @Test
    public void testCreate() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            HibGroup group = groupDao.create("newGroup", this.user());
            Assert.assertNotNull((Object)group);
            Assert.assertEquals((Object)"newGroup", (Object)group.getName());
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            HibGroup group = groupDao.create("newGroup", this.user());
            Assert.assertNotNull((Object)group);
            Assert.assertEquals((Object)"newGroup", (Object)group.getName());
            String uuid = group.getUuid();
            String userUuid = this.user().getUuid();
            groupDao.addUser(this.group(), this.user());
            BulkActionContext bac = this.createBulkContext();
            groupDao.delete((HibBaseElement)group, bac);
            MeshAssert.assertElement((DaoGlobal)tx.groupDao(), (String)uuid, (boolean)false);
            MeshAssert.assertElement((DaoGlobal)tx.userDao(), (String)userUuid, (boolean)true);
            Assert.assertEquals((long)1L, (long)bac.batch().getEntries().size());
        }
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            this.group().setName("changed");
            Assert.assertEquals((Object)"changed", (Object)this.group().getName());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)this.group());
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)this.group());
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)this.group());
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)this.group());
        }
    }
}

