/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.group;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.PersistingGroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.event.group.GroupUserAssignModel;
import com.gentics.mesh.core.rest.group.GroupReference;
import com.gentics.mesh.core.rest.group.GroupResponse;
import com.gentics.mesh.core.rest.user.UserReference;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT, startServer=true)
public class GroupUserEndpointTest
extends AbstractMeshTest {
    @Test
    public void testGetUsersByGroup() throws Exception {
        String extraUserUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            UserDao userDao = tx.userDao();
            HibUser extraUser = userDao.create("extraUser", this.user());
            HibGroup group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            groupDao.addUser(group, extraUser);
            groupDao.mergeIntoPersisted((HibBaseElement)group);
            extraUserUuid = extraUser.getUuid();
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ListResponse userList = (ListResponse)ClientHelper.call(() -> this.client().findUsersOfGroup(this.groupUuid(), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(25L))}));
        Assert.assertEquals((long)2L, (long)userList.getMetainfo().getTotalCount());
        UserResponse expectedTestUser = new UserResponse();
        expectedTestUser.setUuid(this.userUuid());
        expectedTestUser.setUsername((String)this.tx(() -> this.user().getUsername()));
        UserResponse expectedExtraUser = new UserResponse();
        expectedExtraUser.setUuid(extraUserUuid);
        expectedExtraUser.setUsername("extraUser");
        ((AbstractListAssert)MeshAssertions.assertThat((List)userList.getData()).as("Users of group", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "username"})).containsOnly((Object[])new UserResponse[]{expectedTestUser, expectedExtraUser});
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser extraUser = (HibUser)userDao.findByUuid(extraUserUuid);
            roleDao.revokePermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        userList = (ListResponse)ClientHelper.call(() -> this.client().findUsersOfGroup(this.groupUuid(), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(25L))}));
        Assert.assertEquals((long)1L, (long)userList.getMetainfo().getTotalCount());
        ((AbstractListAssert)MeshAssertions.assertThat((List)userList.getData()).as("Users of group", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "username"})).containsOnly((Object[])new UserResponse[]{expectedTestUser});
    }

    @Test
    public void testAddUserToGroupWithBogusGroupId() throws Exception {
        String userUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser extraUser = userDao.create("extraUser", this.user());
            userUuid = extraUser.getUuid();
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().addUserToGroup("bogus", userUuid), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testAddUserToGroupWithPerm() throws Exception {
        String userFirstname = "Albert";
        String userLastname = "Einstein";
        String groupUuid = this.groupUuid();
        String groupName = (String)this.tx(() -> this.group().getName());
        HibUser extraUser = (HibUser)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            GroupDao groupDao = tx.groupDao();
            HibUser user = userDao.create("extraUser", this.user());
            user.setFirstname("Albert");
            user.setLastname("Einstein");
            roleDao.grantPermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            Assert.assertFalse((String)"User should not be member of the group.", (boolean)groupDao.hasUser(this.group(), user));
            return user;
        });
        String extraUserUuid = (String)this.tx(() -> extraUser.getUuid());
        this.expect(MeshEvent.GROUP_USER_ASSIGNED).match(1, GroupUserAssignModel.class, event -> {
            GroupReference groupRef = event.getGroup();
            Assert.assertNotNull((Object)groupRef);
            Assert.assertEquals((String)"The group name was not set.", (Object)groupName, (Object)groupRef.getName());
            Assert.assertEquals((String)"The group uuid was not set.", (Object)groupUuid, (Object)groupRef.getUuid());
            UserReference userRef = event.getUser();
            Assert.assertNotNull((Object)userRef);
            Assert.assertEquals((String)"The user uuid was not set.", (Object)extraUserUuid, (Object)userRef.getUuid());
            Assert.assertEquals((String)"The user firstname was not set.", (Object)"Albert", (Object)userRef.getFirstName());
            Assert.assertEquals((String)"The user lastname was not set.", (Object)"Einstein", (Object)userRef.getLastName());
        }).total(1L);
        GroupResponse restGroup = (GroupResponse)ClientHelper.call(() -> this.client().addUserToGroup(this.groupUuid(), extraUserUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            GroupDao groupDao = tx2.groupDao();
            MeshAssertions.assertThat((GroupResponse)restGroup).matches(this.group());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), extraUserUuid);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
            this.trackingSearchProvider().reset();
            Assert.assertTrue((String)"User should be member of the group.", (boolean)groupDao.hasUser(this.group(), extraUser));
        }
        this.expect(MeshEvent.GROUP_USER_ASSIGNED).none();
        ClientHelper.call(() -> this.client().addUserToGroup(this.groupUuid(), extraUserUuid));
        this.awaitEvents();
    }

    @Test
    public void testAddUserToGroupWithoutPermOnGroup() throws Exception {
        HibUser extraUser;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibGroup group = this.group();
            extraUser = userDao.create("extraUser", this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)group, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            ClientHelper.call(() -> this.client().addUserToGroup(this.groupUuid(), extraUser.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertFalse((String)"User should not be member of the group.", (boolean)groupDao.hasUser(this.group(), extraUser));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddUserToGroupWithoutPermOnUser() throws Exception {
        HibUser extraUser;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            extraUser = userDao.create("extraUser", this.user());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            ClientHelper.call(() -> this.client().addUserToGroup(this.group().getUuid(), extraUser.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{extraUser.getUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
            Assert.assertFalse((String)"User should not be member of the group.", (boolean)groupDao.hasUser(this.group(), extraUser));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveUserFromGroupWithoutPerm() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            GroupDao groupDao = tx.groupDao();
            Assert.assertTrue((String)"User should be a member of the group.", (boolean)groupDao.hasUser(this.group(), this.user()));
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().removeUserFromGroup(this.groupUuid(), this.userUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.groupUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            GroupDao groupDao = tx.groupDao();
            Assert.assertTrue((String)"User should still be a member of the group.", (boolean)groupDao.hasUser(this.group(), this.user()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveUserFromGroupWithPerm() throws Exception {
        String groupUuid = this.groupUuid();
        String groupName = (String)this.tx(() -> this.group().getName());
        String userFirstname = "Albert";
        String userLastname = "Einstein";
        HibUser extraUser = (HibUser)this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            HibUser user = userDao.create("extraUser", this.user());
            user.setFirstname("Albert");
            user.setLastname("Einstein");
            roleDao.grantPermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            HibGroup group = (HibGroup)groupDao.findByUuid(this.group().getUuid());
            groupDao.addUser(group, user);
            groupDao.mergeIntoPersisted((HibBaseElement)group);
            return user;
        });
        String extraUserUuid = (String)this.tx(() -> extraUser.getUuid());
        this.expect(MeshEvent.GROUP_USER_UNASSIGNED).match(1, GroupUserAssignModel.class, event -> {
            GroupReference groupRef = event.getGroup();
            Assert.assertNotNull((Object)groupRef);
            Assert.assertEquals((String)"The group name was not set.", (Object)groupName, (Object)groupRef.getName());
            Assert.assertEquals((String)"The group uuid was not set.", (Object)groupUuid, (Object)groupRef.getUuid());
            UserReference userRef = event.getUser();
            Assert.assertNotNull((Object)userRef);
            Assert.assertEquals((String)"The user uuid was not set.", (Object)extraUserUuid, (Object)userRef.getUuid());
            Assert.assertEquals((String)"The user firstname was not set.", (Object)"Albert", (Object)userRef.getFirstName());
            Assert.assertEquals((String)"The user lastname was not set.", (Object)"Einstein", (Object)userRef.getLastName());
        }).total(1L);
        ClientHelper.call(() -> this.client().removeUserFromGroup(groupUuid, extraUserUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            GroupDao groupDao = tx2.groupDao();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), extraUserUuid);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
            Assert.assertFalse((String)"User should not be member of the group.", (boolean)groupDao.hasUser(this.group(), extraUser));
        }
        this.expect(MeshEvent.GROUP_USER_UNASSIGNED).none();
        ClientHelper.call(() -> this.client().removeUserFromGroup(groupUuid, extraUserUuid));
        this.awaitEvents();
    }

    @Test
    @Ignore(value="Not yet implemented")
    public void testRemoveSameUserFromGroupWithPerm() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testRemoveUserFromLastGroupWithPerm() throws Exception {
        ClientHelper.call(() -> this.client().removeUserFromGroup(this.groupUuid(), this.userUuid()));
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            Assert.assertFalse((String)"User should no longer be member of the group.", (boolean)groupDao.hasUser(this.group(), this.user()));
        }
    }

    @Test
    public void testRemoveUserFromGroupWithBogusUserUuid() throws Exception {
        ClientHelper.call(() -> this.client().removeUserFromGroup(this.groupUuid(), "bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            Assert.assertTrue((String)"User should still be member of the group.", (boolean)groupDao.hasUser(this.group(), this.user()));
        }
    }
}

