/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.job;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.data.job.HibJob;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.job.JobType;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.JobParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class JobEndpointTest
extends AbstractMeshTest {
    @Test
    public void testListJobs() {
        ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        JobListResponse jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((List)jobList.getData()).isEmpty();
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getJson());
        String uuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        this.waitForJob(() -> {
            SchemaUpdateRequest schema = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
            schema.setName("folder2");
            ClientHelper.call(() -> this.client().updateSchema(uuid, schema, new ParameterProvider[0]));
        });
        jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        Optional<JobResponse> optionalSchemaMigrationJob = jobList.getData().stream().filter(job -> job.getType() == JobType.schema).findFirst();
        ((OptionalAssert)MeshAssertions.assertThat(optionalSchemaMigrationJob).as("Schema migration job", new Object[0])).isPresent();
        JobResponse job2 = optionalSchemaMigrationJob.get();
        MeshAssertions.assertThat((Map)job2.getProperties()).doesNotContainKey((Object)"microschemaUuid");
        MeshAssertions.assertThat((Map)job2.getProperties()).doesNotContainKey((Object)"microschemaName");
        MeshAssertions.assertThat((Map)job2.getProperties()).containsKey((Object)"schemaName");
        MeshAssertions.assertThat((Map)job2.getProperties()).containsKey((Object)"schemaUuid");
        MeshAssertions.assertThat((List)((JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]))).getData()).hasSize(1);
        this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch()));
        MeshAssertions.assertThat((List)((JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]))).getData()).hasSize(2);
    }

    @Test
    public void testListJobsFiltered() {
        JobListResponse jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((List)jobList.getData()).isEmpty();
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getJson());
        String uuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        this.waitForJob(() -> {
            SchemaUpdateRequest schema = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
            schema.setName("folder2");
            ClientHelper.call(() -> this.client().updateSchema(uuid, schema, new ParameterProvider[0]));
        });
        this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch()));
        String branchName = (String)this.tx(() -> this.initialBranch().getName());
        JobResponse branchMigrationJob = new JobResponse();
        branchMigrationJob.setType(JobType.branch);
        branchMigrationJob.setStatus(JobStatus.QUEUED);
        JobResponse schemaMigrationJob = new JobResponse();
        schemaMigrationJob.setType(JobType.schema);
        schemaMigrationJob.setStatus(JobStatus.COMPLETED);
        List<Pair> tests = Arrays.asList(Pair.of(p -> {}, Arrays.asList(branchMigrationJob, schemaMigrationJob)), Pair.of(p -> p.setStatus(new JobStatus[]{JobStatus.FAILED}), Collections.emptyList()), Pair.of(p -> p.setStatus(new JobStatus[]{JobStatus.COMPLETED}), Arrays.asList(schemaMigrationJob)), Pair.of(p -> p.setStatus(new JobStatus[]{JobStatus.QUEUED}), Arrays.asList(branchMigrationJob)), Pair.of(p -> p.setStatus(new JobStatus[]{JobStatus.COMPLETED, JobStatus.QUEUED}), Arrays.asList(schemaMigrationJob, branchMigrationJob)), Pair.of(p -> p.setType(new JobType[]{JobType.versionpurge}), Collections.emptyList()), Pair.of(p -> p.setType(new JobType[]{JobType.schema}), Arrays.asList(schemaMigrationJob)), Pair.of(p -> p.setType(new JobType[]{JobType.branch}), Arrays.asList(branchMigrationJob)), Pair.of(p -> p.setType(new JobType[]{JobType.branch, JobType.schema}), Arrays.asList(branchMigrationJob, schemaMigrationJob)), Pair.of(p -> p.setType(new JobType[]{JobType.branch}).setStatus(new JobStatus[]{JobStatus.COMPLETED}), Collections.emptyList()), Pair.of(p -> p.setType(new JobType[]{JobType.branch}).setStatus(new JobStatus[]{JobStatus.QUEUED}), Arrays.asList(branchMigrationJob)), Pair.of(p -> p.setBranchName(new String[]{"doesnotexist"}), Collections.emptyList()), Pair.of(p -> p.setBranchName(new String[]{branchName}), Arrays.asList(branchMigrationJob, schemaMigrationJob)), Pair.of(p -> p.setSchemaName(new String[]{"folder2"}), Arrays.asList(schemaMigrationJob)));
        for (Pair test : tests) {
            JobParametersImpl parameters = new JobParametersImpl();
            ((Consumer)test.getLeft()).accept(parameters);
            Object description = null;
            if (parameters.isEmpty()) {
                description = "Unfiltered job list";
            } else {
                description = "Job List filtered for";
                if (!parameters.getStatus().isEmpty()) {
                    description = (String)description + " status=" + parameters.getStatus();
                }
                if (!parameters.getType().isEmpty()) {
                    description = (String)description + " type=" + parameters.getType();
                }
                if (!parameters.getBranchName().isEmpty()) {
                    description = (String)description + " branchName=" + parameters.getBranchName();
                }
                if (!parameters.getBranchUuid().isEmpty()) {
                    description = (String)description + " branchUuid=" + parameters.getBranchUuid();
                }
                if (!parameters.getSchemaName().isEmpty()) {
                    description = (String)description + " schemaName=" + parameters.getSchemaName();
                }
                if (!parameters.getSchemaUuid().isEmpty()) {
                    description = (String)description + " schemaUuid=" + parameters.getSchemaUuid();
                }
                if (!parameters.getMicroschemaName().isEmpty()) {
                    description = (String)description + " microschemaName=" + parameters.getMicroschemaName();
                }
                if (!parameters.getMicroschemaUuid().isEmpty()) {
                    description = (String)description + " microschemaUuid=" + parameters.getMicroschemaUuid();
                }
                if (!parameters.getFromVersion().isEmpty()) {
                    description = (String)description + " fromVersion=" + parameters.getFromVersion();
                }
                if (!parameters.getToVersion().isEmpty()) {
                    description = (String)description + " toVersion=" + parameters.getToVersion();
                }
            }
            jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[]{parameters}));
            ((AbstractListAssert)MeshAssertions.assertThat((List)jobList.getData()).as((String)description, new Object[0]).usingElementComparatorOnFields(new String[]{"status", "type"})).containsOnlyElementsOf((Iterable)test.getRight());
        }
    }

    @Test
    public void testDeleteFailedJob() {
        String jobUuid = (String)this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch()).getUuid());
        ClientHelper.call(() -> this.client().deleteJob(jobUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        this.adminCall(() -> this.client().deleteJob(jobUuid), HttpResponseStatus.BAD_REQUEST, "job_error_invalid_state", jobUuid);
        this.triggerAndWaitForJob(jobUuid, JobStatus.FAILED);
        this.adminCall(() -> this.client().deleteJob(jobUuid));
        JobListResponse jobList = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        MeshAssertions.assertThat((List)jobList.getData()).isEmpty();
    }

    @Test
    public void testHandlingOfFailedJobs() {
        String jobUuid = (String)this.tx(tx -> {
            HibJob job = tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch());
            return job.getUuid();
        });
        this.waitForJob(() -> {
            GenericMessageResponse msg = (GenericMessageResponse)this.adminCall(() -> this.client().invokeJobProcessing());
            MeshAssertions.assertThat((GenericMessageResponse)msg).matches("job_processing_invoked", new String[0]);
        }, jobUuid, JobStatus.FAILED);
        this.adminCall(() -> this.client().invokeJobProcessing());
        TestUtils.sleep((long)5000L);
        JobListResponse status = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[0]));
        Assert.assertEquals((String)"No other migration should have been executed.", (long)1L, (long)status.getMetainfo().getTotalCount());
        Assert.assertEquals((Object)jobUuid, (Object)((JobResponse)status.getData().get(0)).getUuid());
    }

    @Test
    public void testLoadBogusJob() {
        this.grantAdmin();
        ClientHelper.call(() -> this.client().findJobByUuid("bogus"), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testManualInvoke() {
        String jobUuid = (String)this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch()).getUuid());
        ClientHelper.call(() -> this.client().invokeJobProcessing(), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        this.grantAdmin();
        JobResponse response = this.waitForJob(() -> {
            GenericMessageResponse message = (GenericMessageResponse)ClientHelper.call(() -> this.client().invokeJobProcessing());
            MeshAssertions.assertThat((GenericMessageResponse)message).matches("job_processing_invoked", new String[0]);
        }, jobUuid, JobStatus.FAILED);
        Assert.assertEquals((String)"The job uuid of the job should match up with the migration status info uuid.", (Object)jobUuid, (Object)response.getUuid());
    }

    @Test
    public void testReadJob() {
        String jobUuid = (String)this.tx(tx -> {
            HibJob job = tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch());
            return job.getUuid();
        });
        this.tx(tx -> {
            HibSchema schema = this.schemaContainer("content");
            HibJob job = tx.jobDao().enqueueSchemaMigration(this.user(), this.initialBranch(), (HibSchemaVersion)schema.getLatestVersion(), (HibSchemaVersion)schema.getLatestVersion());
            return job.getUuid();
        });
        String job3Uuid = (String)this.tx(tx -> {
            HibSchema schema = this.schemaContainer("folder");
            HibJob job = tx.jobDao().enqueueSchemaMigration(this.user(), this.initialBranch(), (HibSchemaVersion)schema.getLatestVersion(), (HibSchemaVersion)schema.getLatestVersion());
            return job.getUuid();
        });
        this.grantAdmin();
        JobResponse jobResponse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(job3Uuid));
        try (Tx tx2 = this.tx();){
            HibSchema schema = this.schemaContainer("folder");
            Assert.assertEquals((Object)this.initialBranchUuid(), jobResponse.getProperties().get("branchUuid"));
            Assert.assertEquals((Object)schema.getUuid(), jobResponse.getProperties().get("schemaUuid"));
            Assert.assertEquals((Object)((HibSchemaVersion)schema.getLatestVersion()).getVersion(), jobResponse.getProperties().get("fromVersion"));
            Assert.assertEquals((Object)((HibSchemaVersion)schema.getLatestVersion()).getVersion(), jobResponse.getProperties().get("toVersion"));
        }
        jobResponse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid));
        Assert.assertEquals((Object)this.initialBranchUuid(), jobResponse.getProperties().get("branchUuid"));
    }

    @Test
    public void testRetryJob() {
        String jobUuid = (String)this.tx(tx -> {
            HibJob job = tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch());
            return job.getUuid();
        });
        ClientHelper.call(() -> this.client().resetJob(jobUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        this.triggerAndWaitForJob(jobUuid, JobStatus.FAILED);
        this.grantAdmin();
        JobResponse jobResonse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid));
        Assert.assertNotNull((Object)jobResonse.getErrorMessage());
        ClientHelper.call(() -> this.client().resetJob(jobUuid));
        jobResonse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid));
        Assert.assertNull((Object)jobResonse.getErrorMessage());
        Assert.assertEquals((String)"After reset the job must be 'queued'", (Object)JobStatus.QUEUED, (Object)jobResonse.getStatus());
    }

    @Test
    public void testProcessJob() {
        HibJob job = (HibJob)this.tx(tx -> tx.jobDao().enqueueBranchMigration(this.user(), this.initialBranch()));
        String jobUuid = (String)this.tx(() -> job.getUuid());
        ClientHelper.call(() -> this.client().processJob(jobUuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_admin_permission_required", (String[])new String[0]);
        this.grantAdmin();
        this.triggerAndWaitForJob(jobUuid, JobStatus.FAILED);
        this.grantAdmin();
        JobResponse jobResonse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid));
        Assert.assertNotNull((Object)jobResonse.getErrorMessage());
        this.tx(tx -> {
            BranchDao branchDao = tx.branchDao();
            HibBranch branch = branchDao.create(this.project(), "testBranch", this.user(), null, true, this.initialBranch(), this.createBatch());
            HibJob toUpdate = (HibJob)tx.jobDao().findByUuid(job.getUuid());
            toUpdate.setBranch(branch);
            CommonTx.get().jobDao().mergeIntoPersisted((HibBaseElement)toUpdate);
        });
        this.waitForJob(() -> ClientHelper.call(() -> this.client().processJob(jobUuid)), jobUuid, JobStatus.COMPLETED);
        this.grantAdmin();
        jobResonse = (JobResponse)ClientHelper.call(() -> this.client().findJobByUuid(jobUuid));
        Assert.assertNull((Object)jobResonse.getErrorMessage());
        Assert.assertEquals((String)"After process the job must be 'completed'", (Object)JobStatus.COMPLETED, (Object)jobResonse.getStatus());
    }

    @Test
    public void testJobStatusWithNoMigrationRunning() {
        this.grantAdmin();
        JobListResponse status = (JobListResponse)ClientHelper.call(() -> this.client().findJobs(new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)status.getMetainfo().getTotalCount());
    }
}

