/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.job;

import com.gentics.mesh.core.data.dao.JobDao;
import com.gentics.mesh.core.data.job.HibJob;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.job.JobResponse;
import com.gentics.mesh.core.rest.job.JobType;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.reactivex.exceptions.CompositeException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class JobTest
extends AbstractMeshTest {
    @Test
    public void testJob() {
        JobDao root;
        try (Tx tx = this.tx();){
            root = tx.jobDao();
            HibJob job = root.enqueueBranchMigration(this.user(), this.initialBranch());
            Assert.assertNull((String)"The creator should not be set.", (Object)job.getCreator());
            Assert.assertNotNull((String)"The uuid of the job was not set.", (Object)job.getUuid());
            Assert.assertEquals((String)"The job branch information did not match.", (Object)this.initialBranchUuid(), (Object)job.getBranch().getUuid());
            Assert.assertEquals((String)"The job type did not match.", (Object)JobType.branch, (Object)job.getType());
            Assert.assertNull((String)"The job error detail should be null since it has not yet been marked as failed.", (Object)job.getErrorDetail());
            Assert.assertNull((String)"The job error message should be null since it has not yet been marked as failed.", (Object)job.getErrorMessage());
            job.markAsFailed(new Exception("some error"));
            Assert.assertEquals((String)"The job did not contain the correct error message", (Object)"some error", (Object)job.getErrorMessage());
            Assert.assertNotNull((String)"The job did not contain error detail information.", (Object)job.getErrorDetail());
            tx.success();
        }
        tx = this.tx();
        try {
            root = tx.jobDao();
            List list = TestUtils.toList((Iterable)root.findAll());
            Assertions.assertThat((List)list).hasSize(1);
            HibJob job = (HibJob)list.get(0);
            Assert.assertEquals((Object)"some error", (Object)job.getErrorMessage());
            JobResponse response = (JobResponse)root.transformToRestSync((Object)job, null, 0, new String[0]);
            Assert.assertEquals((Object)"some error", (Object)response.getErrorMessage());
            Assert.assertNotNull((Object)response.getErrorDetail());
            Assert.assertEquals((Object)job.getErrorDetail(), (Object)response.getErrorDetail());
            Assert.assertEquals((Object)job.getType(), (Object)response.getType());
            Assert.assertEquals((Object)job.getCreationDate(), (Object)response.getCreated());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private Exception buildExceptionStackTraceLongerThan(int size) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        do {
            exceptions.add(new Exception("Some Error"));
        } while (ExceptionUtils.getStackTrace((Throwable)new CompositeException(exceptions)).length() < size);
        return new CompositeException(exceptions);
    }

    @Test
    public void testJobErrorDetailTruncate() {
        JobDao root;
        try (Tx tx = this.tx();){
            root = tx.jobDao();
            HibJob job = root.enqueueBranchMigration(this.user(), this.initialBranch());
            Assert.assertNull((String)"The job error detail should be null since it has not yet been marked as failed.", (Object)job.getErrorDetail());
            Exception ex = this.buildExceptionStackTraceLongerThan(100000);
            Assertions.assertThat((int)ExceptionUtils.getStackTrace((Throwable)ex).length()).isGreaterThan(50000);
            job.markAsFailed(ex);
            Assert.assertNotNull((Object)job.getErrorDetail());
            Assertions.assertThat((int)job.getErrorDetail().length()).isLessThanOrEqualTo(50000);
            tx.success();
        }
        tx = this.tx();
        try {
            root = tx.jobDao();
            List list = TestUtils.toList((Iterable)root.findAll());
            Assertions.assertThat((List)list).hasSize(1);
            HibJob job = (HibJob)list.get(0);
            JobResponse response = (JobResponse)root.transformToRestSync((Object)job, null, 0, new String[0]);
            Assert.assertNotNull((Object)response.getErrorDetail());
            Assertions.assertThat((int)response.getErrorDetail().length()).isLessThanOrEqualTo(50000);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testJobRootTypeHandling() {
        try (Tx tx = this.tx();){
            JobDao dao = tx.jobDao();
            HibSchema schema = (HibSchema)((CommonTx)tx.unwrap()).schemaDao().createPersisted(null);
            HibMicroschema microschema = (HibMicroschema)((CommonTx)tx.unwrap()).microschemaDao().createPersisted(null);
            dao.enqueueSchemaMigration(this.user(), this.latestBranch(), this.createSchemaVersion(tx, schema, v -> {}), this.createSchemaVersion(tx, schema, v -> {}));
            dao.enqueueMicroschemaMigration(this.user(), this.latestBranch(), this.createMicroschemaVersion(tx, microschema, v -> {}), this.createMicroschemaVersion(tx, microschema, v -> {}));
            dao.enqueueBranchMigration(this.user(), this.latestBranch());
            List list = dao.findAll().stream().map(HibJob::getType).collect(Collectors.toList());
            Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new JobType[]{JobType.schema, JobType.microschema, JobType.branch});
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
    }
}

