/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.language;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibLanguage;
import com.gentics.mesh.core.data.dao.LanguageDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class LanguageTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Ignore(value="test test not apply")
    public void testTransformToReference() throws Exception {
    }

    public HibLanguage englishLang() {
        try (Tx tx = this.tx();){
            HibLanguage hibLanguage = tx.languageDao().findByLanguageTag("en");
            return hibLanguage;
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            LanguageDao languageDao = tx.languageDao();
            long nLanguagesBefore = languageDao.count();
            String languageName = "klingon";
            String languageTag = "tlh";
            Assert.assertNotNull((Object)languageDao.create("klingon", "tlh"));
            long nLanguagesAfter = languageDao.count();
            Assert.assertEquals((long)(nLanguagesBefore + 1L), (long)nLanguagesAfter);
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet implemented")
    public void testFindAllVisible() throws InvalidArgumentException {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            long size = Iterators.size((Iterator)tx.languageDao().findAll().iterator());
            Assert.assertEquals((long)11L, (long)size);
        }
    }

    @Test
    public void testFindByLanguageTag() {
        try (Tx tx = this.tx();){
            int nChecks = 50000;
            long start = System.currentTimeMillis();
            for (int i = 0; i < nChecks; ++i) {
                HibLanguage language = tx.languageDao().findByLanguageTag("de");
                Assert.assertNotNull((Object)language);
            }
            long duration = System.currentTimeMillis() - start;
            double perCheck = (double)duration / (double)nChecks;
            System.out.println("Duration per lookup: " + perCheck);
            System.out.println("Duration: " + duration);
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            HibLanguage language = (HibLanguage)tx.languageDao().findByName("German");
            Assert.assertNotNull((Object)language);
            Assert.assertEquals((Object)"German", (Object)language.getName());
            Assert.assertEquals((Object)"Deutsch", (Object)language.getNativeName());
            Assert.assertEquals((Object)"de", (Object)language.getLanguageTag());
            language = (HibLanguage)tx.languageDao().findByName("bogus");
            Assert.assertNull((Object)language);
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibLanguage language = (HibLanguage)tx.languageDao().findByName("German");
            HibLanguage foundLanguage = (HibLanguage)tx.languageDao().findByUuid(language.getUuid());
            Assert.assertNotNull((Object)foundLanguage);
            foundLanguage = (HibLanguage)tx.languageDao().findByUuid("bogus");
            Assert.assertNull((Object)foundLanguage);
        }
    }

    @Override
    @Test
    @Ignore(value="languages are currently not transformable")
    public void testTransformation() {
    }

    @Override
    @Test
    @Ignore(value="Languages can not be dynamically created")
    public void testCreateDelete() {
    }

    @Override
    @Test
    @Ignore(value="Languages can not be dynamically created")
    public void testCRUDPermissions() {
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            HibLanguage language = this.englishLang();
            Assert.assertNotNull((Object)language.getName());
            Assert.assertEquals((Object)"English", (Object)language.getName());
            Assert.assertNotNull((Object)language.getNativeName());
            Assert.assertEquals((Object)"English", (Object)language.getNativeName());
            Assert.assertNotNull((Object)language.getLanguageTag());
            Assert.assertEquals((Object)"en", (Object)language.getLanguageTag());
        }
    }

    @Override
    @Test
    public void testCreate() {
        try (Tx tx = this.tx();){
            LanguageDao languageDao = tx.languageDao();
            String languageTag = "tlh";
            String languageName = "klingon";
            HibLanguage lang = languageDao.create("klingon", "tlh");
            lang = (HibLanguage)languageDao.findByName("klingon");
            Assert.assertNotNull((Object)lang);
            Assert.assertEquals((Object)"klingon", (Object)lang.getName());
            Assert.assertNotNull((Object)languageDao.findByLanguageTag("tlh"));
        }
    }

    @Override
    @Test
    @Ignore(value="Languages can not be deleted")
    public void testDelete() {
    }

    @Override
    @Test
    @Ignore(value="Languages can not be updated")
    public void testUpdate() {
    }

    @Override
    @Test
    public void testReadPermission() {
        this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)this.englishLang());
    }

    @Override
    @Test
    public void testDeletePermission() {
        this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)this.englishLang());
    }

    @Override
    @Test
    public void testUpdatePermission() {
        this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)this.englishLang());
    }

    @Override
    @Test
    public void testCreatePermission() {
        this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)this.englishLang());
    }
}

