/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.monitoring;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.NodeParametersImpl;
import com.gentics.mesh.plugin.DummyPlugin;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.After;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true, elasticsearch=ElasticsearchTestMode.CONTAINER_ES6)
public class MetricsLabelTest
extends AbstractMeshTest {
    private final String esQuery = new JsonObject().put("query", (Object)new JsonObject().put("match_all", (Object)new JsonObject())).toString();

    @Test
    public void testGraphQL() {
        String query = "{ me { uuid } }";
        this.testMetric(this.pathLabel("graphql"), this.client().graphqlQuery("dummy", query, new ParameterProvider[0]));
    }

    @Test
    public void testWebroot() {
        this.testMetric(this.pathLabel("webroot"), this.client().webroot("dummy", "/", new ParameterProvider[0]));
    }

    @Test
    public void testWebrootField() throws IOException {
        NodeResponse binaryNode = (NodeResponse)this.createBinaryContent().blockingGet();
        binaryNode = this.uploadImage(binaryNode);
        binaryNode = (NodeResponse)this.client().findNodeByUuid("dummy", binaryNode.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}).blockingGet();
        this.testMetric(this.pathLabel("webrootfield"), this.client().webrootField("dummy", "binary", binaryNode.getPath(), new ParameterProvider[0]));
    }

    @Test
    public void testNodes() {
        this.testMetric(this.pathLabel("nodes"), this.client().findNodes("dummy", new ParameterProvider[0]));
    }

    @Test
    public void testSingleNode() {
        NodeResponse node = (NodeResponse)((NodeListResponse)this.client().findNodes("dummy", new ParameterProvider[0]).blockingGet()).getData().get(0);
        this.testMetric(this.pathLabel("nodes"), this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testBinaries() throws IOException {
        NodeResponse binaryNode = (NodeResponse)this.createBinaryContent().blockingGet();
        this.uploadImage(binaryNode);
        this.testMetric(this.pathLabel("binary"), this.client().downloadBinaryField("dummy", binaryNode.getUuid(), binaryNode.getLanguage(), "binary", new ParameterProvider[0]));
    }

    @Test
    public void testSearch() {
        this.testMetric(this.pathLabel("search"), this.client().searchNodes(this.esQuery, new ParameterProvider[0]));
    }

    @Test
    public void testSearchProject() {
        this.testMetric(this.pathLabel("search"), this.client().searchNodes("dummy", this.esQuery, new ParameterProvider[0]));
    }

    @Test
    public void testPlugin() {
        this.meshApi2().deployPlugin(DummyPlugin.class, "dummy").blockingAwait();
        this.waitForPluginRegistration();
        this.testMetric(this.pathLabel("plugin_dummy"), this.client().get("/plugins/dummy/hello"));
    }

    @Test
    public void testProjectPlugin() {
        this.meshApi2().deployPlugin(DummyPlugin.class, "dummy").blockingAwait();
        this.waitForPluginRegistration();
        this.testMetric(this.pathLabel("plugin_dummy"), this.client().get("/dummy/plugins/dummy/hello"));
    }

    @After
    public void tearDown() throws Exception {
        this.pluginManager().unloadPlugins();
    }

    private String pathLabel(String label) {
        return "path=\"" + label + "\"";
    }

    private void testMetric(String expected, MeshRequest<?> loader) {
        for (int i = 0; i < 10; ++i) {
            loader.blockingAwait();
        }
        String metrics = (String)ClientHelper.call(() -> this.monClient().metrics());
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)metrics).as("Metrics result", new Object[0])).isNotEmpty().contains(new CharSequence[]{expected});
    }
}

