/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.monitoring;

import com.gentics.mesh.Mesh;
import com.gentics.mesh.MeshStatus;
import com.gentics.mesh.core.rest.MeshServerInfoModel;
import com.gentics.mesh.core.rest.admin.localconfig.LocalConfigModel;
import com.gentics.mesh.core.rest.admin.status.MeshStatusResponse;
import com.gentics.mesh.metric.SimpleMetric;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.plugin.FailingInitializePlugin;
import com.gentics.mesh.plugin.manager.MeshPluginManager;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.impl.launcher.commands.VersionCommand;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class MonitoringServerEndpointTest
extends AbstractMeshTest {
    @Before
    @After
    public void setup() {
        this.meshApi().setStatus(MeshStatus.READY);
    }

    @Test
    public void testMetrics() {
        for (int i = 0; i < 10; ++i) {
            ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        }
        String metrics = (String)ClientHelper.call(() -> this.monClient().metrics());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)metrics).as("Metrics result", new Object[0])).isNotEmpty().contains(new CharSequence[]{SimpleMetric.TX.key()});
    }

    @Test
    public void testStatus() {
        this.meshApi().setStatus(MeshStatus.WAITING_FOR_CLUSTER);
        MeshStatusResponse status = (MeshStatusResponse)ClientHelper.call(() -> this.monClient().status());
        Assert.assertEquals((Object)MeshStatus.WAITING_FOR_CLUSTER, (Object)status.getStatus());
    }

    @Test
    public void testReadinessFailingPlugin() {
        MeshPluginManager manager = this.pluginManager();
        manager.deploy(FailingInitializePlugin.class, "failing").blockingAwait();
        try {
            ClientHelper.call(() -> this.monClient().ready());
            Assert.fail((String)"The ready probe should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.undeploy("failing").blockingAwait(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        ClientHelper.call(() -> this.monClient().ready());
    }

    @Test
    public void testLivenessFailingPlugin() {
        MeshPluginManager manager = this.pluginManager();
        manager.deploy(FailingInitializePlugin.class, "failing").blockingAwait();
        try {
            ClientHelper.call(() -> this.monClient().live());
            Assert.fail((String)"The liveness probe should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.undeploy("failing").blockingAwait(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        ClientHelper.call(() -> this.monClient().live());
    }

    @Test
    public void testClusterStatus() {
        ClientHelper.call(() -> this.monClient().clusterStatus(), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_cluster_status_only_available_in_cluster_mode", (String[])new String[0]);
    }

    @Test
    public void testReadinessProbe() {
        ClientHelper.call(() -> this.monClient().ready());
        this.meshApi().setStatus(MeshStatus.SHUTTING_DOWN);
        ClientHelper.call(() -> this.monClient().ready(), (HttpResponseStatus)HttpResponseStatus.SERVICE_UNAVAILABLE, (String)"error_internal", (String[])new String[0]);
    }

    @Test
    public void testLivenessProbe() {
        ClientHelper.call(() -> this.monClient().live());
    }

    @Test
    public void testAPIInfo() {
        MeshServerInfoModel info = (MeshServerInfoModel)ClientHelper.call(() -> this.monClient().versions());
        Assert.assertEquals((Object)Mesh.getPlainVersion(), (Object)info.getMeshVersion());
        Assert.assertEquals((Object)this.db().getVendorName(), (Object)info.getDatabaseVendor());
        Assert.assertEquals((Object)"dev-null", (Object)info.getSearchVendor());
        Assert.assertEquals((Object)VersionCommand.getVersion(), (Object)info.getVertxVersion());
        Assert.assertEquals((Object)this.options().getNodeName(), (Object)info.getMeshNodeName());
        Assert.assertEquals((Object)"1.0", (Object)info.getSearchVersion());
        Assert.assertEquals((Object)this.db().getDatabaseRevision(), (Object)info.getDatabaseRevision());
    }

    @Test
    public void testWritableReturns200() {
        ClientHelper.call(() -> this.monClient().writable());
    }

    @Test
    public void testWritableReturns503WhenReadOnlyMode() {
        ClientHelper.call(() -> this.client().updateLocalConfig(this.buildLocalConfigModel(true)));
        ClientHelper.call(() -> this.monClient().writable(), (HttpResponseStatus)HttpResponseStatus.SERVICE_UNAVAILABLE, (String)"error_internal", (String[])new String[0]);
    }

    private LocalConfigModel buildLocalConfigModel(boolean readOnly) {
        LocalConfigModel localConfigModel = new LocalConfigModel();
        localConfigModel.setReadOnly(Boolean.valueOf(readOnly));
        return localConfigModel;
    }
}

