/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractMassiveNodeLoadTest
extends AbstractMeshTest {
    protected final long numOfNodesPerLevel;
    protected String parentFolderUuid = null;

    public AbstractMassiveNodeLoadTest() {
        this(5000L);
    }

    public AbstractMassiveNodeLoadTest(long numOfNodesPerLevel) {
        this.numOfNodesPerLevel = numOfNodesPerLevel;
    }

    @Before
    public void makeEmAll() {
        this.makeEmAll(this.numOfNodesPerLevel, (String)this.tx(() -> this.project().getBaseNode().getUuid()));
    }

    @After
    public void nukeEmAll() {
        if (this.parentFolderUuid != null) {
            ClientHelper.call(() -> this.client().deleteNode("dummy", this.parentFolderUuid, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        }
    }

    protected void makeEmAll(long howMany, String parentNodeUuid) {
        try (Tx tx = this.tx();){
            if (this.parentFolderUuid == null) {
                SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
                schemaReference.setName("folder");
                NodeCreateRequest create2 = new NodeCreateRequest();
                FieldMapImpl fields = new FieldMapImpl();
                fields.put("name", (Field)FieldUtil.createStringField((String)"MassiveParentFolder"));
                fields.put("slug", (Field)FieldUtil.createStringField((String)"massiveparentfolder"));
                create2.setFields((FieldMap)fields);
                create2.setSchema((SchemaReference)schemaReference);
                create2.setLanguage("en");
                create2.setParentNodeUuid(parentNodeUuid);
                this.parentFolderUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]))).getUuid();
            }
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", this.parentFolderUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((long)0L, (long)nodeList.getData().size());
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("folder");
            int i = 0;
            while ((long)i < howMany) {
                NodeCreateRequest create2 = new NodeCreateRequest();
                FieldMapImpl fields = new FieldMapImpl();
                fields.put("name", (Field)FieldUtil.createStringField((String)("Folder " + i)));
                fields.put("slug", (Field)FieldUtil.createStringField((String)("folder" + i)));
                create2.setFields((FieldMap)fields);
                create2.setSchema((SchemaReference)schemaReference);
                create2.setLanguage("en");
                create2.setParentNodeUuid(this.parentFolderUuid);
                ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]));
                ++i;
            }
        }
    }
}

