/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeChildrenInfo;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeChildrenEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadChildrenOfBaseNode() {
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().findNodeChildren("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[0]));
        }
    }

    @Test
    public void testNodeHierarchy() {
        try (Tx tx = this.tx();){
            HibNode baseNode = this.project().getBaseNode();
            String parentNodeUuid = baseNode.getUuid();
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", parentNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((long)3L, (long)nodeList.getData().size());
            NodeCreateRequest create1 = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("folder");
            create1.setSchema((SchemaReference)schemaReference);
            create1.setLanguage("en");
            create1.setParentNodeUuid(parentNodeUuid);
            NodeResponse createdNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create1, new ParameterProvider[0]));
            String uuid = createdNode.getUuid();
            nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((long)0L, (long)nodeList.getData().size());
            NodeCreateRequest create2 = new NodeCreateRequest();
            create2.setSchema((SchemaReference)schemaReference);
            create2.setLanguage("en");
            create2.setParentNodeUuid(uuid);
            createdNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]));
            nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((String)"The subnode did not contain the created node", (long)1L, (long)nodeList.getData().size());
            nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", parentNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((String)"The basenode should still contain four nodes.", (long)4L, (long)nodeList.getData().size());
        }
    }

    @Test
    public void testReadNodeByUUIDAndCheckChildren() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((HibNode)node).matches(restNode);
            Assert.assertTrue((boolean)restNode.getContainer());
            long subFolderCount = ((NodeChildrenInfo)restNode.getChildrenInfo().get("folder")).getCount();
            Assert.assertEquals((String)("The node should have more than {" + subFolderCount + "} children. But it got {" + subFolderCount + "}"), (long)2L, (long)subFolderCount);
            long subContentCount = ((NodeChildrenInfo)restNode.getChildrenInfo().get("content")).getCount();
            Assert.assertEquals((String)("The node should have more than {" + subContentCount + "} children. But it got {" + subContentCount + "}"), (long)1L, (long)subContentCount);
        }
    }

    @Test
    public void testReadNodeByUUIDAndCheckChildrenPermissions() throws Exception {
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((HibNode)node).matches(restNode);
            Assert.assertTrue((boolean)restNode.getContainer());
            long subFolderCount = ((NodeChildrenInfo)restNode.getChildrenInfo().get("folder")).getCount();
            Assert.assertEquals((String)("The node should have more than {" + subFolderCount + "} children. But it got {" + subFolderCount + "}"), (long)1L, (long)subFolderCount);
            long subContentCount = ((NodeChildrenInfo)restNode.getChildrenInfo().get("content")).getCount();
            Assert.assertEquals((String)("The node should have more than {" + subContentCount + "} children. But it got {" + subContentCount + "}"), (long)1L, (long)subContentCount);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadNodeByUUIDAndCheckChildren2() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.content("concorde");
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((HibNode)node).matches(restNode);
            Assert.assertFalse((String)"The node should not be a container", (boolean)restNode.getContainer());
            Assert.assertNull(restNode.getChildrenInfo().get("folder"));
        }
    }

    @Test
    public void testReadNodeChildren() throws Exception {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            HibNode node = this.folder("news");
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            long size = TestUtils.size((Iterable)nodeDao.getChildren(node));
            long expectedItemsInPage = size > 25L ? 25L : size;
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl(), new VersioningParametersImpl().draft()}));
            Assert.assertEquals((long)TestUtils.size((Iterable)nodeDao.getChildren(node)), (long)nodeList.getMetainfo().getTotalCount());
            Assert.assertEquals((long)expectedItemsInPage, (long)nodeList.getData().size());
        }
    }

    @Test
    public void testReadNodeChildrenWithoutChildPermission() throws Exception {
        HibNode node = this.folder("news");
        HibNode nodeWithNoPerm = this.folder("2015");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)nodeWithNoPerm, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            NodeDao nodeDao = tx.nodeDao();
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(20000L)), new VersioningParametersImpl().draft()}));
            Assert.assertEquals((long)0L, (long)nodeList.getData().stream().filter(p -> nodeWithNoPerm.getUuid().equals(p.getUuid())).count());
            Assert.assertEquals((long)2L, (long)nodeList.getData().size());
            Assert.assertEquals((long)(TestUtils.size((Iterable)nodeDao.getChildren(node)) - 1L), (long)nodeList.getMetainfo().getTotalCount());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadNodeChildrenWithNoPermission() throws Exception {
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl(), new NodeParametersImpl()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{node.getUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadBranchChildren() {
        NodeCreateRequest create;
        HibBranch newBranch;
        long expectedItemsInPage;
        long childrenSize;
        HibNode firstFolder;
        NodeDao nodeDao;
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            nodeDao = tx.nodeDao();
            firstFolder = nodeDao.getChildren(node).stream().filter(child -> child.getSchemaContainer().getName().equals("folder")).findAny().get();
            childrenSize = TestUtils.size((Iterable)nodeDao.getChildren(node));
            expectedItemsInPage = childrenSize > 25L ? 25L : childrenSize;
            newBranch = this.createBranch("newbranch");
            tx.success();
        }
        tx = this.tx();
        try {
            nodeDao = tx.nodeDao();
            create = new NodeCreateRequest();
            create.setLanguage("en");
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)"News"));
            create.setParentNodeUuid(nodeDao.getParentNode(node, this.initialBranch().getUuid()).getUuid());
            ClientHelper.call(() -> this.client().createNode(node.getUuid(), "dummy", create, new ParameterProvider[0]));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl(), new VersioningParametersImpl().setBranch(this.initialBranch().getName()).draft()}));
            Assert.assertEquals((String)"Total children in initial branch", (long)childrenSize, (long)nodeList.getMetainfo().getTotalCount());
            Assert.assertEquals((String)"Returned children in initial branch", (long)expectedItemsInPage, (long)nodeList.getData().size());
            nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl(), new VersioningParametersImpl().setBranch(newBranch.getName()).draft()}));
            Assert.assertEquals((String)"Total children in new branch", (long)0L, (long)nodeList.getMetainfo().getTotalCount());
            Assert.assertEquals((String)"Returned children in new branch", (long)0L, (long)nodeList.getData().size());
            create = new NodeCreateRequest();
            create.setLanguage("en");
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)"new"));
            create.setParentNodeUuid(node.getUuid());
            ClientHelper.call(() -> this.client().createNode(firstFolder.getUuid(), "dummy", create, new ParameterProvider[0]));
            nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", node.getUuid(), new ParameterProvider[]{new PagingParametersImpl(), new VersioningParametersImpl().setBranch(newBranch.getName()).draft()}));
            Assert.assertEquals((String)"Total children in new branch", (long)1L, (long)nodeList.getMetainfo().getTotalCount());
            Assert.assertEquals((String)"Returned children in new branch", (long)1L, (long)nodeList.getData().size());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testFilterByLanguage() {
        String uuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("de");
        nodeCreateRequest.setParentNode(new NodeReference().setUuid(uuid));
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        nodeCreateRequest.getFields().put("teaser", (Field)new StringFieldImpl().setString("Only German Teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)new StringFieldImpl().setString("Only German Slug"));
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        NodeListResponse listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        List langList = listResponse.getData().stream().map(node -> node.getLanguage()).collect(Collectors.toList());
        MeshAssertions.assertThat(langList).doesNotContain((Object[])new String[]{null, "de"});
    }

    @Test
    public void testReadPublishedChildren() {
    }

    @Test
    public void testReadBranchPublishedChildren() {
    }
}

