/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.i18n.I18NUtil;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibStringFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.Tuple;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeConflictEndpointTest
extends AbstractMeshTest {
    private HibNode getTestNode() {
        return this.content("concorde");
    }

    private NodeUpdateRequest prepareNameFieldUpdateRequest(String nameFieldValue, String baseVersion) {
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("en");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)nameFieldValue));
        request.setVersion(baseVersion);
        return request;
    }

    @Test
    public void testNoConflictUpdate() {
        try (Tx trx = this.tx();){
            HibNode node = this.getTestNode();
            NodeUpdateRequest request = this.prepareNameFieldUpdateRequest("1234", "1.0");
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.1");
            restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.1");
            request.getFields().put("content", (Field)FieldUtil.createHtmlField((String)"someValue"));
            restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.2");
        }
    }

    @Test
    public void testConflictDetection() {
        try (Tx trx = this.tx();){
            HibNode node = this.getTestNode();
            NodeUpdateRequest request1 = this.prepareNameFieldUpdateRequest("1234", "1.0");
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request1, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.1");
            NodeUpdateRequest request2 = this.prepareNameFieldUpdateRequest("1234", "1.1");
            request2.getFields().put("title", (Field)FieldUtil.createStringField((String)"updatedTitle"));
            restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request2, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.2");
            NodeUpdateRequest request3 = this.prepareNameFieldUpdateRequest("1234", "1.0");
            request3.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"updatedField"));
            Throwable error = null;
            try {
                this.client().updateNode("dummy", node.getUuid(), request3, new ParameterProvider[]{parameters}).blockingGet();
                Assert.fail((String)"The node update should fail with a conflict error");
            }
            catch (RuntimeException e) {
                error = e.getCause();
            }
            ((AbstractThrowableAssert)MeshAssertions.assertThat((Throwable)error).isNotNull()).isInstanceOf(MeshRestClientMessageException.class);
            MeshRestClientMessageException conflictException = (MeshRestClientMessageException)error;
            MeshAssertions.assertThat((List)((List)conflictException.getResponseMessage().getProperty("conflicts"))).hasSize(1).containsExactly(new Object[]{"teaser"});
            MeshAssertions.assertThat((int)conflictException.getStatusCode()).isEqualTo(HttpResponseStatus.CONFLICT.code());
            MeshAssertions.assertThat((String)conflictException.getMessage()).isEqualTo((Object)("Error:409 in POST /api/v2/dummy/nodes/" + node.getUuid() + "?lang=en,de : Conflict Info: " + I18NUtil.get((Locale)Locale.ENGLISH, (String)"node_error_conflict_detected")));
            MeshAssertions.assertThat((Object)conflictException.getResponseMessage().getProperty("oldVersion")).isEqualTo((Object)"1.0");
            MeshAssertions.assertThat((Object)conflictException.getResponseMessage().getProperty("newVersion")).isEqualTo((Object)"1.2");
        }
    }

    @Test
    public void testDeduplicationDuringUpdate() {
        this.disableAutoPurge();
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            this.updateSchema();
            HibNodeFieldContainer origContainer = contentDao.getLatestDraftFieldContainer(this.getTestNode(), this.english());
            Assert.assertEquals((Object)"Concorde_english_name", (Object)origContainer.getString("teaser").getString());
            Assert.assertEquals((Object)"Concorde english title", (Object)origContainer.getString("title").getString());
            tx.success();
        }
        this.initialRequest();
        NodeUpdateRequest request = this.modifingRequest();
        this.repeatRequest(request);
        this.deletingRequest();
    }

    private void initialRequest() {
        HibNode node = this.getTestNode();
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        HibNodeFieldContainer oldContainer = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().findVersion(node, "en", this.project().getLatestBranch().getUuid(), "1.0"));
        NodeUpdateRequest request = this.prepareNameFieldUpdateRequest("1234", "1.0");
        request.getFields().put("stringList", (Field)FieldUtil.createStringListField((String[])new String[]{"a", "b", "c"}));
        request.getFields().put("micronode", (Field)FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test-firstname")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test-lastname"))}));
        NodeParametersImpl parameters = new NodeParametersImpl();
        parameters.setLanguages(new String[]{"en", "de"});
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, request, new ParameterProvider[]{parameters}));
        MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.1");
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            Assert.assertNotNull((String)"The old version should have a new version 1.1", contentDao.getNextVersions(oldContainer).iterator().next());
            HibNodeFieldContainer newContainer = contentDao.findVersion(node, "en", this.project().getLatestBranch().getUuid(), "1.1");
            Assert.assertEquals((String)"The name field value of the old container version should not have been changed.", (Object)"Concorde_english_name", (Object)oldContainer.getString("teaser").getString());
            Assert.assertEquals((String)"The name field value of the new container version should contain the expected value.", (Object)"1234", (Object)newContainer.getString("teaser").getString());
            Assert.assertNotNull((String)"The new container should also contain the title since basic field types are not deduplicated", (Object)newContainer.getString("title"));
            Assert.assertNotNull((String)"The container for version 0.1 should contain the title value.", (Object)oldContainer.getString("title"));
        }
    }

    private NodeUpdateRequest modifingRequest() {
        try (Tx trx = this.tx();){
            HibNode node = this.getTestNode();
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            NodeUpdateRequest request = this.prepareNameFieldUpdateRequest("1234", "1.1");
            request.getFields().put("stringList", (Field)FieldUtil.createStringListField((String[])new String[]{"b", "c", "d"}));
            request.getFields().put("micronode", (Field)FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test-updated-firstname")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test-updated-lastname"))}));
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.2");
            HibNodeFieldContainer createdVersion = trx.contentDao().findVersion(node, Arrays.asList("en"), this.project().getLatestBranch().getUuid(), "1.2");
            Assert.assertNotNull((String)"The graph field container for version 1.2 could not be found.", (Object)createdVersion);
            NodeUpdateRequest nodeUpdateRequest = request;
            return nodeUpdateRequest;
        }
    }

    private void repeatRequest(NodeUpdateRequest request) {
        HibNode node;
        try (Tx trx = this.tx();){
            node = this.getTestNode();
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            request.getFields().put("content", (Field)FieldUtil.createHtmlField((String)"changed"));
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.3");
        }
        trx = this.tx();
        try {
            node = this.getTestNode();
            HibNodeFieldContainer createdVersion = trx.contentDao().findVersion(node, Arrays.asList("en"), this.project().getLatestBranch().getUuid(), "1.3");
            Assert.assertNotNull((String)"The graph field container for version 1.3 could not be found.", (Object)createdVersion);
            HibNodeFieldContainer previousVersion = createdVersion.getPreviousVersion();
            Assert.assertNotNull((String)"The graph field container for version 1.2 could not be found.", (Object)previousVersion);
            Assert.assertEquals((String)"The previous version of 1.3 should be 1.2", (Object)"1.2", (Object)previousVersion.getVersion().toString());
            HibMicronodeField previousMicronode = previousVersion.getMicronode("micronode");
            HibMicronodeField nextMicronode = createdVersion.getMicronode("micronode");
            Assert.assertNotNull((String)"Could not find the field within the previous version.", (Object)previousMicronode);
            Assert.assertNotNull((String)"Could not find the expected field in the created version.", (Object)nextMicronode);
            Assert.assertEquals((String)"Both fields should have the same uuid since both are referenced by the both versions.", (Object)nextMicronode.getMicronode().getUuid(), (Object)previousMicronode.getMicronode().getUuid());
            HibStringFieldList previousStringList = previousVersion.getStringList("stringList");
            HibStringFieldList nextStringList = createdVersion.getStringList("stringList");
            Assert.assertNotNull((String)"Could not find the field within the previous version.", (Object)previousStringList);
            Assert.assertNotNull((String)"Could not find the expected field in the created version.", (Object)nextStringList);
        }
        finally {
            if (trx != null) {
                trx.close();
            }
        }
    }

    private void deletingRequest() {
        HibNode node;
        try (Tx trx = this.tx();){
            node = this.getTestNode();
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            NodeUpdateRequest request4 = this.prepareNameFieldUpdateRequest("1234", "1.2");
            request4.getFields().put("micronode", null);
            request4.getFields().put("stringList", null);
            NodeResponse restNode4 = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request4, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode4).hasVersion("1.4");
        }
        trx = this.tx();
        try {
            node = this.getTestNode();
            HibNodeFieldContainer createdVersion = trx.contentDao().findVersion(node, "en", this.project().getLatestBranch().getUuid(), "1.4");
            Assert.assertNotNull((String)"The graph field container for version 0.5 could not be found.", (Object)createdVersion);
            Assert.assertNull((String)"The micronode should not exist in this version since we explicitly removed it.", (Object)createdVersion.getMicronode("micronode"));
            Assert.assertNull((String)"The string list should not exist in this version since we explicitly removed it via a null update request.", (Object)createdVersion.getStringList("stringList"));
        }
        finally {
            if (trx != null) {
                trx.close();
            }
        }
    }

    private void updateSchema() {
        HibNode node = this.getTestNode();
        ListFieldSchemaImpl stringListFieldSchema = new ListFieldSchemaImpl();
        stringListFieldSchema.setName("stringList");
        stringListFieldSchema.setListType("string");
        MicronodeFieldSchemaImpl micronodeFieldSchema = new MicronodeFieldSchemaImpl();
        micronodeFieldSchema.setName("micronode");
        micronodeFieldSchema.setAllowedMicroSchemas(new String[]{"vcard"});
        SchemaVersionModel schema = ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema();
        schema.addField((FieldSchema)stringListFieldSchema);
        schema.addField((FieldSchema)micronodeFieldSchema);
        ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).setSchema(schema);
        this.mesh().serverSchemaStorage().addSchema(schema);
        this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()));
    }

    @Test
    public void testConflictInMicronode() {
        NodeUpdateRequest request;
        NodeParametersImpl parameters;
        this.disableAutoPurge();
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            this.updateSchema();
            HibNodeFieldContainer origContainer = contentDao.getLatestDraftFieldContainer(this.getTestNode(), this.english());
            Assert.assertEquals((Object)"Concorde_english_name", (Object)origContainer.getString("teaser").getString());
            Assert.assertEquals((Object)"Concorde english title", (Object)origContainer.getString("title").getString());
            tx.success();
        }
        this.initialRequest();
        HibNode node = this.getTestNode();
        try (Tx tx = this.tx();){
            parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            request = this.prepareNameFieldUpdateRequest("1234", "1.1");
            request.getFields().put("stringList", (Field)FieldUtil.createStringListField((String[])new String[]{"b", "c", "d"}));
            request.getFields().put("micronode", (Field)FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test-updated-firstname")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test-updated-lastname"))}));
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}));
            MeshAssertions.assertThat((NodeResponse)restNode).hasVersion("1.2");
            HibNodeFieldContainer createdVersion = tx.contentDao().findVersion(node, Arrays.asList("en"), this.project().getLatestBranch().getUuid(), "1.2");
            Assert.assertNotNull((String)"The graph field container for version 0.3 could not be found.", (Object)createdVersion);
        }
        tx = this.tx();
        try {
            parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            request = this.prepareNameFieldUpdateRequest("1234", "1.1");
            request.getFields().put("stringList", (Field)FieldUtil.createStringListField((String[])new String[]{"b", "c", "d"}));
            request.getFields().put("micronode", (Field)FieldUtil.createMicronodeField((String)"vcard", (Tuple[])new Tuple[]{Tuple.tuple((Object)"firstName", (Object)FieldUtil.createStringField((String)"test-updated-firstname")), Tuple.tuple((Object)"lastName", (Object)FieldUtil.createStringField((String)"test-updated-lastname-also-modified"))}));
            Throwable error = null;
            try {
                this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}).blockingGet();
                Assert.fail((String)"The node update should fail with a conflict error");
            }
            catch (RuntimeException e) {
                error = e.getCause();
            }
            ((AbstractThrowableAssert)MeshAssertions.assertThat((Throwable)error).isNotNull()).isInstanceOf(MeshRestClientMessageException.class);
            MeshRestClientMessageException conflictException = (MeshRestClientMessageException)error;
            MeshAssertions.assertThat((List)((List)conflictException.getResponseMessage().getProperty("conflicts"))).hasSize(2).containsExactly(new Object[]{"micronode.firstName", "micronode.lastName"});
            MeshAssertions.assertThat((int)conflictException.getStatusCode()).isEqualTo(HttpResponseStatus.CONFLICT.code());
            MeshAssertions.assertThat((String)conflictException.getMessage()).isEqualTo((Object)("Error:409 in POST /api/v2/dummy/nodes/" + node.getUuid() + "?lang=en,de : Conflict Info: " + I18NUtil.get((Locale)Locale.ENGLISH, (String)"node_error_conflict_detected")));
            MeshAssertions.assertThat((Object)conflictException.getResponseMessage().getProperty("oldVersion")).isEqualTo((Object)"1.1");
            MeshAssertions.assertThat((Object)conflictException.getResponseMessage().getProperty("newVersion")).isEqualTo((Object)"1.2");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testBogusVersionNumber() {
        try (Tx trx = this.tx();){
            HibNode node = this.getTestNode();
            NodeUpdateRequest request = this.prepareNameFieldUpdateRequest("1234", "42.1");
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[]{parameters}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_draft_not_found", (String[])new String[]{"42.1", "en"});
        }
    }
}

