/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeDeleteBranchEndpointTest
extends AbstractMeshTest {
    private final String newBranch = "newBranch";

    @Test
    public void deleteNodeInBranch() {
        this.grantAdmin();
        NodeResponse parent = this.createNode();
        NodeResponse otherParent = this.createNode();
        this.publishNode(parent);
        this.publishNode(otherParent);
        this.waitForJob(() -> this.createBranchRest("newBranch"));
        NodeResponse child = this.createNode(parent);
        this.publishNode(child);
        NodeListResponse children = (NodeListResponse)this.client().findNodeChildren("dummy", parent.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}).blockingGet();
        MeshAssertions.assertThat((List)children.getData()).isEmpty();
        this.createContentInBranchWithOtherParent(child, otherParent, this.initialBranchUuid());
        this.client().deleteNode("dummy", otherParent.getUuid(), new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}).blockingAwait();
    }

    private void createContentInBranchWithOtherParent(NodeResponse node, NodeResponse parent, String branch) {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNodeUuid(parent.getUuid());
        request.getFields().put("slug", (Field)new StringFieldImpl().setString(RandomStringUtils.randomAlphabetic((int)5)));
        this.client().createNode(node.getUuid(), "dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch)}).blockingAwait();
        this.publishNodeInBranch(node, branch);
    }
}

