/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BranchMigrationContext;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.impl.BranchMigrationContextImpl;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RootDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.VersioningParameters;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.MeshAssert;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeDeleteEndpointTest
extends AbstractMeshTest {
    private Random rnd = new Random();

    @Test
    public void testDeleteLastLanguageFromNode() throws Exception {
        this.grantAdmin();
        HibNode node = this.folder("news");
        String branchName = "newBranch";
        this.waitForLatestJob(() -> ClientHelper.call(() -> this.client().createBranch("dummy", new BranchCreateRequest().setName(branchName), new ParameterProvider[0])));
        String branchUuid = ((BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]))).getData().stream().filter(b -> b.getName().equals(branchName)).findFirst().get().getUuid();
        HashSet<String> childrenUuids = new HashSet<String>();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            Assertions.assertThat((Iterable)nodeDao.getChildren(node, this.initialBranchUuid())).as("The node must have children", new Object[0]).isNotEmpty();
            for (HibNode child : nodeDao.getChildren(node, this.initialBranchUuid())) {
                this.collectUuids(child, childrenUuids);
            }
        }
        String uuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> node.getSchemaContainer().getUuid());
        String schemaName = (String)this.tx(() -> node.getSchemaContainer().getName());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", uuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        ((MapAssert)Assertions.assertThat((Map)response.getAvailableLanguages()).as("The node should have two container", new Object[0])).hasSize(2);
        NodeResponse responseForRelease = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("newBranch")}));
        ((MapAssert)Assertions.assertThat((Map)responseForRelease.getAvailableLanguages()).as("The node should have two container", new Object[0])).hasSize(2);
        this.expect(MeshEvent.NODE_CONTENT_DELETED).match(1, NodeMeshEventModel.class, event -> {
            Assert.assertEquals((Object)"de", (Object)event.getLanguageTag());
            Assert.assertEquals((Object)branchUuid, (Object)event.getBranchUuid());
            Assert.assertEquals((Object)uuid, (Object)event.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)schemaName, (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            Assert.assertNotNull((Object)schemaRef.getVersion());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, "de", new ParameterProvider[0]));
        this.awaitEvents();
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        ((MapAssert)Assertions.assertThat((Map)response.getAvailableLanguages()).as("The node should only have a single container/language", new Object[0])).hasSize(1);
        this.assertThatSubNodesExist(childrenUuids, this.initialBranchUuid());
        this.assertThatSubNodesExist(childrenUuids, branchName);
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_delete_failed_last_container_for_branch", (String[])new String[0]);
        this.assertThatSubNodesExist(childrenUuids, branchName);
        this.assertThatSubNodesExist(childrenUuids, this.initialBranchUuid());
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(false)}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_delete_failed_node_has_children", (String[])new String[0]);
        this.assertThatSubNodesExist(childrenUuids, branchName);
        this.assertThatSubNodesExist(childrenUuids, this.initialBranchUuid());
        this.expect(MeshEvent.NODE_CONTENT_DELETED).match(1, NodeMeshEventModel.class, event -> {
            Assert.assertEquals((Object)"en", (Object)event.getLanguageTag());
            Assert.assertEquals((Object)branchUuid, (Object)event.getBranchUuid());
            Assert.assertEquals((Object)uuid, (Object)event.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)schemaName, (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            Assert.assertNotNull((Object)schemaRef.getVersion());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
        });
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, "en", new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        this.awaitEvents();
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
        Assert.assertNull((String)"We currently expect the node to be returned but without any contents.", (Object)nodeResponse.getLanguage());
        this.assertThatSubNodesWereDeleted(childrenUuids, branchName);
        this.assertThatSubNodesExist(childrenUuids, this.initialBranchUuid());
    }

    @Test
    public void testDeleteNodeFromRelease() {
        this.grantAdmin();
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String SECOND_BRANCH_NAME = "branch2";
        NodeCreateRequest request = new NodeCreateRequest();
        SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
        schemaReference.setName("content");
        schemaReference.setUuid(schemaUuid);
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setSchema((SchemaReference)schemaReference);
        request.setLanguage("en");
        request.setParentNodeUuid(parentNodeUuid);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        String uuid = response.getUuid();
        this.updateNode(1, uuid, "dummy");
        this.updateNode(2, uuid, "dummy");
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        this.updateNode(3, uuid, "dummy");
        this.updateNode(4, uuid, "dummy");
        this.waitForJobs(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName("branch2");
            ClientHelper.call(() -> this.client().createBranch("dummy", branchCreateRequest, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        this.updateNode(5, uuid, "dummy");
        this.updateNode(6, uuid, "dummy");
        this.updateNode(5, uuid, "branch2");
        this.updateNode(6, uuid, "branch2");
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("dummy")}));
        NodeResponse responseB = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("branch2")}));
        Assert.assertEquals((Object)"en", (Object)responseB.getLanguage());
        Assert.assertFalse((boolean)responseB.getFields().isEmpty());
        NodeResponse responseA = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("dummy")}));
        Assert.assertNull((Object)responseA.getLanguage());
        Assertions.assertThat((Object)responseA.getFields()).isNull();
        NodeListResponse childrenA = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", parentNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("dummy")}));
        Optional<NodeResponse> childA = childrenA.getData().stream().filter(n -> n.getUuid().equals(uuid)).findFirst();
        Assert.assertFalse((String)"The node was deleted from the branch and should not be present.", (boolean)childA.isPresent());
        NodeListResponse childrenB = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", parentNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch("branch2")}));
        Optional<NodeResponse> childB = childrenB.getData().stream().filter(n -> n.getUuid().equals(uuid)).findFirst();
        Assert.assertTrue((boolean)childB.isPresent());
    }

    @Test
    public void testDeleteForBranch() throws Exception {
        HibNode node = this.content("concorde");
        String uuid = (String)this.tx(() -> node.getUuid());
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setNewBranch(newBranch);
        context.setOldBranch((HibBranch)this.tx(() -> this.initialBranch()));
        this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
        String newBranchUuid = (String)this.tx(() -> newBranch.getUuid());
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchUuid)}));
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getUuid())}));
        try (Tx tx = this.tx();){
            MeshAssert.assertElement((RootDao)tx.nodeDao(), (HibCoreElement)this.project(), (String)uuid, (boolean)true);
            Assertions.assertThat((Iterable)tx.contentDao().getFieldContainers(node, this.initialBranch(), ContainerType.DRAFT)).as("draft containers for initial branch", new Object[0]).isNotEmpty();
            Assertions.assertThat((Iterable)tx.contentDao().getFieldContainers(node, newBranch, ContainerType.DRAFT)).as("draft containers for new branch", new Object[0]).isEmpty();
        }
    }

    @Test
    @Ignore
    public void testDeletePublishedForBranch() throws Exception {
        HibNode node = this.content("concorde");
        String uuid = (String)this.tx(() -> node.getUuid());
        HibBranch newBranch = (HibBranch)this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(node, this.mockActionContext(), bac);
            HibBranch b = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(b);
            context.setOldBranch(this.initialBranch());
            this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
            return b;
        });
        String newBranchUuid = (String)this.tx(() -> newBranch.getUuid());
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchUuid)}));
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranchUuid)}));
        try (Tx tx2 = this.tx();){
            MeshAssert.assertElement((RootDao)tx2.nodeDao(), (HibCoreElement)this.project(), (String)uuid, (boolean)true);
            Assertions.assertThat((Iterable)tx2.contentDao().getFieldContainers(node, this.initialBranch(), ContainerType.DRAFT)).as("draft containers for initial branch", new Object[0]).isNotEmpty();
            Assertions.assertThat((Iterable)tx2.contentDao().getFieldContainers(node, this.initialBranch(), ContainerType.PUBLISHED)).as("published containers for initial branch", new Object[0]).isNotEmpty();
            Assertions.assertThat((Iterable)tx2.contentDao().getFieldContainers(node, newBranch, ContainerType.DRAFT)).as("draft containers for new branch", new Object[0]).isEmpty();
            Assertions.assertThat((Iterable)tx2.contentDao().getFieldContainers(node, newBranch, ContainerType.PUBLISHED)).as("published containers for new branch", new Object[0]).isEmpty();
        }
    }

    @Test
    public void testDeleteBaseNode() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            String uuid = node.getUuid();
            ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED, (String)"node_basenode_not_deletable", (String[])new String[0]);
            HibNode foundNode = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), uuid);
            Assert.assertNotNull((String)"The node should still exist.", (Object)foundNode);
        }
    }

    @Test
    @Ignore
    public void testDeleteRecursiveFromBranch2() throws InterruptedException {
        this.grantAdmin();
        String newsFolderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        ArrayList<String> uuids = new ArrayList<String>();
        this.createTree(uuids, newsFolderUuid, 90, 0, this.initialBranchUuid(), true);
        String newBranchUuid = this.createBranch();
        System.out.println("Taking nodes in new branch offline");
        ClientHelper.call(() -> this.client().takeNodeOffline(this.projectName(), newsFolderUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true), new VersioningParametersImpl().setBranch(newBranchUuid)}));
        System.out.println("Done");
        CountDownLatch allDone = new CountDownLatch(2);
        this.publish(allDone, newsFolderUuid, newBranchUuid);
        this.deleteNode(allDone, newsFolderUuid, this.initialBranchUuid());
        allDone.await(30L, TimeUnit.SECONDS);
        System.out.println("All done. Testing delete again..");
        this.deleteParent(newsFolderUuid, this.initialBranchUuid());
        System.out.println("Done!");
    }

    private void publish(CountDownLatch allDone, String uuid, String branchUuid) {
        this.vertx().executeBlocking(bc -> {
            try {
                System.out.println("Publishing node {" + uuid + "}");
                ClientHelper.call(() -> this.client().publishNode(this.projectName(), uuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true), new VersioningParametersImpl().setBranch(branchUuid)}));
                bc.complete();
            }
            catch (Throwable t) {
                bc.fail(t);
            }
        }, false, rh -> {
            if (rh.failed()) {
                System.out.println("Publish failed");
                rh.cause().printStackTrace();
            } else {
                System.out.println("Publish done");
            }
            allDone.countDown();
        });
    }

    private void createNode(CountDownLatch allDone, List<String> uuids, String branchUuid) {
        this.vertx().executeBlocking(bc -> {
            try {
                String parentNodeUuid = this.random(uuids);
                System.out.println("Creating node in {" + parentNodeUuid + "}");
                this.createNode(null, parentNodeUuid, "i:" + System.currentTimeMillis(), branchUuid, true);
                bc.complete();
            }
            catch (Throwable t) {
                bc.fail(t);
            }
        }, false, rh -> {
            if (rh.failed()) {
                System.out.println("Create failed");
                rh.cause().printStackTrace();
            } else {
                System.out.println("Create done");
            }
            allDone.countDown();
        });
    }

    private void deleteNode(CountDownLatch allDone, String uuid, String branchUuid) {
        this.vertx().executeBlocking(bc -> {
            System.out.println("Deleting node");
            try {
                this.deleteParent(uuid, branchUuid);
                bc.complete();
            }
            catch (Throwable t) {
                bc.fail(t);
            }
        }, false, rh -> {
            if (rh.failed()) {
                System.out.println("Delete failed");
                rh.cause().printStackTrace();
            } else {
                System.out.println("Delete done");
            }
            allDone.countDown();
        });
    }

    private void deleteParent(String uuid, String branchUuid) {
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid), new DeleteParametersImpl().setRecursive(true)}));
    }

    private String random(List<String> uuids) {
        int idx = this.rnd.nextInt(uuids.size());
        System.out.println("Idx: " + idx);
        return uuids.get(idx);
    }

    @Test
    public void testDeleteRecursiveFromBranch() {
        int i;
        this.grantAdmin();
        String newsFolderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String branchedNodeUuid = (String)this.tx(() -> this.content("concorde").getUuid());
        String nodeInBoth = this.createNode(null, newsFolderUuid, "root", this.initialBranchUuid(), false).getUuid();
        String branchUuid = this.createBranch();
        int nNodes = 10;
        HashMap<Integer, String> uuids = new HashMap<Integer, String>();
        for (i = 0; i <= 10; ++i) {
            NodeResponse response = this.createNode(null, newsFolderUuid, "" + i, this.initialBranchUuid(), false);
            uuids.put(i, response.getUuid());
            if (i % 10 != 0) continue;
            System.out.println("Creating node {" + i + "} of {10}");
        }
        for (i = 0; i <= 10; ++i) {
            String uuid = (String)uuids.get(i);
            this.createNode(uuid, newsFolderUuid, "" + i, branchUuid, true);
            if (i % 10 != 0) continue;
            System.out.println("Creating node {" + i + "} of {10}");
        }
        for (i = 0; i <= 10; ++i) {
            this.createNode(null, newsFolderUuid, "b" + i, branchUuid, true);
            if (i % 10 != 0) continue;
            System.out.println("Creating node {" + i + "} of {10}");
        }
        for (i = 0; i <= 10; ++i) {
            this.createNode(null, newsFolderUuid, "c" + i, this.initialBranchUuid(), false);
            if (i % 10 != 0) continue;
            System.out.println("Creating node {" + i + "} of {10}");
        }
        ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeInBoth, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid)}));
        ClientHelper.call(() -> this.client().takeNodeOffline(this.projectName(), nodeInBoth, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        ClientHelper.call(() -> this.client().deleteNode(this.projectName(), branchedNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid)}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", newsFolderUuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", newsFolderUuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(branchUuid)}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", branchedNodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(branchUuid)}));
        ClientHelper.call(() -> this.client().deleteNode("dummy", newsFolderUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid()), new DeleteParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().deleteNode("dummy", newsFolderUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid), new DeleteParametersImpl().setRecursive(true)}));
    }

    private void createTree(List<String> uuids, String parentUuid, int depth, int pages, String branchUuid, boolean publish) {
        if (depth <= 0) {
            System.out.println("Done");
            return;
        }
        NodeResponse node = this.createFolder(parentUuid, depth, branchUuid, publish);
        System.out.println(depth + ": " + parentUuid + " -> " + node.getUuid());
        uuids.add(node.getUuid());
        for (int i = 0; i < pages; ++i) {
            NodeResponse content = this.createNode(null, node.getUuid(), "p" + i, branchUuid, publish);
            System.out.println("    --> " + content.getUuid());
        }
        this.createTree(uuids, node.getUuid(), --depth, pages, branchUuid, publish);
    }

    private NodeResponse createFolder(String parentNodeUuid, int i, String branchUuid, boolean publish) {
        VersioningParameters branchParam = new VersioningParametersImpl().setBranch(branchUuid);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        FieldMapImpl fields = new FieldMapImpl();
        fields.put("teaser", (Field)FieldUtil.createStringField((String)("some teaser" + i)));
        fields.put("slug", (Field)FieldUtil.createStringField((String)("new-page" + i + ".html")));
        fields.put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.setFields((FieldMap)fields);
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode(this.projectName(), nodeCreateRequest, new ParameterProvider[]{branchParam}));
        if (publish) {
            ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeResponse.getUuid(), new ParameterProvider[]{branchParam}));
        }
        return nodeResponse;
    }

    private String createBranch() {
        AtomicReference branchUuid = new AtomicReference();
        this.waitForJob(() -> {
            BranchCreateRequest request = new BranchCreateRequest().setName("newBranch").setLatest(false);
            String uuid = ((BranchResponse)ClientHelper.call(() -> this.client().createBranch(this.projectName(), request, new ParameterProvider[0]))).getUuid();
            branchUuid.set(uuid);
        });
        return (String)branchUuid.get();
    }

    private NodeResponse createNode(String uuid, String parentNodeUuid, String postfix, String branchUuid, boolean publish) {
        VersioningParameters branchParam = new VersioningParametersImpl().setBranch(branchUuid);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        FieldMapImpl fields = new FieldMapImpl();
        fields.put("name", (Field)FieldUtil.createStringField((String)("Folder " + postfix)));
        fields.put("slug", (Field)FieldUtil.createStringField((String)("folder" + postfix)));
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("folder");
        nodeCreateRequest.setFields((FieldMap)fields);
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        NodeResponse nodeResponse = uuid == null ? (NodeResponse)ClientHelper.call(() -> this.client().createNode(this.projectName(), nodeCreateRequest, new ParameterProvider[]{branchParam})) : (NodeResponse)ClientHelper.call(() -> this.client().createNode(uuid, this.projectName(), nodeCreateRequest, new ParameterProvider[]{branchParam}));
        if (publish) {
            ClientHelper.call(() -> this.client().publishNode(this.projectName(), nodeResponse.getUuid(), new ParameterProvider[]{branchParam}));
        }
        return nodeResponse;
    }

    private void updateNode(int i, String uuid, String branch) {
        VersioningParameters param = new VersioningParametersImpl().setBranch(branch);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{param}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page" + i + ".html")));
        nodeUpdateRequest.setVersion(response.getVersion());
        nodeUpdateRequest.setLanguage("en");
        ClientHelper.call(() -> this.client().updateNode("dummy", response.getUuid(), nodeUpdateRequest, new ParameterProvider[]{param}));
    }

    private void assertThatSubNodesWereDeleted(Set<String> childrenUuids, String branchName) {
        for (String childUuid : childrenUuids) {
            System.out.println("Checking child: " + childUuid);
            NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", childUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
            Assert.assertNull((String)"We currently expect the node to be returned but without any contents.", (Object)nodeResponse.getLanguage());
        }
    }

    private void assertThatSubNodesExist(Set<String> uuids, String branchName) {
        for (String childUuid : uuids) {
            System.out.println("Checking child: " + childUuid);
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", childUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchName)}));
        }
    }

    private void collectUuids(HibNode child, Set<String> childrenUuids) {
        NodeDao nodeDao = Tx.get().nodeDao();
        childrenUuids.add(child.getUuid());
        for (HibNode subchild : nodeDao.getChildren(child, this.initialBranchUuid())) {
            this.collectUuids(subchild, childrenUuids);
        }
    }
}

