/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BinaryFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.ImageManipulationParametersImpl;
import com.gentics.mesh.parameter.image.CropMode;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.FileUtils;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeEndpointBinaryFieldTest
extends AbstractMeshTest {
    @Before
    public void setupPerm() {
        this.grantAdmin();
    }

    @Test
    public void testDownloadBinaryFieldWithReadPublishPerm() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.prepareSchema();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
            ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]));
            MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
            Assert.assertEquals((long)binaryLen, (long)IOUtils.toByteArray((InputStream)response.getStream()).length);
            response.close();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testDownloadBinaryFieldDraftWithNoReadPublishPerm() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.prepareSchema();
        this.revokeAdmin();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
            ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{node.getUuid(), InternalPermission.READ_PUBLISHED_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateNodeWithBinaryField() throws IOException {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)((String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson())), SchemaUpdateRequest.class);
        schemaRequest.getFields().add(FieldUtil.createBinaryFieldSchema((String)"binary"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
        schemaReference.setName("content");
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.getFields().put("binary", (Field)new BinaryFieldImpl());
        request.setSchema((SchemaReference)schemaReference);
        request.setParentNodeUuid((String)this.tx(() -> this.folder("news").getUuid()));
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page2.html"));
        request.getFields().put("binary", (Field)new BinaryFieldImpl().setDominantColor("#2E2EFE"));
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"field_binary_error_unable_to_set_before_upload", (String[])new String[]{"binary"});
    }

    @Test
    public void testCreateNodeWithBinarySha512sum() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)((String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson())), SchemaUpdateRequest.class);
        schemaRequest.getFields().add(FieldUtil.createBinaryFieldSchema((String)"binary"));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
        schemaReference.setName("content");
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.getFields().put("binary", (Field)new BinaryFieldImpl().setSha512sum("someValue"));
        request.setSchema((SchemaReference)schemaReference);
        request.setParentNodeUuid((String)this.tx(() -> this.folder("news").getUuid()));
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"field_binary_error_unable_to_set_before_upload", (String[])new String[]{"binary"});
    }

    @Test
    public void testCreateNodeWithBinaryFieldInfo() throws IOException {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        SchemaUpdateRequest schemaRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)((String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getJson())), SchemaUpdateRequest.class);
        schemaRequest.getFields().add(FieldUtil.createBinaryFieldSchema((String)"binary"));
        this.grantAdmin();
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schemaRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.prepareSchema();
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        String binaryUuid = response.getFields().getBinaryField("binary").getBinaryUuid();
        Assert.assertNotNull((Object)binaryUuid);
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.getFields().put("binary", (Field)new BinaryFieldImpl().setSha512sum(response.getFields().getBinaryField("binary").getSha512sum()).setDominantColor("#2E2EFE"));
        request.setSchemaName("content");
        request.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        NodeResponse createResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        Assert.assertEquals((String)"The binary uuid should match up", (Object)binaryUuid, (Object)createResponse.getFields().getBinaryField("binary").getBinaryUuid());
        ClientHelper.call(() -> this.client().deleteNode("dummy", (String)this.tx(() -> node.getUuid()), new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", createResponse.getUuid(), new ParameterProvider[0]));
        Assert.assertNotNull((String)"The binary should still be attached to the node.", (Object)response.getFields().getBinaryField("binary").getBinaryUuid());
    }

    @Test
    public void testDownloadBinaryField() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.prepareSchema();
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
            MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", new ParameterProvider[0]));
            Assert.assertEquals((long)binaryLen, (long)IOUtils.toByteArray((InputStream)response.getStream()).length);
            response.close();
        }
    }

    @Test
    public void testDownloadBinaryFieldEncoding() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "some \u01f92a file.dat";
        HibNode node = this.prepareSchema();
        String uuid = (String)this.tx(() -> node.getUuid());
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        MeshResponse response = (MeshResponse)this.client().downloadBinaryField("dummy", uuid, "en", "binary", new ParameterProvider[0]).getResponse().blockingGet();
        List params = Arrays.asList(((String)response.getHeader("content-disposition").get()).split(";")).stream().map(String::trim).collect(Collectors.toList());
        Assert.assertEquals((Object)"attachment", params.get(0));
        Assert.assertEquals((Object)"filename=\"some ?2a file.dat\"", params.get(1));
        Assert.assertEquals((Object)"filename*=utf-8''some+%C7%B92a+file.dat", params.get(2));
    }

    @Test
    public void testDownloadBinaryFieldRange() throws IOException {
        String contentType = "plain/text";
        String data = "Hello World!";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.prepareSchema();
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getVersion());
        String uuid = (String)this.tx(() -> node.getUuid());
        Buffer buffer = Buffer.buffer((String)data);
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.getBytes());
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), "binary", (InputStream)stream, (long)buffer.length(), fileName, contentType, new ParameterProvider[0]));
        MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", 0L, 4L, new ParameterProvider[0]));
        String decoded = new String(IOUtils.toByteArray((InputStream)response.getStream()));
        Assert.assertEquals((Object)"Hello", (Object)decoded);
        response.close();
        response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", 6L, 10L, new ParameterProvider[0]));
        decoded = new String(IOUtils.toByteArray((InputStream)response.getStream()));
        Assert.assertEquals((Object)"World", (Object)decoded);
        response.close();
        response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", 0L, 4L, new ParameterProvider[0]));
        decoded = new String(IOUtils.toByteArray((InputStream)response.getStream()));
        Assert.assertEquals((Object)"Hello", (Object)decoded);
        response.close();
    }

    @Test
    public void testDownloadBinaryFieldWithPresetFocalPoint() throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        InputStream ins = this.getClass().getResourceAsStream("/pictures/android-gps.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid(parentNodeUuid);
        nodeCreateRequest.setSchemaName("binary_content");
        NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
        NodeUpdateRequest nodeUpdateRequest = node2.toRequest();
        BinaryField field = nodeUpdateRequest.getFields().getBinaryField("binary");
        field.setFocalPoint(0.4f, 0.2f);
        nodeUpdateRequest.getFields().put("binary", (Field)field);
        ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), nodeUpdateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", "binary", new ParameterProvider[]{new ImageManipulationParametersImpl().setCropMode(CropMode.FOCALPOINT).setWidth(Integer.valueOf(200)).setHeight(Integer.valueOf(300))}));
    }

    @Test
    public void testUploadImagesConcurrently() throws IOException {
        String parentUuid;
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            parentUuid = node.getUuid();
            tx.success();
        }
        SchemaCreateRequest schemaRequest = new SchemaCreateRequest().setName("imageSchema").setFields(Arrays.asList(new BinaryFieldSchemaImpl().setName("image1"), new BinaryFieldSchemaImpl().setName("image2").setRequired(true)));
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest().setSchema((SchemaReference)schema.toReference()).setParentNodeUuid(parentUuid).setLanguage("en");
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        Buffer buffer = Buffer.buffer((byte[])IOUtils.toByteArray((InputStream)ins));
        String blumeSum = "0b8f63eaa9893d994572a14a012c886d4b6b7b32f79df820f7aed201b374c89cf9d40f79345d5d76662ea733b23ed46dbaa243368627cbfe91a26c6452b88a29";
        Function uploadBinary = fieldName -> this.client().updateNodeBinaryField("dummy", nodeResponse.getUuid(), nodeResponse.getLanguage(), nodeResponse.getVersion(), fieldName, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "blume.jpg", "image/jpeg", new ParameterProvider[0]).toObservable().doOnSubscribe(e -> System.out.println("Requesting " + fieldName));
        Observable imageFields = Observable.just((Object)"image1", (Object)"image2");
        imageFields.flatMap(uploadBinary).ignoreElements().blockingAwait();
        Function downloadBinary = fieldName -> this.client().downloadBinaryField("dummy", nodeResponse.getUuid(), nodeResponse.getLanguage(), fieldName, new ParameterProvider[0]).toObservable();
        Consumer<String> assertSum = sum -> Assert.assertEquals((String)"Checksum did not match", (Object)blumeSum, (Object)sum);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeResponse.getUuid(), new ParameterProvider[0]));
        System.out.println(response.toJson());
        Assert.assertEquals((Object)"image/jpeg", (Object)response.getFields().getBinaryField("image1").getMimeType());
        Assert.assertEquals((Object)"image/jpeg", (Object)response.getFields().getBinaryField("image2").getMimeType());
        Assert.assertEquals((Object)"#737042", (Object)response.getFields().getBinaryField("image1").getDominantColor());
        Assert.assertEquals((Object)"#737042", (Object)response.getFields().getBinaryField("image2").getDominantColor());
        imageFields.flatMap(downloadBinary).map(responseBody -> {
            Buffer body = Buffer.buffer((byte[])IOUtils.toByteArray((InputStream)responseBody.getStream()));
            responseBody.close();
            return body;
        }).map(FileUtils::hash).map(e -> (String)e.blockingGet()).map(e -> assertSum).ignoreElements().blockingAwait();
    }

    private HibNode prepareSchema() throws IOException {
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        return node;
    }
}

