/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.http.HttpConstants;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
@RunWith(value=VertxUnitRunner.class)
public class NodeEndpointETagReferenceTest
extends AbstractMeshTest {
    @Before
    public void createSchemas(TestContext context) {
        this.createReferenceMicroschema().toCompletable().andThen((CompletableSource)this.createReferenceSchema().toCompletable()).subscribe(this.testSubscriber(context));
    }

    private CompletableObserver testSubscriber(final TestContext context) {
        final Async async = context.async();
        return new CompletableObserver(){

            public void onSubscribe(Disposable d) {
            }

            public void onComplete() {
                async.complete();
            }

            public void onError(Throwable e) {
                context.fail(e);
            }
        };
    }

    @Test
    public void testNodeField(TestContext context) {
        this.assertChangedReference("Check Node Field", (nodeToCheck, nodeToDelete) -> nodeToCheck.getFields().put("node", (Field)new NodeFieldImpl().setUuid(nodeToDelete.getUuid()))).subscribe(this.testSubscriber(context));
    }

    @Test
    public void testNodeListField(TestContext context) {
        this.assertChangedReference("Check Node List Field", (nodeToCheck, nodeToDelete) -> nodeToCheck.getFields().put("nodeList", (Field)new NodeFieldListImpl().setItems(Arrays.asList(new NodeFieldListItemImpl().setUuid(nodeToDelete.getUuid()))))).subscribe(this.testSubscriber(context));
    }

    @Test
    public void testNodeFieldInMicronode(TestContext context) {
        this.assertChangedReference("Check Node Field in Microschema Field", (nodeToCheck, nodeToDelete) -> {
            MicronodeResponse micronode = new MicronodeResponse();
            micronode.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("RefMicroschema"));
            micronode.getFields().put("m-node", (Field)new NodeFieldImpl().setUuid(nodeToDelete.getUuid()));
            nodeToCheck.getFields().put("micronode", (Field)micronode);
        }).subscribe(this.testSubscriber(context));
    }

    @Test
    public void testNodeListFieldInMicronode(TestContext context) {
        this.assertChangedReference("Check Node List Field in Microschema Field", (nodeToCheck, nodeToDelete) -> {
            MicronodeResponse micronode = new MicronodeResponse();
            micronode.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("RefMicroschema"));
            micronode.getFields().put("m-nodeList", (Field)new NodeFieldListImpl().setItems(Arrays.asList(new NodeFieldListItemImpl().setUuid(nodeToDelete.getUuid()))));
            nodeToCheck.getFields().put("micronode", (Field)micronode);
        }).subscribe(this.testSubscriber(context));
    }

    @Test
    public void testNodeFieldInMicronodeList(TestContext context) {
        this.assertChangedReference("Check Node Field in Microschema Field List", (nodeToCheck, nodeToDelete) -> {
            MicronodeResponse micronode = new MicronodeResponse();
            micronode.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("RefMicroschema"));
            micronode.getFields().put("m-node", (Field)new NodeFieldImpl().setUuid(nodeToDelete.getUuid()));
            nodeToCheck.getFields().put("micronodeList", (Field)new MicronodeFieldListImpl().setItems(Arrays.asList(micronode)));
        }).subscribe(this.testSubscriber(context));
    }

    @Test
    public void testNodeListFieldinMicronodeList(TestContext context) {
        this.assertChangedReference("Check Node List Field in Microschema Field List", (nodeToCheck, nodeToDelete) -> {
            MicronodeResponse micronode = new MicronodeResponse();
            micronode.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("RefMicroschema"));
            micronode.getFields().put("m-nodeList", (Field)new NodeFieldListImpl().setItems(Arrays.asList(new NodeFieldListItemImpl().setUuid(nodeToDelete.getUuid()))));
            nodeToCheck.getFields().put("micronodeList", (Field)new MicronodeFieldListImpl().setItems(Arrays.asList(micronode)));
        }).subscribe(this.testSubscriber(context));
    }

    private Single<MicroschemaResponse> createReferenceMicroschema() {
        MicroschemaCreateRequest req = new MicroschemaCreateRequest();
        req.setName("RefMicroschema");
        req.setFields(Arrays.asList(new NodeFieldSchemaImpl().setName("m-node"), new ListFieldSchemaImpl().setListType("node").setName("m-nodeList")));
        return this.client().createMicroschema(req).toSingle().flatMap(microSchema -> this.client().assignMicroschemaToProject("dummy", microSchema.getUuid()).toCompletable().andThen((SingleSource)Single.just((Object)microSchema)));
    }

    private Single<SchemaResponse> createReferenceSchema() {
        SchemaCreateRequest req = new SchemaCreateRequest();
        req.setName("RefSchema");
        req.setFields(Arrays.asList(new NodeFieldSchemaImpl().setName("node"), new ListFieldSchemaImpl().setListType("node").setName("nodeList"), new MicronodeFieldSchemaImpl().setAllowedMicroSchemas(new String[]{"RefMicroschema"}).setName("micronode"), new ListFieldSchemaImpl().setListType("micronode").setName("micronodeList")));
        return this.client().createSchema(req, new ParameterProvider[0]).toSingle().flatMap(schema -> this.client().assignSchemaToProject("dummy", schema.getUuid()).toCompletable().andThen((SingleSource)Single.just((Object)schema)));
    }

    private Single<NodeResponse> createReferenceNode() {
        return this.getRootUuid().flatMap(rootUuid -> {
            NodeCreateRequest req = new NodeCreateRequest();
            req.setLanguage("en");
            req.setSchemaName("RefSchema");
            req.setParentNodeUuid(rootUuid);
            return this.client().createNode("dummy", req, new ParameterProvider[0]).toSingle();
        });
    }

    private Single<String> getRootUuid() {
        return this.client().findProjects(new ParameterProvider[0]).toSingle().map(it -> ((ProjectResponse)it.getData().get(0)).getRootNode().getUuid());
    }

    private Completable assertChangedReference(String assertionName, BiConsumer<NodeResponse, NodeResponse> fieldChanger) {
        return Single.zip(this.createReferenceNode(), this.createReferenceNode(), (nodeToCheck, nodeToDelete) -> {
            fieldChanger.accept((NodeResponse)nodeToCheck, (NodeResponse)nodeToDelete);
            return this.updateNode((NodeResponse)nodeToCheck).toCompletable().andThen(this.getEtag((NodeResponse)nodeToCheck)).flatMapCompletable(oldETag -> this.client().deleteNode("dummy", nodeToDelete.getUuid(), new ParameterProvider[0]).toCompletable().andThen(this.getEtag((NodeResponse)nodeToCheck)).doOnSuccess(newEtag -> Assert.assertNotEquals((String)assertionName, (Object)oldETag, (Object)newEtag)).toCompletable());
        }).flatMapCompletable(x -> x);
    }

    private Single<NodeResponse> updateNode(NodeResponse node) {
        NodeUpdateRequest req = new NodeUpdateRequest();
        req.setLanguage(node.getLanguage());
        req.setFields(node.getFields());
        req.setVersion(node.getVersion());
        return this.client().updateNode("dummy", node.getUuid(), req, new ParameterProvider[0]).toSingle();
    }

    private Single<String> getEtag(NodeResponse node) {
        return this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]).getResponse().map(response -> response.getHeader(HttpConstants.ETAG).orElse(null));
    }
}

