/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        String etag = ClientHelper.callETag(() -> this.client().findNodes("dummy", new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodes("dummy", new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
        ClientHelper.callETag(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        ClientHelper.callETag(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(2L))}), (String)etag, (boolean)true, (int)200);
    }

    @Test
    public void testReadWithoutETag() {
        String etag = ClientHelper.callETagRaw(() -> this.client().findNodes("dummy", new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
        etag = ClientHelper.callETagRaw(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        etag = ClientHelper.callETagRaw(() -> this.client().findNodeChildren("dummy", folderUuid, new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
    }

    @Test
    public void testReadNodeTags() {
        String nodeUuid = this.contentUuid();
        String etag = ClientHelper.callETag(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
        ClientHelper.callETag(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        ClientHelper.callETag(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(2L))}), (String)etag, (boolean)true, (int)200);
        ClientHelper.call(() -> this.client().addTagToNode("dummy", nodeUuid, (String)this.tx(() -> this.tag("red").getUuid()), new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
    }

    @Test
    public void testPublishUnpublishNode() {
        String uuid = this.contentUuid();
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        String etag = ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", uuid, new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
    }

    @Test
    public void testPublishUnpublishNodeLanguage() {
        String uuid = this.contentUuid();
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("de");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"Title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        String etag = ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"})}));
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", uuid, "de", new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
        ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", uuid, "de", new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
    }

    @Test
    public void testReadChildren() {
        String uuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        String etag = ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
        ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(2L))}), (String)etag, (boolean)true, (int)200);
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNode(new NodeReference().setUuid(uuid));
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"someTeaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"someSlug"));
        NodeResponse createdNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}), (String)etag, (boolean)true, (int)304);
        ClientHelper.call(() -> this.client().publishNode("dummy", createdNode.getUuid(), new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findNodeChildren("dummy", uuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
    }

    @Test
    public void testReadOne() {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.content();
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer original = contentDao.getFieldContainer(node, "en");
            HibSchemaVersion schemaVersion = contentDao.getSchemaContainerVersion(original);
            SchemaVersionModel schema = schemaVersion.getSchema();
            schema.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"reference"));
            schemaVersion.setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)schemaVersion);
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), this.project().getLatestBranch(), this.user(), original, true);
            container.createNode("reference", this.folder("2015"));
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.content();
            NodeDao nodeDao = tx.nodeDao();
            String actualEtag = ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]));
            String etag = nodeDao.getETag((HibTransformableElement)node, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)actualEtag);
            Assertions.assertThat((String)ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304)).contains(new CharSequence[]{etag});
            Assert.assertNotEquals((String)"A different etag should have been generated since we are not requesting the expanded node.", (Object)etag, (Object)ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)200));
            String newETag = ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandedFieldNames(new String[]{"reference"})}), (String)etag, (boolean)true, (int)200);
            Assert.assertNotEquals((String)"We added parameters and thus a new etag should have been generated.", (Object)newETag, (Object)ClientHelper.callETag(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandedFieldNames(new String[]{"reference", "bla"})}), (String)newETag, (boolean)true, (int)200));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

