/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeEndpointFieldAPIeTagTest
extends AbstractMeshTest {
    @Test
    public void testReadOne() throws Exception {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String nodeUuid = node.getUuid();
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        String etag = ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]));
        Assert.assertNotNull((String)"A etag should have been generated.", (Object)etag);
        ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]), (String)etag, (boolean)false, (int)304);
    }

    @Test
    public void testChangedBinary() throws Exception {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String nodeUuid = node.getUuid();
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        String etag = ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]));
        Assert.assertNotNull((String)"A etag should have been generated.", (Object)etag);
        ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]), (String)etag, (boolean)false, (int)304);
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        etag = ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]), (String)etag, (boolean)false, (int)200);
        Assert.assertNotNull((String)"A etag should have been generated.", (Object)etag);
        ClientHelper.callETag(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "binary", new ParameterProvider[0]), (String)etag, (boolean)false, (int)304);
    }
}

