/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.FieldMapAssert;
import com.gentics.mesh.assertj.impl.NodeGraphFieldContainerAssert;
import com.gentics.mesh.assertj.impl.NodeMeshEventModelAssert;
import com.gentics.mesh.assertj.impl.NodeResponseAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibLanguage;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.RootDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.ObjectPermissionGrantRequest;
import com.gentics.mesh.core.rest.common.ObjectPermissionResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeUpsertRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.role.RoleReference;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.demo.UserInfo;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.VersioningParameters;
import com.gentics.mesh.parameter.client.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRestClientUtil;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Test
    public void testCreateNodeWithNoLanguageCode() {
        try (Tx tx = this.tx();){
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("content");
            schemaReference.setUuid(this.schemaContainer("content").getUuid());
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setSchema((SchemaReference)schemaReference);
            request.setParentNodeUuid(this.folder("news").getUuid());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_no_languagecode_specified", (String[])new String[0]);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        }
    }

    @Test
    public void testCreateNodeWithBogusLanguageCode() throws GenericRestException, Exception {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String folderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
        schemaReference.setName("content");
        schemaReference.setUuid(schemaUuid);
        schemaReference.setVersion("1.0");
        request.setLanguage("BOGUS");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setSchema((SchemaReference)schemaReference);
        request.setParentNodeUuid(folderUuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"language_not_found", (String[])new String[]{"BOGUS"});
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
    }

    @Test
    public void testCreateNodeInBaseNode() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String folderUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setVersion("1.0").setName("content")).setUuid(schemaUuid));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(folderUuid);
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)restNode).matches(request);
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
    }

    @Test
    public void testCreateFolder() {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String folderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("folder")).setVersion("1.0").setUuid(schemaUuid));
        request.setLanguage("en");
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
        request.setParentNodeUuid(folderUuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)restNode).matches(request);
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
    }

    @Test
    public void testCreateMultiple() {
        try (Tx tx = this.tx();){
            HibNode parentNode = this.folder("news");
            String uuid = parentNode.getUuid();
            Assert.assertNotNull((Object)parentNode);
            Assert.assertNotNull((Object)parentNode.getUuid());
            long start = System.currentTimeMillis();
            for (int i = 1; i < 100; ++i) {
                this.trackingSearchProvider().reset();
                NodeCreateRequest request = new NodeCreateRequest();
                request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
                request.setLanguage("en");
                request.getFields().put("title", (Field)FieldUtil.createStringField((String)("some title " + i)));
                request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)("some teaser " + i)));
                request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page_" + i + ".html")));
                request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
                request.setParentNodeUuid(uuid);
                ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
                long duration = System.currentTimeMillis() - start;
                MeshTestContext.LOG.info((Object)("Duration:" + i + " " + duration / (long)i));
            }
        }
    }

    @Test
    public void testCreateWithoutSegment() {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("dummyData");
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"test"));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        String schemaUuid = response.getUuid();
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaUuid));
        for (int i = 0; i < 10; ++i) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setSchemaName("dummyData");
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.setParentNodeUuid(baseNodeUuid);
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        this.expect(MeshEvent.NODE_CONTENT_CREATED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).uuidNotNull()).hasBranchUuid(this.initialBranchUuid()).hasSchemaName("content").hasSchemaUuid(schemaUuid).hasLanguage("en"));
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((NodeResponse)restNode).matches(request);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
    }

    @Test
    public void testUpsert() {
        String uuid = UUIDUtil.randomUUID();
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeUpsertRequest request = new NodeUpsertRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        for (int i = 0; i < 10; ++i) {
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().upsertNode("dummy", uuid, request, new ParameterProvider[0]));
            Assert.assertEquals((String)"No additional update should alter the version of the node.", (Object)"0.1", (Object)response.getVersion());
        }
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page2.html"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().upsertNode("dummy", uuid, request, new ParameterProvider[0]));
        Assert.assertEquals((Object)"0.2", (Object)response.getVersion());
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("news"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{parentNodeUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        String nodeUuid = UUIDUtil.randomUUID();
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode(nodeUuid, "dummy", request, new ParameterProvider[0]));
            MeshAssertions.assertThat((NodeResponse)restNode).matches(request).hasUuid(nodeUuid);
            this.waitForSearchIdleEvent();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
        }
    }

    @Test
    public void testCreateDeleteCreateWithUuid() throws Exception {
        String nodeUuid = UUIDUtil.randomUUID();
        String nodeUuid2 = UUIDUtil.randomUUID();
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        for (int i = 0; i < 10; ++i) {
            request.setParentNodeUuid(parentNodeUuid);
            ClientHelper.call(() -> this.client().createNode(nodeUuid, "dummy", request, new ParameterProvider[0]));
            request.setParentNodeUuid(nodeUuid);
            ClientHelper.call(() -> this.client().createNode(nodeUuid2, "dummy", request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().deleteNode("dummy", nodeUuid, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        }
    }

    @Override
    @Test
    public void testCreateWithDuplicateUuid() throws Exception {
        String nodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            ClientHelper.call(() -> this.client().createNode(nodeUuid, "dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
        }
    }

    @Test
    public void testCreateForBranchByName() {
        String initialBranchUuid = (String)this.tx(() -> this.initialBranch().getUuid());
        String newBranchUuid = (String)this.tx(() -> this.createBranch("newbranch").getUuid());
        String nodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(nodeUuid);
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch("dummy")}));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode newNode = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), nodeResponse.getUuid());
            for (ContainerType type : Arrays.asList(ContainerType.INITIAL, ContainerType.DRAFT)) {
                ((NodeGraphFieldContainerAssert)((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", initialBranchUuid, type)).as(type + " Field container for initial branch", new Object[0])).isNotNull()).hasVersion("0.1");
                ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", newBranchUuid, type)).as(type + " Field Container for new branch", new Object[0])).isNull();
            }
        }
    }

    @Test
    public void testCreateForBranchByUuid() {
        String nodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String initialBranchUuid = (String)this.tx(() -> this.initialBranch().getUuid());
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(nodeUuid);
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranchUuid)}));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode newNode = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), nodeResponse.getUuid());
            for (ContainerType type : Arrays.asList(ContainerType.INITIAL, ContainerType.DRAFT)) {
                ((NodeGraphFieldContainerAssert)((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", initialBranchUuid, type)).as(type + " Field container for initial branch", new Object[0])).isNotNull()).hasVersion("0.1");
                ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", newBranch.getUuid(), type)).as(type + " Field Container for new branch", new Object[0])).isNull();
            }
        }
    }

    @Test
    public void testCreateForLatestBranch() {
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode parentNode = this.folder("news");
            String uuid = parentNode.getUuid();
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchemaName("content");
            request.setLanguage("en");
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(uuid);
            NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
            HibNode newNode = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), nodeResponse.getUuid());
            for (ContainerType type : Arrays.asList(ContainerType.INITIAL, ContainerType.DRAFT)) {
                ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", this.initialBranchUuid(), type)).as(type + " Field container for initial branch", new Object[0])).isNull();
                ((NodeGraphFieldContainerAssert)((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)contentDao.getFieldContainer(newNode, "en", newBranch.getUuid(), type)).as(type + " Field Container for new branch", new Object[0])).isNotNull()).hasVersion("0.1");
            }
        }
    }

    @Test
    public void testCreateForBogusBranch() {
        String uuid = (String)this.tx(() -> {
            this.createBranch("newbranch");
            HibNode parentNode = this.folder("news");
            return parentNode.getUuid();
        });
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(uuid);
        ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch("bogusbranch")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"branch_error_not_found", (String[])new String[]{"bogusbranch"});
    }

    @Test
    @Ignore
    public void testCreateNodeAndCheckReadOnlyRole() {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        try (Tx tx = this.tx();){
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("content");
            schemaReference.setUuid(this.schemaContainer("content").getUuid());
            request.setSchema((SchemaReference)schemaReference);
            request.setLanguage("de");
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)"Title"));
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(this.folder("news").getUuid());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().draft()}));
            this.waitForSearchIdleEvent();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
            MeshAssertions.assertThat((NodeResponse)restNode).matches(request);
            HibNode node = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), restNode.getUuid());
            Assert.assertNotNull((Object)node);
            MeshAssertions.assertThat((HibNode)node).matches(request);
            NodeResponse restNode2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", restNode.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().draft()}));
            ClientHelper.call(() -> this.client().deleteNode("dummy", restNode2.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().findNodeByUuid(this.projectUuid(), restNode2.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        }
    }

    @Test
    public void testCreateNodeWithMissingParentNodeUuid() throws Exception {
        try (Tx tx = this.tx();){
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("node");
            request.setSchema((SchemaReference)schemaReference);
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_missing_parentnode_field", (String[])new String[0]);
        }
    }

    @Test
    public void testCreateNodeWithMissingSchemaPermission() {
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.schemaContainer("content"), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String uuid = node.getUuid();
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReference schemaReference = (SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid());
            request.setSchema(schemaReference);
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            request.setLanguage("en");
            request.setParentNodeUuid(uuid);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.schemaContainer("content").getUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateNodeWithMissingPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("news"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("news");
            String uuid = node.getUuid();
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReference schemaReference = (SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid());
            request.setSchema(schemaReference);
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            request.setLanguage("en");
            request.setParentNodeUuid(uuid);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadNodesDefaultPaging() throws Exception {
        NodeListResponse restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotNull((Object)restResponse);
        Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)this.getNodeCount(), (long)restResponse.getData().size());
    }

    @Test
    public void testReadMultipleAndAssertOrder() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibNode parentNode = this.folder("2015");
            int nNodes = 20;
            for (int i = 0; i < nNodes; ++i) {
                HibNode node = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
                tx.contentDao().createFieldContainer(node, this.english(), this.initialBranch(), this.user());
                Assert.assertNotNull((Object)node);
                roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            tx.success();
        }
        String firstUuid = null;
        for (int i = 0; i < 10; ++i) {
            NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(100L)), new VersioningParametersImpl().draft()}));
            if (firstUuid == null) {
                firstUuid = ((NodeResponse)response.getData().get(0)).getUuid();
            }
            Assert.assertEquals((String)("The first element in the page should not change but it changed in run {" + i + "}"), (Object)firstUuid, (Object)((NodeResponse)response.getData().get(0)).getUuid());
        }
    }

    @Test
    public void testReadNodeWithFieldLimit() {
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid"})}));
        MeshAssertions.assertThat((String)response.getUuid()).isNotEmpty();
        MeshAssertions.assertThat((Map)response.getAvailableLanguages()).isNull();
        MeshAssertions.assertThat((Map)response.getChildrenInfo()).isNull();
        MeshAssertions.assertThat((FieldMap)response.getFields()).isNull();
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid", "fields"})}));
        System.out.println(response.toJson());
        MeshAssertions.assertThat((String)response.getUuid()).isNotEmpty();
        MeshAssertions.assertThat((FieldMap)response.getFields()).isNotEmpty();
        MeshAssertions.assertThat((Map)response.getAvailableLanguages()).isNull();
        MeshAssertions.assertThat((Map)response.getChildrenInfo()).isNull();
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        HibNode parentNode = this.folder("2015");
        String noPermNodeUUID = (String)this.tx(tx -> {
            HibBranch initialBranch = this.reloadBranch(this.initialBranch());
            HibNode noPermNode = tx.nodeDao().create(parentNode, this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
            tx.contentDao().createFieldContainer(noPermNode, this.english(), initialBranch, this.user());
            return noPermNode.getUuid();
        });
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)noPermNodeUUID).as("UUID of the new node", new Object[0])).isNotNull();
        int nNodes = 20;
        for (int i = 0; i < nNodes; ++i) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"test"));
            nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)("test" + i)));
            nodeCreateRequest.setParentNodeUuid(parentNode.getUuid());
            nodeCreateRequest.setLanguage("en");
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        }
        long perPage = 11L;
        NodeListResponse restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(3, Long.valueOf(perPage)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)perPage, (long)restResponse.getData().size());
        int totalNodes = this.getNodeCount() + nNodes;
        int totalPages = (int)Math.ceil((double)totalNodes / (double)perPage);
        Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)perPage, (long)restResponse.getData().size());
        Assert.assertEquals((long)3L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)totalNodes, (long)restResponse.getMetainfo().getTotalCount());
        Assert.assertEquals((long)totalPages, (long)restResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)perPage, (long)restResponse.getMetainfo().getPerPage());
        ArrayList allNodes = new ArrayList();
        for (int page = 1; page <= totalPages; ++page) {
            restResponse = (NodeListResponse)this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(page, Long.valueOf(perPage)), new VersioningParametersImpl().draft()}).blockingGet();
            allNodes.addAll(restResponse.getData());
        }
        Assert.assertEquals((String)"Somehow not all nodes were loaded when loading all pages.", (long)totalNodes, (long)allNodes.size());
        List filteredUserList = allNodes.parallelStream().filter(restNode -> restNode.getUuid().equals(noPermNodeUUID)).collect(Collectors.toList());
        Assert.assertTrue((String)"The no perm node should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
        ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(25L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
        ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(0, Long.valueOf(25L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"0"});
        ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
        NodeListResponse list = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(25L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)4242L, (long)list.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)0L, (long)list.getData().size());
        Assert.assertEquals((long)25L, (long)list.getMetainfo().getPerPage());
        Assert.assertEquals((long)2L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((long)(this.getNodeCount() + nNodes), (long)list.getMetainfo().getTotalCount());
    }

    @Test
    public void testReadMultipleOnlyMetadata() {
        NodeListResponse listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L)), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((long)0L, (long)listResponse.getData().size());
    }

    @Test
    public void testReadNodesWithoutPermissions() throws Exception {
        NodeListResponse restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(10L)), new VersioningParametersImpl().draft()}));
        int nElements = restResponse.getData().size();
        Assert.assertEquals((String)"The amount of elements in the list did not match the expected count", (long)10L, (long)nElements);
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)2L, (long)restResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)10L, (long)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)this.getNodeCount(), (long)restResponse.getMetainfo().getTotalCount());
    }

    @Test
    public void testReadNodesForBranch() {
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            NodeListResponse restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(1000L)), new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((List)restResponse.getData()).as("Node List for latest branch", new Object[0]).isEmpty();
            restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(1000L)), new VersioningParametersImpl().setBranch(this.initialBranch().getName()).draft()}));
            MeshAssertions.assertThat((List)restResponse.getData()).as("Node List for initial branch", new Object[0]).hasSize(this.getNodeCount());
            HibNode node = this.folder("news");
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(nodeDao.getParentNode(node, this.project().getInitialBranch().getUuid()).getUuid());
            create.setLanguage("en");
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)"News new branch"));
            ClientHelper.call(() -> this.client().createNode(node.getUuid(), "dummy", create, new ParameterProvider[0]));
            restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(1000L)), new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((List)restResponse.getData()).as("Node List for latest branch", new Object[0]).hasSize(1);
            restResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(1000L)), new VersioningParametersImpl().draft().setBranch(newBranch.getName())}));
            MeshAssertions.assertThat((List)restResponse.getData()).as("Node List for latest branch", new Object[0]).hasSize(1);
        }
    }

    @Test
    public void testReadPublishedNodes() {
        try (Tx tx = this.tx();){
            List<HibNode> nodes = Arrays.asList(this.folder("products"), this.folder("deals"), this.folder("news"), this.folder("2015"));
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            NodeListResponse listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
            MeshAssertions.assertThat((List)listResponse.getData()).as("Published nodes list", new Object[0]).isEmpty();
            for (HibNode node2 : nodes) {
                ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node2.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_published_not_found_for_uuid_branch_language", (String[])new String[]{node2.getUuid(), "en", this.latestBranch().getUuid()});
            }
            nodes.stream().forEach(node -> ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0])));
            List publishedNodes = nodes.stream().map(node -> (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]))).collect(Collectors.toList());
            MeshAssertions.assertThat(publishedNodes).hasSize(nodes.size());
            listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
            ((AbstractListAssert)MeshAssertions.assertThat((List)listResponse.getData()).as("Published nodes list", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnlyElementsOf(publishedNodes);
        }
    }

    @Test
    public void testReadPublishedNodesNoPermission() {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeListResponse listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
        MeshAssertions.assertThat((List)listResponse.getData()).as("Published nodes list", new Object[0]).isEmpty();
        List nodes = (List)this.tx(tx -> {
            ArrayList<HibNode> list = new ArrayList<HibNode>(Arrays.asList(this.folder("products"), this.folder("deals"), this.folder("news"), this.folder("2015")));
            list.stream().forEach(node -> ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0])));
            return list;
        });
        while (!nodes.isEmpty()) {
            HibNode folder = (HibNode)nodes.remove(0);
            this.tx(tx -> {
                RoleDao roleDao = tx.roleDao();
                roleDao.revokePermissions(this.role(), (HibBaseElement)folder, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
                roleDao.revokePermissions(this.role(), (HibBaseElement)folder, new InternalPermission[]{InternalPermission.READ_PERM});
                tx.success();
            });
            List publishedNodes = nodes.stream().map(node -> {
                String uuid = (String)this.tx(() -> node.getUuid());
                return (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}));
            }).collect(Collectors.toList());
            MeshAssertions.assertThat(publishedNodes).hasSize(nodes.size());
            listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
            ((AbstractListAssert)MeshAssertions.assertThat((List)listResponse.getData()).as("Published nodes list", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnlyElementsOf(publishedNodes);
        }
    }

    @Test
    public void testReadPublishedNodesNoPermission2() {
        List nodes = (List)this.tx(tx -> {
            ArrayList<HibNode> list = new ArrayList<HibNode>(Arrays.asList(this.folder("products"), this.folder("deals"), this.folder("news"), this.folder("2015")));
            list.stream().forEach(node -> ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0])));
            return list;
        });
        NodeListResponse initialListResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
        int revoked = 0;
        for (HibNode node : nodes) {
            this.tx(tx -> {
                RoleDao roleDao = tx.roleDao();
                roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
                roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
                tx.success();
            });
            ++revoked;
            String uuid = (String)this.tx(() -> node.getUuid());
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}));
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
            NodeListResponse listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().published(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
            MeshAssertions.assertThat((List)listResponse.getData()).as("Published nodes list", new Object[0]).hasSameSizeAs((Iterable)initialListResponse.getData());
            listResponse = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().draft(), new PagingParametersImpl(1, Long.valueOf(1000L))}));
            MeshAssertions.assertThat((List)listResponse.getData()).as("Draft nodes list", new Object[0]).hasSize(initialListResponse.getData().size() - revoked);
        }
    }

    @Test
    @Ignore(value="Test covers bug https://github.com/gentics/mesh/issues/1104")
    public void testReadPublishedNodeNoPermission3() {
        String uuid = (String)this.tx(() -> this.content().getUuid());
        NodeResponse draftResponse1 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        NodeResponse publishedResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assert.assertEquals((String)"Draft and publish versions should be the same since mesh automatically creates a new draft based on the published version.", (Object)draftResponse1.getVersion(), (Object)publishedResponse.getVersion());
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"test123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse draftResponse2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibNode node = this.content();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.DELETE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.PUBLISH_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        });
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(draftResponse2.getVersion())}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        String version = publishedResponse.getVersion();
        System.out.println(version);
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion(version)}));
    }

    @Test
    @Ignore(value="Disabled until custom 404 handler has been added")
    public void testReadNodeWithBogusProject() {
        ClientHelper.call(() -> this.client().findNodeByUuid("BOGUS", "someUuuid", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_not_found", (String[])new String[]{"BOGUS"});
    }

    @Test
    public void testCreateUpdateReadDeleteMultithreaded() throws Exception {
        long nNodesFound;
        String uuid;
        Logger log = LoggerFactory.getLogger(NodeEndpointTest.class);
        int nJobs = 200;
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            HibNode parentNode = this.folder("news");
            uuid = parentNode.getUuid();
            nNodesFound = nodeDao.count((HibCoreElement)this.project());
        }
        Function<Long, NodeCreateRequest> createRequest = nr -> {
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            request.setLanguage("en");
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page" + nr + ".html")));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(uuid);
            return request;
        };
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        updateRequest.setLanguage("en");
        updateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"UPDATED"));
        Observable.intervalRange((long)0L, (long)nJobs, (long)0L, (long)25L, (TimeUnit)TimeUnit.MILLISECONDS).flatMapSingle(i -> {
            log.info((Object)("Invoking createNode REST call for job {" + i + "}"));
            return this.client().createNode("dummy", (NodeCreateRequest)createRequest.apply((Long)i), new ParameterProvider[0]).toSingle();
        }).flatMapSingle(node -> {
            log.info((Object)("Created {" + node.getUuid() + "}"));
            return this.client().updateNode("dummy", node.getUuid(), updateRequest, new ParameterProvider[0]).toSingle();
        }).flatMapSingle(node -> {
            log.info((Object)("Updated {" + node.getUuid() + "}"));
            return this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]).toSingle();
        }).flatMapCompletable(node -> {
            log.info((Object)("Read {" + node.getUuid() + "}"));
            return this.client().deleteNode("dummy", node.getUuid(), new ParameterProvider[0]).toCompletable().doOnComplete(() -> log.info((Object)("Deleted {" + node.getUuid() + "}")));
        }).blockingAwait();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            long nNodesFoundAfterRest = nodeDao.findAll((HibCoreElement)this.project()).count();
            Assert.assertEquals((String)"All created nodes should have been created.", (long)nNodesFound, (long)nNodesFoundAfterRest);
        }
    }

    @Override
    @Test
    public void testCreateMultithreaded() throws InterruptedException {
        int nJobs = 500;
        String uuid = null;
        try (Tx tx = this.tx();){
            HibNode parentNode = this.folder("news");
            uuid = parentNode.getUuid();
            Assert.assertNotNull((Object)parentNode);
            Assert.assertNotNull((Object)parentNode.getUuid());
        }
        String fUuid = uuid;
        MeshTestHelper.validateCreation(nJobs, i -> {
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            request.setLanguage("en");
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some-teaser"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page" + i + ".html")));
            request.setParentNodeUuid(fUuid);
            return this.client().createNode("dummy", request, new ParameterProvider[0]);
        });
    }

    @Override
    @Test
    @Ignore(value="Multithreaded update is currently only possible for multiple nodes not a single node")
    public void testUpdateMultithreaded() throws InterruptedException {
        String newName = "english renamed name";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Assert.assertEquals((Object)"2015", this.tx(tx -> tx.contentDao().getLatestDraftFieldContainer(this.folder("2015"), this.english()).getString("slug").getString()));
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getLatestDraftFieldContainer(this.folder("2015"), this.english()).getVersion());
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("en");
        NodeParametersImpl parameters = new NodeParametersImpl();
        parameters.setLanguages(new String[]{"en", "de"});
        int nJobs = 5;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> {
            System.out.println(version.getFullVersion());
            request.setVersion(version.getFullVersion());
            request.getFields().put("name", (Field)FieldUtil.createStringField((String)("english renamed name:" + i)));
            return this.client().updateNode("dummy", uuid, request, new ParameterProvider[]{parameters});
        });
    }

    @Override
    @Test
    public void testDeleteByUUIDMultithreaded() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        int nJobs = 6;
        ClientHelper.validateDeletion(i -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}), (int)nJobs);
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws InterruptedException {
        int nJobs = 50;
        try (Tx tx = this.tx();){
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws InterruptedException {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}).toCompletable()).blockingAwait();
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.role().getUuid()), new VersioningParametersImpl().draft()}));
            Assert.assertNotNull((Object)response.getRolePerms());
            MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).hasPerm(Permission.values());
        }
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", folderUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String branchUuid = this.project().getLatestBranch().getUuid();
            MeshAssertions.assertThat((HibNode)this.folder("2015")).matches(response);
            Assert.assertNotNull((Object)response.getParentNode());
            Assert.assertEquals((Object)nodeDao.getParentNode(this.folder("2015"), branchUuid).getUuid(), (Object)response.getParentNode().getUuid());
            Assert.assertEquals((Object)"News", (Object)response.getParentNode().getDisplayName());
            Assert.assertEquals((Object)"en", (Object)response.getLanguage());
        }
    }

    @Test
    public void testReadByUUIDWithNoUser() throws Exception {
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            this.folder("2015").setCreated(null);
            contentDao.getLatestDraftFieldContainer(this.folder("2015"), this.english()).setEditor(null);
            tx.success();
        }
        ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", folderUuid, new ParameterProvider[0]));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", folderUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String branchUuid = this.project().getLatestBranch().getUuid();
            MeshAssertions.assertThat((HibNode)this.folder("2015")).matches(response);
            Assert.assertNotNull((Object)response.getParentNode());
            Assert.assertEquals((Object)nodeDao.getParentNode(this.folder("2015"), branchUuid).getUuid(), (Object)response.getParentNode().getUuid());
            Assert.assertEquals((Object)"News", (Object)response.getParentNode().getDisplayName());
            Assert.assertEquals((Object)"en", (Object)response.getLanguage());
        }
    }

    @Test
    public void testReadVersionByNumber() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((NodeResponse)response).hasVersion("1.0").hasLanguage("en").hasStringField("name", "2015");
            NodeUpdateRequest updateRequest = new NodeUpdateRequest();
            updateRequest.setLanguage("en");
            updateRequest.setVersion("1.0");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"one"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            updateRequest.setVersion("1.1");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"two"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            updateRequest.setVersion("1.2");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"three"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            updateRequest.setLanguage("de");
            updateRequest.setVersion(null);
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"eins"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            updateRequest.setVersion("0.1");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"zwei"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            updateRequest.setVersion("0.2");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"drei"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[0]));
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()})))).as("Draft", new Object[0])).hasVersion("1.3").hasLanguage("en").hasStringField("name", "three");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("1.0")})))).as("Version 1.0", new Object[0])).hasVersion("1.0").hasLanguage("en").hasStringField("name", "2015");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("1.1")})))).as("Version 1.1", new Object[0])).hasVersion("1.1").hasLanguage("en").hasStringField("name", "one");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("1.2")})))).as("Version 1.2", new Object[0])).hasVersion("1.2").hasLanguage("en").hasStringField("name", "two");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("1.3")})))).as("Version 1.3", new Object[0])).hasVersion("1.3").hasLanguage("en").hasStringField("name", "three");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().draft()})))).as("German draft", new Object[0])).hasVersion("0.3").hasLanguage("de").hasStringField("name", "drei");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().setVersion("0.1")})))).as("German version 0.1", new Object[0])).hasVersion("0.1").hasLanguage("de").hasStringField("name", "eins");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().setVersion("0.2")})))).as("German version 0.2", new Object[0])).hasVersion("0.2").hasLanguage("de").hasStringField("name", "zwei");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().setVersion("0.3")})))).as("German version 0.3", new Object[0])).hasVersion("0.3").hasLanguage("de").hasStringField("name", "drei");
        }
    }

    @Test
    public void testReadBogusVersion() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("bogus")}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_version", (String[])new String[]{"bogus"});
        }
    }

    @Test
    public void testReadInexistentVersion() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("47.11")}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_version", (String[])new String[]{"47.11"});
        }
    }

    @Test
    public void testReadPublishedVersion() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", uuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_published_not_found_for_uuid_branch_language", (String[])new String[]{uuid, "en", branchUuid});
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)nodeResponse).as("Published node", new Object[0])).hasLanguage("en").hasVersion("2.0");
    }

    @Test
    public void testReadNodeForBranch() {
        HibNode node = this.folder("2015");
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            String uuid = node.getUuid();
            NodeUpdateRequest updateRequest = new NodeUpdateRequest();
            updateRequest.setLanguage("en");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 in new branch"));
            updateRequest.setVersion("0.1");
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName()).draft()})))).as("Initial Branch Version", new Object[0])).hasVersion("1.0").hasStringField("name", "2015");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName()).draft()})))).as("New Branch Version", new Object[0])).hasVersion("1.1").hasStringField("name", "2015 in new branch");
        }
    }

    @Test
    public void testReadNodeVersionForBranch() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        String uuid = (String)this.tx(() -> node.getUuid());
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            NodeUpdateRequest updateRequest = new NodeUpdateRequest();
            updateRequest.setLanguage("en");
            updateRequest.setVersion("1.0");
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 v1.1 new branch"));
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            Assert.assertEquals((Object)"1.1", (Object)response.getVersion());
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 v1.1 initial branch"));
            updateRequest.setVersion("1.0");
            response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            Assert.assertEquals((Object)"1.1", (Object)response.getVersion());
            updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 v1.2 new branch"));
            updateRequest.setVersion("1.1");
            response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, updateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            Assert.assertEquals((Object)"1.2", (Object)response.getVersion());
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName()).setVersion("0.1")})))).as("Initial Branch Version", new Object[0])).hasVersion("0.1").hasStringField("name", "2015");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName()).setVersion("1.1")})))).as("New Branch Version", new Object[0])).hasVersion("1.1").hasStringField("name", "2015 v1.1 new branch");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName()).setVersion("1.1")})))).as("Initial Branch Version", new Object[0])).hasVersion("1.1").hasStringField("name", "2015 v1.1 initial branch");
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName()).setVersion("1.2")})))).as("New Branch Version", new Object[0])).hasVersion("1.2").hasStringField("name", "2015 v1.2 new branch");
        }
    }

    @Test
    public void testReadByUUIDWithLinkPathsAndNoSegmentFieldRef() {
        String nodeUuid = (String)this.tx(tx -> this.folder("news").getUuid());
        String schemaUuid = (String)this.tx(tx -> this.folder("news").getSchemaContainer().getUuid());
        SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, schema.toUpdateRequest().setSegmentField(null), new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/error/404", (Object)response.getPath());
        MeshAssertions.assertThat((Map)response.getLanguagePaths()).containsEntry((Object)"en", (Object)"/api/v2/dummy/webroot/error/404");
        MeshAssertions.assertThat((Map)response.getLanguagePaths()).containsEntry((Object)"de", (Object)"/api/v2/dummy/webroot/error/404");
    }

    @Test
    public void testReadByUUIDWithLinkPaths() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
            MeshAssertions.assertThat(response.getAvailableLanguages().keySet()).containsExactly((Object[])new String[]{"de", "en"});
            MeshAssertions.assertThat((Map)response.getLanguagePaths()).containsEntry((Object)"en", (Object)"/api/v2/dummy/webroot/News");
            MeshAssertions.assertThat((Map)response.getLanguagePaths()).containsEntry((Object)"de", (Object)"/api/v2/dummy/webroot/Neuigkeiten");
        }
    }

    @Test
    public void testReadBreadcrumbWithLangfallback() {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        request.setLanguage("en");
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"english folder-0"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"english folder-0"));
        request.setParentNodeUuid(baseNodeUuid);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        request.setParentNodeUuid(response.getUuid());
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"english folder-1"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"english folder-1"));
        response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        request.setLanguage("de");
        request.setParentNodeUuid(response.getUuid());
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"german folder-2"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"german folder-2"));
        response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        String uuid = response.getUuid();
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL).setLanguages(new String[]{"de"}), new VersioningParametersImpl().setVersion("draft")}));
        List breadcrumb = response.getBreadcrumb();
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0/english%20folder-1/german%20folder-2", (Object)response.getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/", (Object)((NodeReference)breadcrumb.get(0)).getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0", (Object)((NodeReference)breadcrumb.get(1)).getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0/english%20folder-1", (Object)((NodeReference)breadcrumb.get(2)).getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0/english%20folder-1/german%20folder-2", (Object)((NodeReference)breadcrumb.get(3)).getPath());
    }

    @Test
    public void testReadByUUIDBreadcrumb() {
        try (Tx tx = this.tx();){
            HibNode node = this.content("news_2014");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL), new VersioningParametersImpl().draft()}));
            Assert.assertNull((Object)((NodeReference)response.getBreadcrumb().get(0)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(1)).getUuid(), (Object)this.folder("news").getUuid());
            Assert.assertEquals((Object)"News", (Object)((NodeReference)response.getBreadcrumb().get(1)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(2)).getUuid(), (Object)this.folder("2014").getUuid());
            Assert.assertEquals((Object)"2014", (Object)((NodeReference)response.getBreadcrumb().get(2)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(3)).getUuid(), (Object)node.getUuid());
            Assert.assertEquals((Object)"News_2014 english title", (Object)((NodeReference)response.getBreadcrumb().get(3)).getDisplayName());
            Assert.assertEquals((Object)"/api/v2/dummy/webroot/", (Object)((NodeReference)response.getBreadcrumb().get(0)).getPath());
            Assert.assertEquals((Object)"/api/v2/dummy/webroot/News", (Object)((NodeReference)response.getBreadcrumb().get(1)).getPath());
            Assert.assertEquals((Object)"/api/v2/dummy/webroot/News/2014", (Object)((NodeReference)response.getBreadcrumb().get(2)).getPath());
            Assert.assertEquals((Object)"/api/v2/dummy/webroot/News/2014/News_2014.en.html", (Object)((NodeReference)response.getBreadcrumb().get(3)).getPath());
            Assert.assertEquals((String)"Only four items should be listed in the breadcrumb", (long)4L, (long)response.getBreadcrumb().size());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertNull((Object)((NodeReference)response.getBreadcrumb().get(0)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(1)).getUuid(), (Object)this.folder("news").getUuid());
            Assert.assertEquals((Object)"News", (Object)((NodeReference)response.getBreadcrumb().get(1)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(2)).getUuid(), (Object)this.folder("2014").getUuid());
            Assert.assertEquals((Object)"2014", (Object)((NodeReference)response.getBreadcrumb().get(2)).getDisplayName());
            Assert.assertEquals((Object)((NodeReference)response.getBreadcrumb().get(3)).getUuid(), (Object)response.getUuid());
            Assert.assertEquals((Object)"News_2014 english title", (Object)((NodeReference)response.getBreadcrumb().get(3)).getDisplayName());
            response.getBreadcrumb().forEach(element -> Assert.assertNull((String)"No path should be rendered since by default the linkType is OFF", (Object)element.getPath()));
            Assert.assertEquals((String)"Only 4 items should be listed in the breadcrumb", (long)4L, (long)response.getBreadcrumb().size());
        }
    }

    @Test
    public void testReadBaseNode() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            String uuid = node.getUuid();
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)"folder", (Object)response.getSchema().getName());
            MeshAssertions.assertThat(response.getAvailableLanguages().keySet()).containsExactly((Object[])new String[]{"en"});
            Assert.assertEquals((Object)"en", (Object)response.getLanguage());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)"folder", (Object)response.getSchema().getName());
            Assert.assertEquals((Object)"/api/v2/dummy/webroot/", response.getLanguagePaths().get("en"));
        }
    }

    @Test
    public void testReadNodeByUUIDLanguageFallback() {
        String uuid;
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("products");
            uuid = node.getUuid();
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", uuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, "en", new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("products");
            uuid = node.getUuid();
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"dv,nl,de,en"});
            VersioningParameters versionParams = new VersioningParametersImpl().draft();
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{parameters, versionParams}));
            MeshAssertions.assertThat((HibNode)this.folder("products")).matches(restNode);
            StringFieldImpl field = restNode.getFields().getStringField("slug");
            String nameText = field.getString();
            Assert.assertEquals((Object)"Produkte", (Object)nameText);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadNodeByUUIDSingleLanguage() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            String uuid = node.getUuid();
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"de"});
            VersioningParameters versionParams = new VersioningParametersImpl().draft();
            NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{parameters, versionParams}));
            MeshAssertions.assertThat((HibNode)this.folder("products")).matches(restNode);
            StringFieldImpl field = restNode.getFields().getStringField("slug");
            String nameText = field.getString();
            Assert.assertEquals((Object)"Produkte", (Object)nameText);
        }
    }

    @Test
    public void testReadNodeByUUIDNoLanguage() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.project().getUuid());
            HibNode parentNode = (HibNode)nodeDao.findByUuid((HibCoreElement)project, this.folder("products").getUuid());
            HibLanguage languageNl = tx.languageDao().findByLanguageTag("nl");
            HibSchemaVersion version = (HibSchemaVersion)((HibSchema)tx.schemaDao().findByUuid(this.schemaContainer("content").getUuid())).getLatestVersion();
            HibUser user = (HibUser)tx.userDao().findByUuid(this.user().getUuid());
            node = nodeDao.create(parentNode, user, version, project);
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, languageNl.getLanguageTag(), node.getProject().getLatestBranch(), this.user());
            HibSchemaVersion schemaVersion = englishContainer.getSchemaContainerVersion();
            schemaVersion.getSchema().addField((FieldSchema)new StringFieldSchemaImpl().setName("displayName"));
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)schemaVersion);
            englishContainer.createString("teaser").setString("name");
            englishContainer.createString("title").setString("title");
            englishContainer.createString("slug").setString("filename.nl.html");
            englishContainer.createHTML("content").setHtml("nl content");
            roleDao.grantPermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en"});
            VersioningParameters versionParams = new VersioningParametersImpl().draft();
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{parameters, versionParams}));
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)response.getLanguage()).as("Node language", new Object[0])).isNull();
            MeshAssertions.assertThat(response.getAvailableLanguages().keySet()).as("Available languages", new Object[0]).containsOnly((Object[])new String[]{"nl"});
            ((FieldMapAssert)MeshAssertions.assertThat((FieldMap)response.getFields()).as("Node Fields", new Object[0])).isNull();
            Assert.assertNotNull((Object)response.getProject());
            Assert.assertEquals((Object)this.project().getUuid(), (Object)response.getProject().getUuid());
            Assert.assertEquals((Object)this.project().getName(), (Object)response.getProject().getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadNodeWithBogusLanguageCode() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"blabla", "edgsdg"});
            VersioningParameters versionParams = new VersioningParametersImpl().draft();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{parameters, versionParams}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_language_not_found", (String[])new String[]{"blabla"});
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        }
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibNode node = this.folder("2015");
            uuid = node.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadNodeByBogusUUID() throws Exception {
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", "bogusUUID", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogusUUID"});
    }

    @Test
    public void testReadNodeByInvalidUUID() throws Exception {
        String uuid = "dde8ba06bb7211e4897631a9ce2772f5";
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{uuid});
    }

    @Test
    public void testFindOrCreateNode() throws Exception {
        String uuid = "dde8ba06bb7211e4897631a9ce2772f5";
        NodeResponse node = (NodeResponse)this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]).toSingle().compose(MeshRestClientUtil.onErrorCodeResumeNext((int)404, this.createBinaryContent(uuid))).blockingGet();
        MeshAssertions.assertThat((NodeResponse)node).hasUuid(uuid);
    }

    @Override
    @Test
    public void testPermissionResponse() {
        NodeResponse node = (NodeResponse)((NodeListResponse)this.client().findNodes("dummy", new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)node.getPermissions()).hasPublishPermsSet();
    }

    @Override
    @Test
    public void testUpdate() throws GenericRestException, Exception {
        String newSlug = "english renamed name";
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String uuid = (String)this.tx(() -> this.content("concorde").getUuid());
        HibNodeFieldContainer origContainer = (HibNodeFieldContainer)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            GroupDao groupDao = tx.groupDao();
            HibNode prod = this.content("concorde");
            HibNodeFieldContainer container = contentDao.getLatestDraftFieldContainer(prod, this.english());
            Assert.assertEquals((Object)"Concorde_english_name", (Object)container.getString("teaser").getString());
            Assert.assertEquals((Object)"Concorde english title", (Object)container.getString("title").getString());
            UserInfo userInfo = this.data().createUserInfo("dummy", "Dummy Firstname", "Dummy Lastname");
            groupDao.addUser((HibGroup)groupDao.findByUuid(this.groupUuid()), userInfo.getUser());
            return container;
        });
        this.client().logout().blockingGet();
        this.client().setLogin("dummy", "test123");
        this.client().login().blockingGet();
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("en");
        request.setVersion("0.1");
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"english renamed name"));
        this.waitAndClearSearchIdleEvents();
        this.expect(MeshEvent.NODE_UPDATED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasProject("dummy", this.projectUuid()).hasLanguage("en").hasSchema("content", contentSchemaUuid).hasUuid(uuid)).hasBranchUuid(this.initialBranchUuid()));
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, request, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
        this.awaitEvents();
        Assert.assertEquals((Object)"Dummy Firstname", (Object)restNode.getEditor().getFirstName());
        Assert.assertEquals((Object)"Dummy Lastname", (Object)restNode.getEditor().getLastName());
        String projectUuid = (String)this.tx(() -> this.project().getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        String schemaContainerVersionUuid = (String)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            return contentDao.getLatestDraftFieldContainer(this.content("concorde"), this.english()).getSchemaContainerVersion().getUuid();
        });
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)projectUuid, (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)ContainerType.DRAFT, null, null), ContentDao.composeDocumentId((String)uuid, (String)"en"));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        ((NodeResponseAssert)((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)restNode).as("update response", new Object[0])).isNotNull()).hasLanguage("en").hasVersion("1.1").hasStringField("slug", "english renamed name").hasStringField("title", "Concorde english title");
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            Assert.assertEquals((String)"The original container should be 1.0 (the latest published version)", (Object)"1.0", (Object)origContainer.getVersion().toString());
            HibNodeFieldContainer container = contentDao.getLatestDraftFieldContainer(this.content("concorde"), this.english());
            Assert.assertEquals((String)"The loaded container did not match the latest version.", (Object)"1.1", (Object)container.getVersion().toString());
            Assert.assertEquals((String)"The string field was not updated within the new container", (Object)"english renamed name", (Object)container.getString("slug").getString());
            Assert.assertEquals((Object)"Concorde english title", (Object)container.getString("title").getString());
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)container).as("new container", new Object[0])).hasPrevious(origContainer);
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)container).as("new container", new Object[0])).isLast();
            ((NodeGraphFieldContainerAssert)MeshAssertions.assertThat((HibNodeFieldContainer)origContainer).as("orig container", new Object[0])).hasNext(container);
            MeshAssertions.assertThat((HibNodeFieldContainer)origContainer.getPreviousVersion()).isFirst();
            String indexName = ContentDao.composeIndexName((String)this.project().getUuid(), (String)this.project().getLatestBranch().getUuid(), (String)origContainer.getSchemaContainerVersion().getUuid(), (ContainerType)ContainerType.DRAFT, null, null);
            String documentId = ContentDao.composeDocumentId((String)uuid, (String)"en");
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(indexName, documentId);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(1);
        }
    }

    @Test
    public void testUpdateCreateLanguage() {
        String germanName = "Zweitausendf\u00fcnfzehn";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("de");
        request.setVersion("0.1");
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"Zweitausendf\u00fcnfzehn"));
        String projectUuid = (String)this.tx(() -> this.project().getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        String schemaContainerVersionUuid = (String)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            return contentDao.getLatestDraftFieldContainer(this.folder("2015"), this.english()).getSchemaContainerVersion().getUuid();
        });
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        this.searchProvider().clear().blockingAwait();
        this.expect(MeshEvent.NODE_CONTENT_CREATED).match(1, NodeMeshEventModel.class, event -> {
            Assert.assertEquals((Object)branchUuid, (Object)event.getBranchUuid());
            Assert.assertEquals((Object)uuid, (Object)event.getUuid());
            Assert.assertEquals((Object)"de", (Object)event.getLanguageTag());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
        });
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, request, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"})}));
        this.awaitEvents();
        Assert.assertEquals((Object)"de", (Object)restNode.getLanguage());
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)projectUuid, (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)ContainerType.DRAFT, null, null), ContentDao.composeDocumentId((String)uuid, (String)"de"));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        HibNode node = this.folder("2015");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String uuid = node.getUuid();
            NodeUpdateRequest request = new NodeUpdateRequest();
            request.setLanguage("en");
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            NodeUpdateRequest request = new NodeUpdateRequest();
            request.setLanguage("en");
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"en", "de"});
            ClientHelper.call(() -> this.client().updateNode("dummy", "bogus", request, new ParameterProvider[]{parameters}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
        }
    }

    @Test
    public void testCreateNodeWithExtraField() throws UnknownHostException, InterruptedException {
        try (Tx tx = this.tx();){
            HibNode parentNode = this.folder("news");
            String uuid = parentNode.getUuid();
            Assert.assertNotNull((Object)parentNode);
            Assert.assertNotNull((Object)parentNode.getUuid());
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            request.setLanguage("en");
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            request.getFields().put("extrafield", (Field)FieldUtil.createStringField((String)"some extra field value"));
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(uuid);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_unhandled_fields", (String[])new String[]{"content", "[extrafield]"});
        }
    }

    @Test
    public void testCreateNodeWithMissingRequiredField() {
        try (Tx tx = this.tx();){
            HibNode parentNode = this.folder("news");
            String uuid = parentNode.getUuid();
            Assert.assertNotNull((Object)parentNode);
            Assert.assertNotNull((Object)parentNode.getUuid());
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            request.setLanguage("en");
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(uuid);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_missing_required_field_value", (String[])new String[]{"slug", "content"});
        }
    }

    @Test
    public void testCreateNodeWithMissingField() throws UnknownHostException, InterruptedException {
        try (Tx tx = this.tx();){
            HibNode parentNode = this.folder("news");
            String uuid = parentNode.getUuid();
            Assert.assertNotNull((Object)parentNode);
            Assert.assertNotNull((Object)parentNode.getUuid());
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(this.schemaContainer("content").getUuid()));
            request.setLanguage("en");
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setParentNodeUuid(uuid);
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
            Assert.assertNotNull((Object)response);
        }
    }

    @Test
    public void testUpdateNodeWithExtraField2() throws GenericRestException, Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            NodeUpdateRequest request = new NodeUpdateRequest();
            request.setLanguage("en");
            request.setVersion("0.1");
            String newName = "english renamed name";
            String newDisplayName = "display name changed";
            request.getFields().put("name", (Field)FieldUtil.createStringField((String)"english renamed name"));
            request.getFields().put("someField", (Field)FieldUtil.createStringField((String)"display name changed"));
            NodeParametersImpl parameters = new NodeParametersImpl();
            parameters.setLanguages(new String[]{"de", "en"});
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, request, new ParameterProvider[]{parameters}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_unhandled_fields", (String[])new String[]{"folder", "[someField]"});
            HibNodeFieldContainer englishContainer = contentDao.getLatestDraftFieldContainer(this.folder("2015"), this.english());
            Assert.assertNotEquals((String)"The name should not have been changed.", (Object)"english renamed name", (Object)englishContainer.getString("name").getString());
        }
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        HibNode node = this.content("concorde");
        String uuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        Assert.assertTrue((String)"The node is expected to be published", (boolean)((Boolean)this.tx(tx -> tx.contentDao().isPublished(tx.contentDao().getFieldContainer(node, "en")))));
        this.expect(MeshEvent.NODE_DELETED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).uuidNotNull()).hasSchemaName("content").hasSchemaUuid(schemaUuid));
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            MeshAssert.assertElement((RootDao)tx2.nodeDao(), (HibCoreElement)this.project(), (String)uuid, (boolean)false);
            int deletes = 4;
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, (long)deletes, 0L, 0L);
        }
    }

    @Test
    public void testPublishUnPublishUpdateVersionConsistency() {
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.en.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        String uuid = response.getUuid();
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("de");
        nodeUpdateRequest.setVersion("0.1");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"old-page.de.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        nodeUpdateRequest.setVersion("0.1");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"old-page.de2.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        nodeUpdateRequest.setVersion("0.2");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"old-page.de3.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, "de", new ParameterProvider[0]));
        nodeUpdateRequest.setLanguage("de");
        nodeUpdateRequest.setVersion(null);
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.de1.html"));
        response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        nodeUpdateRequest.setVersion("0.1");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.de2.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        nodeUpdateRequest.setVersion("0.2");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.de3.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
    }

    @Test
    public void testCreateInBranchWithoutParent() throws Exception {
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibNode node = this.content("concorde");
            NodeCreateRequest parentRequest = new NodeCreateRequest();
            parentRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            parentRequest.setLanguage("en");
            parentRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
            parentRequest.setParentNodeUuid(node.getUuid());
            NodeResponse parentNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", parentRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            NodeCreateRequest sameBranchChildRequest = new NodeCreateRequest();
            sameBranchChildRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            sameBranchChildRequest.setLanguage("en");
            sameBranchChildRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
            sameBranchChildRequest.setParentNodeUuid(parentNode.getUuid());
            ClientHelper.call(() -> this.client().createNode("dummy", sameBranchChildRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            NodeCreateRequest childRequest = new NodeCreateRequest();
            childRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            childRequest.setLanguage("en");
            childRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
            childRequest.setParentNodeUuid(parentNode.getUuid());
            ClientHelper.call(() -> this.client().createNode("dummy", childRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranch.getName())}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{parentNode.getUuid()});
            tx.success();
        }
    }

    @Test
    public void testCreateInBranchSameUUIDWithoutParent() throws Exception {
        String initialBranch = null;
        String newBranch = "newbranch";
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().createBranch("dummy", new BranchCreateRequest().setName(newBranch), new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            initialBranch = project.getInitialBranch().getName();
            Assert.assertNotNull((Object)tx.branchDao().findByName((HibCoreElement)project, newBranch));
        }
        String nodeUuid = (String)this.tx(() -> this.content("concorde").getUuid());
        NodeCreateRequest parentRequest = new NodeCreateRequest();
        parentRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        parentRequest.setLanguage("en");
        parentRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
        parentRequest.setParentNodeUuid(nodeUuid);
        NodeResponse parentNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", parentRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch)}));
        NodeCreateRequest sameBranchChildRequest = new NodeCreateRequest();
        sameBranchChildRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        sameBranchChildRequest.setLanguage("en");
        sameBranchChildRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
        sameBranchChildRequest.setParentNodeUuid(parentNode.getUuid());
        NodeResponse sameBranchChildResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", sameBranchChildRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch)}));
        NodeCreateRequest childRequest = new NodeCreateRequest();
        childRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        childRequest.setLanguage("en");
        childRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some slug"));
        childRequest.setParentNodeUuid(parentNode.getUuid());
        String branch = initialBranch;
        ClientHelper.call(() -> this.client().createNode(sameBranchChildResponse.getUuid(), "dummy", childRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch)}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{parentNode.getUuid()});
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibNode node = this.folder("2015");
            uuid = node.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.DELETE_PERM.getRestPerm().getName()});
        tx = this.tx();
        try {
            Assert.assertNotNull((Object)tx.nodeDao().findByUuid((HibCoreElement)this.project(), uuid));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testConflictByUpdateAdditionalLanguage() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String nodeUuid = node.getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("de");
            update.getFields().put("slug", (Field)FieldUtil.createStringField((String)"2015"));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"slug", "2015"});
        }
    }

    @Test
    public void testRootNodeBreadcrumb() {
        MeshWebrootResponse node = (MeshWebrootResponse)this.client().webroot("dummy", "/", new ParameterProvider[0]).toSingle().blockingGet();
        List breadcrumb = node.getNodeResponse().getBreadcrumb();
        Assert.assertEquals((long)1L, (long)breadcrumb.size());
        Assert.assertEquals((Object)node.getNodeResponse().getUuid(), (Object)((NodeReference)breadcrumb.get(0)).getUuid());
    }

    @Test
    public void testCreateAndDoNotPublishNode() {
        NodeResponse created = this.create(false, new String[0]);
        MeshAssertions.assertThat((NodeResponse)created).hasVersion("0.1").hasLanguageVariant("en", false);
    }

    @Test
    public void testCreateAndPublishNode() {
        NodeResponse created = this.create(true, new String[0]);
        MeshAssertions.assertThat((NodeResponse)created).hasVersion("1.0").hasLanguageVariant("en", true);
    }

    @Test
    public void testUpsertAndDoNotPublishNode() {
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", false, new String[0]);
        NodeResponse updated = this.upsert(uuid, "Updated", false, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("0.2").hasLanguageVariant("en", false);
    }

    @Test
    public void testUpsertAndPublishNode() {
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", true, new String[0]);
        NodeResponse updated = this.upsert(uuid, "Updated", true, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("2.0").hasLanguageVariant("en", true);
    }

    @Test
    public void testEmptyUpsertAndPublishNode() {
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", false, new String[0]);
        NodeResponse updated = this.upsert(uuid, null, true, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("1.0").hasLanguageVariant("en", true);
    }

    @Test
    public void testUpdateAndNoNotPublishNode() {
        NodeResponse created = this.create(false, new String[0]);
        NodeResponse updated = this.update(created, "some new title", false, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("0.2").hasLanguageVariant("en", false);
    }

    @Test
    public void testUpdateAndPublishNode() {
        NodeResponse created = this.create(false, new String[0]);
        NodeResponse updated = this.update(created, "some new title", true, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("1.0").hasLanguageVariant("en", true);
    }

    @Test
    public void testEmptyUpdateAndPublishNode() {
        NodeResponse created = this.create(false, new String[0]);
        NodeResponse updated = this.update(created, null, true, new String[0]);
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("1.0").hasLanguageVariant("en", true);
    }

    @Test
    public void testCreateNodeAndDoNotSetRolePermissions() {
        NodeResponse created = this.create(false, new String[0]);
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", created.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testCreateNodeAndSetRolePermissions() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        NodeResponse created = this.create(false, anonymous.getName());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", created.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{anonymous});
    }

    @Test
    public void testUpsertNodeAndDoNotSetRolePermissions() {
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", false, new String[0]);
        NodeResponse updated = this.upsert(uuid, "Updated", false, new String[0]);
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", updated.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testUpsertNodeAndSetRolePermissions() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", false, new String[0]);
        NodeResponse updated = this.upsert(uuid, "Updated", false, anonymous.getName());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", updated.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{anonymous});
    }

    @Test
    public void testEmptyUpsertNodeAndSetRolePermissions() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        String uuid = UUIDUtil.randomUUID();
        this.upsert(uuid, "Created", false, new String[0]);
        NodeResponse updated = this.upsert(uuid, null, false, anonymous.getName());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", updated.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{anonymous});
    }

    @Test
    public void testUpdateNodeAndDoNotSetRolePermissions() {
        RoleReference testRole = (RoleReference)this.tx(() -> (RoleReference)this.role().transformToReference());
        NodeResponse created = this.create(false, new String[0]);
        this.update(created, "some new title", false, new String[0]);
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", created.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{testRole});
    }

    @Test
    public void testUpdateNodeAndSetRolePermissions() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        NodeResponse created = this.create(false, new String[0]);
        this.update(created, "some new title", false, anonymous.getName());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", created.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{anonymous});
    }

    @Test
    public void testEmptyUpdateNodeAndSetRolePermissions() {
        RoleReference anonymous = (RoleReference)this.tx(() -> (RoleReference)this.roles().get("anonymous").transformToReference());
        NodeResponse created = this.create(false, new String[0]);
        this.update(created, null, false, anonymous.getName());
        ObjectPermissionResponse rolePermissions = (ObjectPermissionResponse)ClientHelper.call(() -> this.client().getNodeRolePermissions("dummy", created.getUuid()));
        MeshAssertions.assertThat((List)rolePermissions.getReadPublished()).as("roles with permission", new Object[0]).containsOnly((Object[])new RoleReference[]{anonymous});
    }

    protected NodeResponse create(boolean publish, String ... roles) {
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        if (publish) {
            request.setPublish(true);
        }
        if (roles.length > 0) {
            request.setGrant(new ObjectPermissionGrantRequest().setReadPublished(Stream.of(roles).map(name -> (RoleReference)new RoleReference().setName(name)).collect(Collectors.toList())).setExclusive(true));
        }
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
    }

    protected NodeResponse upsert(String uuid, String title, boolean publish, String ... roles) {
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeUpsertRequest request = new NodeUpsertRequest();
        request.setSchemaName("content");
        request.setLanguage("en");
        if (title != null) {
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)title));
        }
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        if (publish) {
            request.setPublish(true);
        }
        if (roles.length > 0) {
            request.setGrant(new ObjectPermissionGrantRequest().setReadPublished(Stream.of(roles).map(name -> (RoleReference)new RoleReference().setName(name)).collect(Collectors.toList())).setExclusive(true));
        }
        return (NodeResponse)ClientHelper.call(() -> this.client().upsertNode("dummy", uuid, request, new ParameterProvider[0]));
    }

    protected NodeResponse update(NodeResponse node, String title, boolean publish, String ... roles) {
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage(node.getLanguage());
        request.setVersion("draft");
        if (title != null) {
            request.getFields().put("title", (Field)FieldUtil.createStringField((String)title));
        }
        if (publish) {
            request.setPublish(true);
        }
        if (roles.length > 0) {
            request.setGrant(new ObjectPermissionGrantRequest().setReadPublished(Stream.of(roles).map(name -> (RoleReference)new RoleReference().setName(name)).collect(Collectors.toList())).setExclusive(true));
        }
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
    }
}

