/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.image.CacheFileInfo;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.etc.config.ImageManipulatorOptions;
import com.gentics.mesh.parameter.ImageManipulationParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.image.CropMode;
import com.gentics.mesh.parameter.image.ResizeMode;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.assertj.MeshCoreAssertion;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.MeshAssert;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeImageResizeEndpointTest
extends AbstractMeshTest {
    @Test
    public void testImageResize() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        this.uploadImage(node, "en", "image");
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100)).setHeight(Integer.valueOf(102));
        MeshBinaryResponse download = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[]{params}));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            this.validateResizeImage(download, contentDao.getLatestDraftFieldContainer(node, this.english()).getBinary("image"), params, 100, 102);
        }
    }

    @Test
    public void testImageResizeOverLimit() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        this.uploadImage(node, "en", "image");
        ImageManipulatorOptions options = this.options().getImageOptions();
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(options.getMaxWidth() + 1)).setHeight(Integer.valueOf(102));
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "image", new ParameterProvider[]{params}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"image_error_width_limit_exceeded", (String[])new String[]{String.valueOf(options.getMaxWidth()), String.valueOf(options.getMaxWidth() + 1)});
    }

    @Test
    public void testImageExactLimit() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        this.uploadImage(node, "en", "image");
        ImageManipulatorOptions options = this.options().getImageOptions();
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(options.getMaxWidth()).setHeight(Integer.valueOf(102));
        MeshBinaryResponse download = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "image", new ParameterProvider[]{params}));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            Assert.assertNotNull((Object)contentDao.getLatestDraftFieldContainer(node, this.english()));
            this.validateResizeImage(download, contentDao.getLatestDraftFieldContainer(node, this.english()).getBinary("image"), params, 2048, 102);
        }
    }

    @Test
    public void testTransformImage() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", version, "image", params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, params, 100, 118);
    }

    @Test
    public void testTransformWithFocalPoint() throws IOException {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100)).setFocalPoint(0.3f, 0.4f);
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", version, "image", params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        NodeResponse response3 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), nodeUuid, new ParameterProvider[0]));
        Assert.assertEquals((String)"Focalpoint X did not match.", (float)0.3f, (float)response3.getFields().getBinaryField("image").getFocalPoint().getX(), (float)0.0f);
        Assert.assertEquals((String)"Focalpoint Y did not match.", (float)0.4f, (float)response3.getFields().getBinaryField("image").getFocalPoint().getY(), (float)0.0f);
    }

    @Test
    public void testTransformWithOnlyFocalPoint() throws IOException {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setFocalPoint(0.3f, 0.4f);
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", version, "image", params));
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        NodeResponse response3 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), nodeUuid, new ParameterProvider[0]));
        Assert.assertEquals((String)"Focalpoint X did not match.", (float)0.3f, (float)response3.getFields().getBinaryField("image").getFocalPoint().getX(), (float)0.0f);
        Assert.assertEquals((String)"Focalpoint Y did not match.", (float)0.4f, (float)response3.getFields().getBinaryField("image").getFocalPoint().getY(), (float)0.0f);
    }

    @Test
    public void testTransformImageCrop() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth(Integer.valueOf(100));
        params.setHeight(Integer.valueOf(200));
        params.setRect(0, 0, 200, 200);
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageCrop$16(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 100, 200);
    }

    @Test
    public void testTransformImageResizeSmart() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth(Integer.valueOf(200));
        params.setHeight(Integer.valueOf(500));
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageResizeSmart$19(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have been resized", (long)200L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 200, 500);
    }

    @Test
    public void testTransformImageResizeSmartWidthAuto() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth("auto");
        params.setHeight(Integer.valueOf(200));
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageResizeSmartWidthAuto$22(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have been resized", (long)200L, (long)transformResponse.getFields().getBinaryField("image").getHeight().intValue());
        Assert.assertEquals((String)"The image should use the original width of 1160", (long)1160L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 1160, 200);
    }

    @Test
    public void testTransformImageResizeSmartHeightAuto() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth(Integer.valueOf(200));
        params.setHeight("auto");
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageResizeSmartHeightAuto$25(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have benn in the original Height of 1376", (long)1376L, (long)transformResponse.getFields().getBinaryField("image").getHeight().intValue());
        Assert.assertEquals((String)"The image should have been resized", (long)200L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 200, 1376);
    }

    @Test
    public void testTransformImageResizeSmartHeightWidthAuto() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth("auto");
        params.setHeight("auto");
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageResizeSmartHeightWidthAuto$28(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have been in the original width of 1160px", (long)1160L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        Assert.assertEquals((String)"The image should have been in the original height of  1376px", (long)1376L, (long)transformResponse.getFields().getBinaryField("image").getHeight().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 1160, 1376);
    }

    @Test
    public void testTransformImageResizeForce() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        params.setWidth(Integer.valueOf(100));
        params.setHeight(Integer.valueOf(500));
        params.setResizeMode(ResizeMode.FORCE);
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.lambda$testTransformImageResizeForce$31(uuid, version, (ImageManipulationParameters)params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        this.validateResizeImage(result, null, (ImageManipulationParameters)params, 100, 500);
    }

    @Test
    public void testTransformImageNoParameters() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        NodeResponse response = this.uploadImage(node, "en", "image");
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", response.getVersion(), "image", (ImageManipulationParameters)params));
        MeshCoreAssertion.assertThat(testContext).hasUploads(2L, 2L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testTransformNonBinary() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", uuid, "en", "draft", "name", params), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_found_field_is_not_binary", (String[])new String[]{"name"});
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testTransformNonImage() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "*/*", "image");
            tx.success();
        }
        Buffer buffer = Buffer.buffer((String)"I am not an image");
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", nodeUuid, "en", "draft", "image", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.txt", "text/plain", new ParameterProvider[0]));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", nodeUuid, "en", response.getVersion(), "image", params), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_transformation_non_image", (String[])new String[]{"image"});
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testResizeWithFocalPoint() throws IOException {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        NodeResponse response = this.uploadImage(node, "en", "image");
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        BinaryField imageField = response.getFields().getBinaryField("image");
        imageField.setFocalPoint(0.1f, 0.2f);
        updateRequest.setLanguage("en");
        updateRequest.setVersion(response.getVersion());
        updateRequest.getFields().put("image", (Field)imageField);
        NodeResponse response2 = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", response.getUuid(), updateRequest, new ParameterProvider[0]));
        Assert.assertEquals((float)0.1f, (float)response2.getFields().getBinaryField("image").getFocalPoint().getX(), (float)0.0f);
        Assert.assertEquals((float)0.2f, (float)response2.getFields().getBinaryField("image").getFocalPoint().getY(), (float)0.0f);
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(600)).setHeight(Integer.valueOf(102));
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "image", new ParameterProvider[]{params}));
    }

    @Test
    public void testFocalPointZoomWithTooLargeTarget() throws IOException {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        this.uploadImage(node, "en", "image");
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(2048)).setHeight(Integer.valueOf(2048));
        params.setFocalPoint(0.5f, 0.5f);
        params.setFocalPointZoom(Float.valueOf(1.5f));
        params.setCropMode(CropMode.FOCALPOINT);
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeUuid, "en", "image", new ParameterProvider[]{params}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"image_error_target_too_large_for_zoom", (String[])new String[0]);
    }

    @Test
    public void testResizeWithFocalPointOutOfBounds() throws IOException {
        HibNode node = this.folder("news");
        NodeResponse response = this.uploadImage(node, "en", "image");
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        BinaryField imageField = response.getFields().getBinaryField("image");
        imageField.setFocalPoint(2.5f, 2.21f);
        updateRequest.setLanguage("en");
        updateRequest.setVersion(response.getVersion());
        updateRequest.getFields().put("image", (Field)imageField);
        ClientHelper.call(() -> this.client().updateNode("dummy", response.getUuid(), updateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"field_binary_error_image_focalpoint_out_of_bounds", (String[])new String[]{"image", "2.5-2.21", "1376:1160"});
        imageField.setFocalPoint(1.0f, 1.0f);
        ClientHelper.call(() -> this.client().updateNode("dummy", response.getUuid(), updateRequest, new ParameterProvider[0]));
    }

    @Test
    public void testTransformEmptyField() throws Exception {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "image/.*", "image");
            tx.success();
        }
        ImageManipulationParametersImpl params = new ImageManipulationParametersImpl();
        ClientHelper.call(() -> this.lambda$testTransformEmptyField$48(nodeUuid, (ImageManipulationParameters)params), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_binaryfield_not_found_with_name", (String[])new String[]{"image"});
    }

    @Test
    public void testTransformImageFilename() throws Exception {
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        String version = this.uploadImage(node, "en", "image").getVersion();
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("image").getWidth().intValue());
        String newNumber = transformResponse.getVersion();
        Assert.assertNotEquals((String)"The version number should have changed.", (Object)version, (Object)newNumber);
        MeshBinaryResponse result = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "image", new ParameterProvider[0]));
        Assert.assertEquals((Object)"blume.jpg", (Object)result.getFilename());
    }

    @Test
    public void testWebrootAfterTransform() throws IOException {
        NodeResponse imageNode = (NodeResponse)this.createBinaryContent().blockingGet();
        NodeResponse image = this.uploadImage(imageNode, "en", "binary");
        String version = image.getVersion();
        String uuid = image.getUuid();
        String path = "/blume.jpg";
        this.client().webroot("dummy", path, new ParameterProvider[0]).blockingAwait();
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100));
        NodeResponse transformResponse = (NodeResponse)ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", uuid, "en", version, "binary", params));
        Assert.assertEquals((String)"The image should have been resized", (long)100L, (long)transformResponse.getFields().getBinaryField("binary").getWidth().intValue());
        this.client().webroot("dummy", path, new ParameterProvider[0]).blockingAwait();
    }

    private void validateResizeImage(MeshBinaryResponse download, HibBinaryField binaryField, ImageManipulationParameters params, int expectedWidth, int expectedHeight) throws Exception {
        File targetFile = new File("target", UUID.randomUUID() + "_resized.jpg");
        CountDownLatch latch = new CountDownLatch(1);
        byte[] bytes = IOUtils.toByteArray((InputStream)download.getStream());
        download.close();
        this.vertx().fileSystem().writeFile(targetFile.getAbsolutePath(), Buffer.buffer((byte[])bytes), rh -> {
            Assert.assertTrue((boolean)rh.succeeded());
            latch.countDown();
        });
        MeshAssert.failingLatch((CountDownLatch)latch);
        Assertions.assertThat((File)targetFile).exists();
        BufferedImage img = ImageIO.read(targetFile);
        Assert.assertEquals((long)expectedWidth, (long)img.getWidth());
        Assert.assertEquals((long)expectedHeight, (long)img.getHeight());
        if (binaryField != null) {
            CacheFileInfo cacheFile = (CacheFileInfo)this.meshDagger().imageManipulator().getCacheFilePath(binaryField.getBinary().getSHA512Sum(), params).blockingGet();
            Assert.assertTrue((String)("The cache file could not be found in the cache directory. {" + cacheFile.path + "}"), (boolean)cacheFile.exists);
        }
    }

    private /* synthetic */ MeshRequest lambda$testTransformEmptyField$48(String nodeUuid, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", nodeUuid, "en", "draft", "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageResizeForce$31(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageResizeSmartHeightWidthAuto$28(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageResizeSmartHeightAuto$25(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageResizeSmartWidthAuto$22(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageResizeSmart$19(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }

    private /* synthetic */ MeshRequest lambda$testTransformImageCrop$16(String uuid, String version, ImageManipulationParameters params) throws Exception {
        return this.client().transformNodeBinaryField("dummy", uuid, "en", version, "image", params);
    }
}

