/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeLanguagesEndpointTest
extends AbstractMeshTest {
    @Test
    public void testDeleteLanguage() {
        int nLanguagesBefore;
        HibNode node = this.content();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            nLanguagesBefore = nodeDao.getAvailableLanguageNames(node).size();
            MeshAssertions.assertThat((List)nodeDao.getAvailableLanguageNames(node)).contains((Object[])new String[]{"en", "de"});
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "en", new ParameterProvider[0]));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        MeshAssertions.assertThat(response.getAvailableLanguages().keySet()).contains((Object[])new String[]{"de"});
        MeshAssertions.assertThat((FieldMap)response.getFields()).isNull();
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"})}));
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_no_language_found", (String[])new String[]{"en"});
        this.waitForSearchIdleEvent();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedDeleteEvents(2);
            Assert.assertFalse((boolean)nodeDao.getAvailableLanguageNames(node).contains("en"));
            Assert.assertEquals((long)(nLanguagesBefore - 1), (long)nodeDao.getAvailableLanguageNames(node).size());
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "de", new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedDeleteEvents(4);
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{this.contentUuid()});
    }

    @Test
    public void testDeleteBogusLanguage() {
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "blub", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_language_not_found", (String[])new String[]{"blub"});
    }

    @Test
    public void testDeleteLanguageNoPerm() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.content(), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", this.contentUuid(), "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.contentUuid(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
    }
}

