/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.node.NodeMovedEventModel;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeMoveEndpointTest
extends AbstractMeshTest {
    @Test
    public void testMoveNodeIntoNonFolderNode() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String branchUuid = this.project().getLatestBranch().getUuid();
            HibNode sourceNode = this.folder("news");
            HibNode targetNode = this.content("concorde");
            String oldParentUuid = nodeDao.getParentNode(sourceNode, branchUuid).getUuid();
            Assert.assertNotEquals((Object)targetNode.getUuid(), (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
            ClientHelper.call(() -> this.client().moveNode("dummy", sourceNode.getUuid(), targetNode.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_move_error_targetnode_is_no_folder", (String[])new String[0]);
            Assert.assertEquals((String)"The node should not have been moved but it was.", (Object)oldParentUuid, (Object)nodeDao.getParentNode(this.folder("news"), branchUuid).getUuid());
        }
    }

    @Test
    public void testMoveNodesSame() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String branchUuid = this.project().getLatestBranch().getUuid();
            HibNode sourceNode = this.folder("news");
            String oldParentUuid = nodeDao.getParentNode(sourceNode, branchUuid).getUuid();
            Assert.assertNotEquals((Object)sourceNode.getUuid(), (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
            ClientHelper.call(() -> this.client().moveNode("dummy", sourceNode.getUuid(), sourceNode.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_move_error_same_nodes", (String[])new String[0]);
            Assert.assertEquals((String)"The node should not have been moved but it was.", (Object)oldParentUuid, (Object)nodeDao.getParentNode(this.folder("news"), branchUuid).getUuid());
        }
    }

    @Test
    public void testMoveNodeIntoChildNode() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String branchUuid = this.project().getLatestBranch().getUuid();
            HibNode sourceNode = this.folder("news");
            HibNode targetNode = this.folder("2015");
            String oldParentUuid = nodeDao.getParentNode(sourceNode, branchUuid).getUuid();
            Assert.assertNotEquals((Object)targetNode.getUuid(), (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
            ClientHelper.call(() -> this.client().moveNode("dummy", sourceNode.getUuid(), targetNode.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_move_error_not_allowed_to_move_node_into_one_of_its_children", (String[])new String[0]);
            Assert.assertEquals((String)"The node should not have been moved but it was.", (Object)oldParentUuid, (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
        }
    }

    @Test
    public void testMoveNodeWithoutPerm() {
        NodeDao nodeDao;
        HibNode sourceNode = this.folder("deals");
        HibNode targetNode = this.folder("2015");
        try (Tx tx = this.tx();){
            nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            Assert.assertNotEquals((Object)targetNode.getUuid(), (Object)nodeDao.getParentNode(sourceNode, this.initialBranchUuid()).getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            nodeDao = tx.nodeDao();
            ClientHelper.call(() -> this.client().moveNode("dummy", sourceNode.getUuid(), targetNode.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{sourceNode.getUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertNotEquals((String)"The source node should not have been moved.", (Object)targetNode.getUuid(), (Object)nodeDao.getParentNode(this.folder("deals"), this.initialBranchUuid()).getUuid());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testMoveNodeWithPerm() {
        HibNode sourceNode = this.folder("deals");
        HibNode targetNode = this.folder("2015");
        String branchUuid = this.initialBranchUuid();
        String sourceNodeUuid = (String)this.tx(() -> sourceNode.getUuid());
        String targetNodeUuid = (String)this.tx(() -> targetNode.getUuid());
        String oldSourceParentId = (String)this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            return nodeDao.getParentNode(sourceNode, branchUuid).getUuid();
        });
        Assert.assertNotEquals((Object)targetNodeUuid, this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            return nodeDao.getParentNode(sourceNode, branchUuid).getUuid();
        }));
        this.expect(MeshEvent.NODE_MOVED).match(1, NodeMovedEventModel.class, event -> {
            Assert.assertEquals((Object)sourceNodeUuid, (Object)event.getUuid());
            NodeReference target = event.getTarget();
            Assert.assertNotNull((Object)target);
            Assert.assertEquals((Object)targetNodeUuid, (Object)target.getUuid());
        });
        ClientHelper.call(() -> this.client().moveNode("dummy", sourceNodeUuid, targetNodeUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            NodeDao nodeDao = tx2.nodeDao();
            Assert.assertNotEquals((String)"The source node parent uuid should have been updated.", (Object)oldSourceParentId, (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
            Assert.assertEquals((String)"The source node should have been moved and the target uuid should match the parent node uuid of the source node.", (Object)targetNode.getUuid(), (Object)nodeDao.getParentNode(sourceNode, branchUuid).getUuid());
            Assert.assertEquals((String)"A store event for each language variation per version should occure", (long)4L, (long)this.trackingSearchProvider().getStoreEvents().size());
        }
    }

    @Test
    public void testMoveNodeWithNoSegmentFieldDefined() {
        try (Tx tx = this.tx();){
            SchemaCreateRequest createRequest = new SchemaCreateRequest();
            createRequest.setName("test");
            createRequest.setDescription("Some test schema");
            createRequest.setDisplayField("stringField");
            createRequest.getFields().add(FieldUtil.createStringFieldSchema((String)"stringField"));
            createRequest.validate();
            SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(createRequest, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
            String branchUuid = this.project().getLatestBranch().getUuid();
            SchemaReferenceImpl reference = new SchemaReferenceImpl();
            reference.setName("test");
            reference.setVersion("1.0");
            ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", branchUuid, new SchemaReference[]{reference}));
            NodeCreateRequest request = new NodeCreateRequest();
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("test"));
            request.getFields().put("stringField", (Field)FieldUtil.createStringField((String)"blar"));
            request.setParentNodeUuid(this.folder("2015").getUuid());
            request.setLanguage("en");
            NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
            Assert.assertEquals((String)"The node has no segmentfield value and thus a 404 path should be returned.", (Object)"/api/v2/dummy/webroot/error/404", (Object)nodeResponse.getPath());
            Assert.assertEquals((String)"The node has no segmentfield value and thus a 404 path should be returned.", (Object)"/api/v2/dummy/webroot/error/404", nodeResponse.getLanguagePaths().get("en"));
            ClientHelper.call(() -> this.client().moveNode("dummy", nodeResponse.getUuid(), this.folder("2014").getUuid(), new ParameterProvider[0]));
        }
    }

    @Test
    public void testMoveInBranch() {
        HibBranch newBranch;
        String oldParentUuid;
        HibNode movedNode = this.folder("deals");
        HibNode targetNode = this.folder("2015");
        try (Tx tx = this.tx();){
            oldParentUuid = ((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", movedNode.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}))).getParentNode().getUuid();
            newBranch = this.createBranch("newbranch");
            tx.success();
        }
        this.mesh().branchCache().clear();
        tx = this.tx();
        try {
            NodeResponse migrated = this.migrateNode("dummy", movedNode.getUuid(), this.initialBranch().getName(), newBranch.getName());
            ((AbstractObjectAssert)Assertions.assertThat((Object)migrated.getParentNode()).as("Migrated node parent", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)migrated.getParentNode().getUuid()).as("Migrated node parent", new Object[0])).isEqualTo((Object)oldParentUuid);
            ClientHelper.call(() -> this.client().moveNode("dummy", movedNode.getUuid(), targetNode.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", movedNode.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}))).getParentNode().getUuid()).as("Parent Uuid in new branch", new Object[0])).isEqualTo((Object)oldParentUuid);
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", movedNode.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName()).draft()}))).getParentNode().getUuid()).as("Parent Uuid in initial branch", new Object[0])).isEqualTo((Object)targetNode.getUuid());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void moveToOtherLanguage() {
        NodeReference rootNode = this.getRootNode();
        NodeResponse deFolder = this.createFolder(rootNode, "de", "deFolder");
        this.publishNode(deFolder);
        NodeResponse enFolder = this.createFolder(rootNode, "en", "enFolder");
        this.publishNode(enFolder);
        this.moveFolder(enFolder, deFolder);
    }

    private NodeReference getRootNode() {
        return (NodeReference)this.client().findProjectByName("dummy", new ParameterProvider[0]).toSingle().map(ProjectResponse::getRootNode).blockingGet();
    }

    private NodeResponse createFolder(NodeReference parentNode, String language, String name) {
        FieldMapImpl fields = new FieldMapImpl();
        NodeCreateRequest request = new NodeCreateRequest().setParentNode(parentNode).setSchemaName("folder").setLanguage(language).setFields((FieldMap)fields);
        fields.put("name", (Field)new StringFieldImpl().setString(name));
        fields.put("slug", (Field)new StringFieldImpl().setString(name));
        return (NodeResponse)this.client().createNode("dummy", request, new ParameterProvider[0]).toSingle().blockingGet();
    }

    private void moveFolder(NodeResponse from, NodeResponse to) {
        this.client().moveNode("dummy", from.getUuid(), to.getUuid(), new ParameterProvider[0]).toCompletable().blockingAwait();
    }
}

