/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.navigation.NavigationElement;
import com.gentics.mesh.core.rest.navigation.NavigationResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.NavigationParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeNavigationEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadChildrenDepthZero() {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(0)), new VersioningParametersImpl().draft()}));
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(0).isValid(1);
        }
    }

    @Test
    public void testReadNodeWithNoChildren() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(42)), new VersioningParametersImpl().draft()}));
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(0).isValid(1);
        }
    }

    @Test
    public void testReadNavigationWithNoParameters() {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(3).isValid(7);
        }
    }

    @Test
    public void testReadNavigationWithNegativeDepth() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ClientHelper.call(() -> this.client().loadNavigation("dummy", node.getUuid(), new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(-10)), new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"navigation_error_invalid_max_depth", (String[])new String[0]);
        }
    }

    @Test
    public void testReadNoContainerNode() {
        try (Tx tx = this.tx();){
            HibNode node = this.content();
            Assert.assertFalse((String)"The node must not be a container.", (boolean)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema().getContainer());
            ClientHelper.call(() -> this.client().loadNavigation("dummy", node.getUuid(), new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"navigation_error_no_container", (String[])new String[0]);
        }
    }

    @Test
    public void testReadChildrenDepthOne() {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(1).isValid(4);
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
        }
    }

    @Test
    public void testReadChildrenDepthTwo() {
        try (Tx tx = this.tx();){
            HibNode node = this.project().getBaseNode();
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(2)), new VersioningParametersImpl().draft()}));
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(2).isValid(6);
        }
    }

    @Test
    public void testReadChildrenDepthTwoIncludeAll() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(2)).setIncludeAll(true)}).blockingGet();
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
            Object[] expectedNodes = new String[]{"2015", "2014", "News Overview_english_name"};
            List nodeNames = response.getChildren().stream().map(e -> {
                StringFieldImpl titleField = e.getNode().getFields().getStringField("teaser");
                StringFieldImpl slugField = e.getNode().getFields().getStringField("slug");
                if (titleField != null) {
                    return titleField.getString();
                }
                return slugField.getString();
            }).collect(Collectors.toList());
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(2).isValid(8);
            MeshAssertions.assertThat(nodeNames).containsOnly(expectedNodes);
        }
    }

    @Test
    public void testReadChildrenDepthTwoIncludeAllDisabled() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            String uuid = node.getUuid();
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            NavigationResponse response = (NavigationResponse)this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(2)).setIncludeAll(false)}).blockingGet();
            Assert.assertEquals((String)"The root uuid did not match the expected one.", (Object)uuid, (Object)response.getUuid());
            Object[] expectedNodes = new String[]{"2015", "2014"};
            List nodeNames = response.getChildren().stream().map(e -> e.getNode().getFields().getStringField("name").getString()).collect(Collectors.toList());
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(2).isValid(4);
            MeshAssertions.assertThat(nodeNames).containsOnly(expectedNodes);
        }
    }

    @Test
    public void testReadChildrenHighDepth() {
        String uuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", uuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(42))}));
        Assert.assertEquals((Object)uuid, (Object)response.getUuid());
        Assert.assertNotNull((String)"root was null", (Object)response);
    }

    @Test
    public void testNavigationLanguageFallback() {
        String baseNodeUuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        request.setLanguage("en");
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"english folder-0"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"english folder-0"));
        request.setParentNodeUuid(baseNodeUuid);
        NodeResponse englishFolder0 = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        request.setParentNodeUuid(englishFolder0.getUuid());
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"english folder-1"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"english folder-1"));
        NodeResponse englishFolder1 = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        request.setLanguage("de");
        request.setParentNodeUuid(englishFolder1.getUuid());
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"german folder-2"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"german folder-2"));
        NodeResponse germanFolderResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        NavigationResponse navResponse = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", baseNodeUuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(42)), new NodeParametersImpl().setLanguages(new String[]{"de", "en"}).setResolveLinks(LinkType.FULL)}));
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0/english%20folder-1/german%20folder-2", (Object)this.findFolder(navResponse, germanFolderResponse.getUuid()).getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0/english%20folder-1", (Object)this.findFolder(navResponse, englishFolder1.getUuid()).getPath());
        Assert.assertEquals((Object)"/api/v2/dummy/webroot/english%20folder-0", (Object)this.findFolder(navResponse, englishFolder0.getUuid()).getPath());
    }

    private NodeResponse findFolder(NavigationResponse nav, String uuid) {
        return this.findFolder(nav.getChildren(), uuid);
    }

    private NodeResponse findFolder(List<NavigationElement> navList, String uuid) {
        for (NavigationElement element : navList) {
            NodeResponse result;
            if (element.getUuid().equals(uuid)) {
                return element.getNode();
            }
            if (element.getChildren() == null || (result = this.findFolder(element.getChildren(), uuid)) == null) continue;
            return result;
        }
        return null;
    }

    @Test
    public void testNavigationForBranch() {
        HibProject project = this.project();
        String newBranchName = "newbranch";
        String baseNodeUuid = (String)this.tx(() -> project.getBaseNode().getUuid());
        NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", baseNodeUuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft()}));
        MeshAssertions.assertThat((NavigationResponse)response).hasDepth(1).isValid(4);
        this.tx(() -> this.createBranch(newBranchName));
        this.mesh().branchCache().clear();
        response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", baseNodeUuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft()}));
        MeshAssertions.assertThat((NavigationResponse)response).hasDepth(0);
        response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", baseNodeUuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft().setBranch(newBranchName)}));
        MeshAssertions.assertThat((NavigationResponse)response).hasDepth(0);
        response = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", baseNodeUuid, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(1)), new VersioningParametersImpl().draft().setBranch("dummy")}));
        MeshAssertions.assertThat((NavigationResponse)response).hasDepth(1).isValid(4);
    }

    @Test
    public void testPublishedNavigation() {
    }

    @Test
    public void testPublishedNavigationForBranch() {
    }
}

