/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.NodeMeshEventModelAssert;
import com.gentics.mesh.assertj.impl.PublishStatusModelAssert;
import com.gentics.mesh.assertj.impl.PublishStatusResponseAssert;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.PublishStatusModel;
import com.gentics.mesh.core.rest.node.PublishStatusResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodePublishEndpointTest
extends AbstractMeshTest {
    @Test
    public void testPublishNodeInUnpublishedContainer() {
        String parentFolderUuid;
        String subFolderUuid;
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            InternalActionContext ac = this.mockActionContext("recursive=true");
            HibNode subFolder = this.folder("2015");
            HibNode parentFolder = this.folder("news");
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(parentFolder, ac, bac);
            nodeDao.takeOffline(subFolder, ac, bac);
            subFolderUuid = subFolder.getUuid();
            parentFolderUuid = parentFolder.getUuid();
            tx.success();
        }
        this.assertPublishStatus("Node 2015 should not be published", subFolderUuid, false);
        this.assertPublishStatus("Node News should be published", parentFolderUuid, true);
        NodeCreateRequest requestA = new NodeCreateRequest();
        requestA.setLanguage("en");
        requestA.setParentNodeUuid(subFolderUuid);
        requestA.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        requestA.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"nodeA"));
        requestA.getFields().put("slug", (Field)FieldUtil.createStringField((String)"nodeA"));
        NodeResponse nodeA = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", requestA, new ParameterProvider[0]));
        this.trackingSearchProvider().clear().blockingAwait();
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeA.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_parent_containers_not_published", (String[])new String[]{subFolderUuid});
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        ClientHelper.call(() -> this.client().publishNode("dummy", subFolderUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeA.getUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testGetPublishStatusForEmptyLanguage() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            ClientHelper.call(() -> this.client().getNodeLanguagePublishStatus("dummy", node.getUuid(), "fr", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_language_not_found", (String[])new String[]{"fr"});
        }
    }

    @Test
    public void testPublishDeleteCase() {
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.en.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setParentNodeUuid(parentNodeUuid);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        String nodeUuid = response.getUuid();
        ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "en", new ParameterProvider[0]));
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        updateRequest.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        updateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        updateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.en.html"));
        updateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        updateRequest.setLanguage("de");
        updateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.de.html"));
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, updateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "de", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteNode("dummy", nodeUuid, "de", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, updateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "de", new ParameterProvider[0]));
    }

    @Test
    public void testPublishNode() {
        HibNode node = this.folder("2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        String schemaContainerVersionUuid = (String)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            return contentDao.getLatestDraftFieldContainer(node, this.english()).getSchemaContainerVersion().getUuid();
        });
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 5L, 0L, 0L);
        this.trackingSearchProvider().reset();
        PublishStatusResponse status = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)status).as("Publish status", new Object[0])).isNotNull()).isNotPublished("en").hasVersion("en", "1.0");
        this.expect(MeshEvent.NODE_PUBLISHED).match(1, NodeMeshEventModel.class, event -> {
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)event.getBranchUuid());
            Assert.assertEquals((Object)nodeUuid, (Object)event.getUuid());
            Assert.assertEquals((Object)"en", (Object)event.getLanguageTag());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            Assert.assertEquals((Object)"1.0", (Object)schemaRef.getVersion());
        }).one();
        PublishStatusResponse statusResponse = (PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        this.waitForSearchIdleEvent();
        this.awaitEvents();
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)statusResponse).as("Publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "2.0");
        try (Tx tx2 = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)this.projectUuid(), (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)ContainerType.PUBLISHED, null, null), ContentDao.composeDocumentId((String)nodeUuid, (String)"en"));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        }
    }

    @Test
    public void testPublishNodeMultiLanguages() {
        HibNode node = this.folder("2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String branchUuid = (String)this.tx(() -> this.project().getLatestBranch().getUuid());
        String schemaContainerVersionUuid = (String)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            return contentDao.getLatestDraftFieldContainer(node, this.english()).getSchemaContainerVersion().getUuid();
        });
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("de");
        request.setVersion("0.1");
        request.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015-de"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), nodeUuid, request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.waitForSearchIdleEvent();
        this.trackingSearchProvider().reset();
        PublishStatusResponse status = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)status).as("Publish status", new Object[0])).isNotNull()).isNotPublished("en").hasVersion("en", "1.0");
        this.expect(MeshEvent.NODE_PUBLISHED).match(2, NodeMeshEventModel.class, event -> {
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)event.getBranchUuid());
            Assert.assertEquals((Object)nodeUuid, (Object)event.getUuid());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            SchemaReference schemaRef = event.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            Assert.assertEquals((Object)"1.0", (Object)schemaRef.getVersion());
        }).total(2L);
        PublishStatusResponse statusResponse = (PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)statusResponse).as("Publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "2.0");
        try (Tx tx2 = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)this.projectUuid(), (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)ContainerType.PUBLISHED, null, null), ContentDao.composeDocumentId((String)nodeUuid, (String)"en"));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(2L, 0L, 0L, 0L, 0L);
        }
    }

    @Test
    public void testGetPublishStatus() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String nodeUuid = node.getUuid();
            PublishStatusResponse publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("Initial publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "1.0");
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("Publish status after take offline", new Object[0])).isNotNull()).isNotPublished("en").hasVersion("en", "1.0");
            ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
            publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("Publish status after publish", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "2.0");
        }
    }

    @Test
    public void testGetPublishStatusForBranch() {
        HibNode node = this.folder("2015");
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            String nodeUuid = node.getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("de");
            update.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015"));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
            PublishStatusResponse publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("Initial branch publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "1.0").doesNotContain("de");
            publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("New branch publish status", new Object[0])).isNotNull()).isPublished("de").hasVersion("de", "1.0").isPublished("en").hasVersion("en", "1.0");
            publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[]{new NodeParametersImpl()}));
            ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("New branch publish status", new Object[0])).isNotNull()).isPublished("de").hasVersion("de", "1.0").isPublished("en").hasVersion("en", "1.0");
        }
    }

    @Test
    public void testGetPublishStatusNoPermission() {
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testGetPublishStatusBogusUuid() {
        String bogusUuid = "bogus";
        ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", bogusUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{bogusUuid});
    }

    @Test
    public void testGetPublishStatusForLanguage() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", node.getUuid(), "en", new ParameterProvider[0]));
            ((PublishStatusModelAssert)MeshAssertions.assertThat((PublishStatusModel)((PublishStatusModel)ClientHelper.call(() -> this.client().getNodeLanguagePublishStatus("dummy", node.getUuid(), "de", new ParameterProvider[0])))).as("German publish status", new Object[0])).isNotPublished();
            ((PublishStatusModelAssert)MeshAssertions.assertThat((PublishStatusModel)((PublishStatusModel)ClientHelper.call(() -> this.client().getNodeLanguagePublishStatus("dummy", node.getUuid(), "en", new ParameterProvider[0])))).as("English publish status", new Object[0])).isPublished();
        }
    }

    @Test
    public void testPublishNodeWithNoSegmentPathValue() {
        String uuid = (String)this.db().tx(() -> this.folder("news").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNodeUuid(uuid);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some-teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"some-slug"));
        request.getFields().put("content", (Field)FieldUtil.createHtmlField((String)"someContent"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testPublishNodeForBranch() {
        HibNode node = this.folder("2015");
        this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            String nodeUuid = node.getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("de");
            update.getFields().put("slug", (Field)FieldUtil.createStringField((String)"2015 (de)"));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
            PublishStatusResponse publishStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)publishStatus).as("Initial publish status", new Object[0])).isPublished("en").hasVersion("en", "1.0").doesNotContain("de");
        }
    }

    @Test
    public void testPublishNodeNoPermission() {
        HibNode node = this.folder("2015");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.PUBLISH_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.PUBLISH_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testPublishNodeBogusUuid() {
        String bogusUuid = "bogus";
        ClientHelper.call(() -> this.client().publishNode("dummy", bogusUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{bogusUuid});
    }

    @Test
    public void testRepublishUnchanged() {
        String nodeUuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        PublishStatusResponse statusResponse = (PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)statusResponse).as("Publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "1.0");
        statusResponse = (PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        ((PublishStatusResponseAssert)((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)statusResponse).as("Publish status", new Object[0])).isNotNull()).isPublished("en").hasVersion("en", "1.0");
    }

    @Test
    public void testMoveConsistency() {
        String newsFolderUuid = (String)this.db().tx(() -> this.folder("news").getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", newsFolderUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        String publishedNode = (String)this.db().tx(() -> this.content("concorde").getUuid());
        ClientHelper.call(() -> this.client().moveNode("dummy", publishedNode, newsFolderUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_parent_containers_not_published", (String[])new String[]{newsFolderUuid});
    }

    @Test
    public void testPublishLanguage() {
        String nodeUuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        String branchUuid = (String)this.db().tx(() -> this.latestBranch().getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("de");
        update.getFields().put("name", (Field)FieldUtil.createStringField((String)"changed-de"));
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_published_not_found_for_uuid_branch_language", (String[])new String[]{nodeUuid, "de", branchUuid});
        this.expect(MeshEvent.NODE_UNPUBLISHED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(nodeUuid)).hasSchema("folder", schemaUuid).hasBranchUuid(branchUuid).hasLanguage("en").hasProject("dummy", this.projectUuid())).one();
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "en", new ParameterProvider[0]));
        this.awaitEvents();
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_published_not_found_for_uuid_branch_language", (String[])new String[]{nodeUuid, "de", branchUuid});
        this.expect(MeshEvent.NODE_PUBLISHED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(nodeUuid)).hasSchema("folder", schemaUuid).hasBranchUuid(branchUuid).hasLanguage("de").hasProject("dummy", this.projectUuid())).one();
        PublishStatusModel publishStatus = (PublishStatusModel)ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "de", new ParameterProvider[0]));
        ((PublishStatusModelAssert)MeshAssertions.assertThat((PublishStatusModel)publishStatus).as("Publish status", new Object[0])).isPublished().hasVersion("1.0");
        this.awaitEvents();
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"}), new VersioningParametersImpl().published()}));
        Assert.assertTrue((boolean)((PublishStatusModel)response.getAvailableLanguages().get("de")).isPublished());
        Assert.assertFalse((boolean)((PublishStatusModel)response.getAvailableLanguages().get("en")).isPublished());
        ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isPublished("de").hasVersion("de", "1.0").isNotPublished("en").hasVersion("en", "2.0");
    }

    @Test
    public void testPublishEmptyLanguage() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "de", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_language_not_found", (String[])new String[]{"de"});
        }
    }

    @Test
    public void testPublishLanguageForBranch() {
        HibNode node = this.folder("2015");
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid()), new PublishParametersImpl().setRecursive(true)}));
            tx.success();
        }
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            String nodeUuid = node.getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("de");
            update.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 de"));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            update.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 new de"));
            update.setVersion("1.0");
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            update.setLanguage("en");
            update.getFields().put("name", (Field)FieldUtil.createStringField((String)"2015 new en"));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            PublishStatusModel publishStatus = (PublishStatusModel)ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "de", new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())}));
            MeshAssertions.assertThat((PublishStatusModel)publishStatus).isPublished();
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranch().getName())})))).as("Initial Branch Publish Status", new Object[0])).isPublished("de").isNotPublished("en");
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())})))).as("New Branch Publish Status", new Object[0])).isNotPublished("de").isNotPublished("en");
        }
    }

    @Test
    public void testPublishLanguageNoPermission() {
        HibNode node = this.folder("2015");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.PUBLISH_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.PUBLISH_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testPublishInOfflineContainer() {
        String nodeUuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        String contentUuid = (String)this.db().tx(() -> this.content("news_2015").getUuid());
        ClientHelper.call(() -> this.client().publishNode("dummy", contentUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_parent_containers_not_published", (String[])new String[]{nodeUuid});
    }

    @Test
    public void testPublishRecursively() {
        String nodeUuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        String contentUuid = (String)this.db().tx(() -> this.content("news_2015").getUuid());
        this.assertPublishStatus("Node should be published.", nodeUuid, true);
        this.assertPublishStatus("Node should be published.", contentUuid, true);
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.assertPublishStatus("Node should be offline.", nodeUuid, false);
        this.assertPublishStatus("Node should be offline.", contentUuid, false);
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.assertPublishStatus("Node should be online again.", nodeUuid, true);
        this.assertPublishStatus("Node should be online again.", contentUuid, true);
    }

    @Test
    public void testPublishNoRecursion() {
        String nodeUuid = (String)this.db().tx(() -> this.project().getBaseNode().getUuid());
        String contentUuid = (String)this.db().tx(() -> this.content("news_2015").getUuid());
        this.assertPublishStatus("Node should be published.", nodeUuid, true);
        this.assertPublishStatus("Node should be published.", contentUuid, true);
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.assertPublishStatus("Node should be offline.", nodeUuid, false);
        this.assertPublishStatus("Node should be offline.", contentUuid, false);
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        this.assertPublishStatus("Node should be online again.", nodeUuid, true);
        this.assertPublishStatus("Sub node should still be offline.", contentUuid, false);
    }

    private void assertPublishStatus(String message, String nodeUuid, boolean expectPublished) {
        PublishStatusResponse initialStatus = (PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0]));
        for (Map.Entry entry : initialStatus.getAvailableLanguages().entrySet()) {
            if (expectPublished == ((PublishStatusModel)entry.getValue()).isPublished()) continue;
            Assert.fail((String)("Publish status check for node {" + nodeUuid + "} failed for language {" + (String)entry.getKey() + "} [" + message + "]"));
        }
    }
}

