/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.navigation.NavigationResponse;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.tag.TagCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true, elasticsearch=ElasticsearchTestMode.CONTAINER_ES7)
public class NodeReadPermissionTest
extends AbstractMeshTest {
    @Parameterized.Parameter(value=0)
    public String version;
    private ProjectResponse project;
    private NodeResponse testFolder;
    private NodeResponse newFolder;
    private NodeResponse newFolderWithRead;
    private NodeResponse publishedFolder;
    private NodeResponse publishedFolderWithRead;
    private NodeResponse modifiedFolder;
    private NodeResponse modifiedFolderWithRead;
    private NodeResponse newFolderWithoutPerm;
    private NodeResponse publishedFolderWithoutPerm;
    private NodeResponse modifiedFolderWithoutPerm;
    private TagFamilyResponse tagFamily;
    private TagResponse tag;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> paramData() {
        return Arrays.asList({"draft"}, {"published"});
    }

    @Before
    public void prepareData() throws Exception {
        this.project = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByName("dummy", new ParameterProvider[0]));
        this.tagFamily = (TagFamilyResponse)ClientHelper.call(() -> this.client().createTagFamily("dummy", new TagFamilyCreateRequest().setName("colors")));
        this.tag = (TagResponse)ClientHelper.call(() -> this.client().createTag("dummy", this.tagFamily.getUuid(), new TagCreateRequest().setName("red")));
        this.testFolder = this.createFolder(this.project.getRootNode().getUuid(), "Test Folder", false);
        this.testFolder = this.publish(this.testFolder);
        this.newFolderWithoutPerm = this.createFolder(this.testFolder.getUuid(), "New without perm", true);
        this.newFolder = this.createFolder(this.testFolder.getUuid(), "New", true);
        this.newFolderWithRead = this.createFolder(this.testFolder.getUuid(), "New with read", true);
        this.publishedFolderWithoutPerm = this.createFolder(this.testFolder.getUuid(), "Published without perm", true);
        this.publishedFolderWithoutPerm = this.publish(this.publishedFolderWithoutPerm);
        this.publishedFolder = this.createFolder(this.testFolder.getUuid(), "Published", true);
        this.publishedFolder = this.publish(this.publishedFolder);
        this.publishedFolderWithRead = this.createFolder(this.testFolder.getUuid(), "Published with read", true);
        this.publishedFolderWithRead = this.publish(this.publishedFolderWithRead);
        this.modifiedFolderWithoutPerm = this.createFolder(this.testFolder.getUuid(), "Original without perm", true);
        this.modifiedFolderWithoutPerm = this.publish(this.modifiedFolderWithoutPerm);
        this.modifiedFolderWithoutPerm = this.update(this.modifiedFolderWithoutPerm, "Modified without perm");
        this.modifiedFolder = this.createFolder(this.testFolder.getUuid(), "Original", true);
        this.modifiedFolder = this.publish(this.modifiedFolder);
        this.modifiedFolder = this.update(this.modifiedFolder, "Modified");
        this.modifiedFolderWithRead = this.createFolder(this.testFolder.getUuid(), "Original with read", true);
        this.modifiedFolderWithRead = this.publish(this.modifiedFolderWithRead);
        this.modifiedFolderWithRead = this.update(this.modifiedFolderWithRead, "Modified with read");
        this.setPermission(this.newFolderWithoutPerm, null);
        this.setPermission(this.newFolder, InternalPermission.READ_PUBLISHED_PERM);
        this.setPermission(this.newFolderWithRead, InternalPermission.READ_PERM);
        this.setPermission(this.publishedFolderWithoutPerm, null);
        this.setPermission(this.publishedFolder, InternalPermission.READ_PUBLISHED_PERM);
        this.setPermission(this.publishedFolderWithRead, InternalPermission.READ_PERM);
        this.setPermission(this.modifiedFolderWithoutPerm, null);
        this.setPermission(this.modifiedFolder, InternalPermission.READ_PUBLISHED_PERM);
        this.setPermission(this.modifiedFolderWithRead, InternalPermission.READ_PERM);
        this.recreateIndices();
    }

    @Test
    public void testFindNodes() {
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodes("dummy", new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List<String> folderNames = nodeList.getData().stream().map(NodeResponse::getDisplayName).collect(Collectors.toList());
        this.assertFolderNames(folderNames, true);
    }

    @Test
    public void testFindNodeChildren() {
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodeChildren("dummy", this.testFolder.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List<String> folderNames = nodeList.getData().stream().map(NodeResponse::getDisplayName).collect(Collectors.toList());
        this.assertFolderNames(folderNames, false);
    }

    @Test
    public void testFindNodesForTag() {
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", this.tagFamily.getUuid(), this.tag.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List<String> folderNames = nodeList.getData().stream().map(NodeResponse::getDisplayName).collect(Collectors.toList());
        this.assertFolderNames(folderNames, false);
    }

    @Test
    public void testSearchNodes() {
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("{ \"query\": { \"match\": { \"schema.name\": { \"query\": \"folder\" } } } }", new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List<String> folderNames = nodeList.getData().stream().map(NodeResponse::getDisplayName).collect(Collectors.toList());
        this.assertFolderNames(folderNames, true);
    }

    @Test
    public void testSearchNodesInProject() {
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", "{ \"query\": { \"match\": { \"schema.name\": { \"query\": \"folder\" } } } }", new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List<String> folderNames = nodeList.getData().stream().map(NodeResponse::getDisplayName).collect(Collectors.toList());
        this.assertFolderNames(folderNames, true);
    }

    @Test
    public void testLoadNavigation() {
        NavigationResponse navigation = (NavigationResponse)ClientHelper.call(() -> this.client().loadNavigation("dummy", this.testFolder.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        Assertions.assertThat((List)navigation.getChildren()).as("Navigation children", new Object[0]).isNotNull();
        List<String> folderNames = navigation.getChildren().stream().map(item -> item.getNode().getDisplayName()).collect(Collectors.toList());
        this.assertFolderNames(folderNames, false);
    }

    @Test
    public void testNavroot() {
        NavigationResponse navigation = (NavigationResponse)ClientHelper.call(() -> this.client().navroot("dummy", "/Test%20Folder", new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        Assertions.assertThat((List)navigation.getChildren()).as("Navigation children", new Object[0]).isNotNull();
        List<String> folderNames = navigation.getChildren().stream().map(item -> item.getNode().getDisplayName()).collect(Collectors.toList());
        this.assertFolderNames(folderNames, false);
    }

    @Test
    public void testGraphQLNodes() {
        this.doGraphQLTest("{nodes {elements {displayName }}}", "$.data.nodes.elements[*].displayName", true, new String[0]);
    }

    @Test
    public void testGraphQLChildren() {
        this.doGraphQLTest("query ($uuid: String) { node(uuid: $uuid) { uuid children { elements { displayName}}}}", "$.data.node.children.elements[*].displayName", false, "uuid", this.testFolder.getUuid());
    }

    @Test
    public void testGraphQLNodesOfSchema() {
        this.doGraphQLTest("query ($schema: String) { schema(name: $schema) { nodes { elements { displayName } } } }", "$.data.schema.nodes.elements[*].displayName", true, "schema", "folder");
    }

    @Test
    public void testGraphQLNodesWithTag() {
        this.doGraphQLTest("{ tag(name:\"red\") { nodes { elements { displayName } } } }", "$.data.tag.nodes.elements[*].displayName", false, new String[0]);
    }

    @Test
    public void testGraphQLSearchNodes() {
        this.doGraphQLTest("query ($search: String) { nodes(query: $search) { elements { displayName } } }", "$.data.nodes.elements[*].displayName", true, "search", "{ \"query\": { \"match\": { \"schema.name\": { \"query\": \"folder\" } } } }");
    }

    protected void doGraphQLTest(String query, String path, boolean includeOthers, String ... varsKeyValues) {
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery(query);
        if (varsKeyValues.length > 0) {
            JsonObject vars = new JsonObject();
            for (int i = 0; i < varsKeyValues.length; i += 2) {
                vars.put(varsKeyValues[i], (Object)varsKeyValues[i + 1]);
            }
            request.setVariables(vars);
        }
        GraphQLResponse graphQLResponse = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        List folderNames = (List)JsonPath.read((String)graphQLResponse.toJson(), (String)path, (Predicate[])new Predicate[0]);
        this.assertFolderNames(folderNames, includeOthers);
    }

    protected void assertFolderNames(List<String> folderNames, boolean includeOthers) {
        folderNames.removeIf(name -> name == null);
        switch (this.version) {
            case "draft": {
                if (includeOthers) {
                    Assertions.assertThat(folderNames).as("Folder names", new Object[0]).containsOnly((Object[])new String[]{"2015", "News", "Test Folder", "New with read", "Published with read", "Modified with read"});
                    break;
                }
                Assertions.assertThat(folderNames).as("Folder names", new Object[0]).containsOnly((Object[])new String[]{"New with read", "Published with read", "Modified with read"});
                break;
            }
            case "published": {
                if (includeOthers) {
                    Assertions.assertThat(folderNames).as("Folder names", new Object[0]).containsOnly((Object[])new String[]{"2015", "News", "Test Folder", "Published", "Published with read", "Original", "Original with read"});
                    break;
                }
                Assertions.assertThat(folderNames).as("Folder names", new Object[0]).containsOnly((Object[])new String[]{"Published", "Published with read", "Original", "Original with read"});
                break;
            }
            default: {
                Assertions.fail((String)("Unexpected version " + this.version));
            }
        }
    }

    protected NodeResponse createFolder(String parentNodeUuid, String name, boolean setTag) {
        NodeCreateRequest createRequest = new NodeCreateRequest();
        createRequest.setSchemaName("folder");
        createRequest.setParentNodeUuid(parentNodeUuid);
        createRequest.setLanguage("en");
        createRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)name));
        createRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)name));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createRequest, new ParameterProvider[0]));
        if (setTag) {
            ClientHelper.call(() -> this.client().addTagToNode("dummy", response.getUuid(), this.tag.getUuid(), new ParameterProvider[0]));
        }
        return response;
    }

    protected NodeResponse publish(NodeResponse node) {
        ClientHelper.call(() -> this.client().publishNode("dummy", node.getUuid(), new ParameterProvider[0]));
        return node;
    }

    protected NodeResponse update(NodeResponse node, String newName) {
        NodeUpdateRequest updateRequest = new NodeUpdateRequest();
        updateRequest.setLanguage("en");
        updateRequest.setVersion("draft");
        updateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)newName));
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), updateRequest, new ParameterProvider[0]));
    }

    protected void setPermission(NodeResponse node, InternalPermission perm) {
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibNode n = (HibNode)nodeDao.findByUuid((HibCoreElement)this.project(), node.getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)n, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM});
            if (perm != null) {
                roleDao.grantPermissions(this.role(), (HibBaseElement)n, new InternalPermission[]{perm});
            }
        });
    }
}

