/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.AbstractNameUuidReference;
import com.gentics.mesh.core.rest.event.node.NodeTaggedEventModel;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectReference;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagReference;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeTagEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadNodeTags() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            Assert.assertNotNull((Object)node);
            Assert.assertNotNull((Object)node.getUuid());
            Assert.assertNotNull((Object)node.getSchemaContainer());
            TagListResponse tagList = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", node.getUuid(), new ParameterProvider[0]));
            Assert.assertEquals((long)4L, (long)tagList.getData().size());
            Assert.assertEquals((long)4L, (long)tagList.getMetainfo().getTotalCount());
        }
    }

    @Test
    public void testAddTagToNode() throws Exception {
        HibNode node = this.folder("2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> node.getSchemaContainer().getUuid());
        HibTag tag = this.tag("red");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedStoreEvents(0);
        }
        this.expect(MeshEvent.NODE_TAGGED).match(1, NodeTaggedEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            NodeReference nodeRef = event.getNode();
            Assert.assertNotNull((Object)nodeRef);
            Assert.assertEquals((Object)nodeUuid, (Object)nodeRef.getUuid());
            SchemaReference schemaRef = nodeRef.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            TagReference tagRef = event.getTag();
            Assert.assertNotNull((Object)tagRef);
            Assert.assertEquals((Object)"red", (Object)tagRef.getName());
            Assert.assertEquals((Object)tagUuid, (Object)tagRef.getUuid());
        }).one();
        ClientHelper.call(() -> this.client().addTagToNode("dummy", nodeUuid, tagUuid, new ParameterProvider[0]));
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().addTagToNode("dummy", nodeUuid, tagUuid, new ParameterProvider[0]));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            MeshAssertions.assertThat((NodeResponse)restNode).contains(tag);
            Assert.assertTrue((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
    }

    @Test
    public void testAddTagToNoPermNode() throws Exception {
        TagDao tagDao;
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("red");
        try (Tx tx = this.tx();){
            tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().addTagToNode("dummy", node.getUuid(), tag.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{node.getUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            tagDao = tx.tagDao();
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testAddNoPermTagToNode() throws Exception {
        TagDao tagDao;
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("red");
        try (Tx tx = this.tx();){
            tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().addTagToNode("dummy", node.getUuid(), tag.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tag.getUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            tagDao = tx.tagDao();
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUntaggingViaDeleteOfTag() {
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("bike");
        String schemaUuid = (String)this.tx(() -> node.getSchemaContainer().getUuid());
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        String tagFamilyUuid = (String)this.tx(() -> tag.getTagFamily().getUuid());
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            Assert.assertTrue((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        this.expect(MeshEvent.NODE_UNTAGGED).match(1, NodeTaggedEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            NodeReference nodeRef = event.getNode();
            Assert.assertNotNull((Object)nodeRef);
            Assert.assertEquals((Object)nodeUuid, (Object)nodeRef.getUuid());
            SchemaReference schemaRef = nodeRef.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            TagReference tagRef = event.getTag();
            Assert.assertNotNull((Object)tagRef);
            Assert.assertEquals((Object)"Bike", (Object)tagRef.getName());
            Assert.assertEquals((Object)tagUuid, (Object)tagRef.getUuid());
        }).one();
        ClientHelper.call(() -> this.client().deleteTag(this.projectName(), tagFamilyUuid, tagUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        long storeEvents = 2L;
        long deleteEvents = 1L;
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(storeEvents, 0L, deleteEvents, 0L, 0L);
    }

    @Test
    public void testRemoveTagFromNode() throws Exception {
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("bike");
        String schemaUuid = (String)this.tx(() -> node.getSchemaContainer().getUuid());
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            Assert.assertTrue((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        this.expect(MeshEvent.NODE_UNTAGGED).match(1, NodeTaggedEventModel.class, event -> {
            BranchReference branchRef = event.getBranch();
            Assert.assertNotNull((Object)branchRef);
            Assert.assertEquals((Object)this.initialBranchUuid(), (Object)branchRef.getUuid());
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            ProjectReference projectRef = event.getProject();
            Assert.assertNotNull((Object)projectRef);
            Assert.assertEquals((Object)"dummy", (Object)projectRef.getName());
            Assert.assertEquals((Object)this.projectUuid(), (Object)projectRef.getUuid());
            NodeReference nodeRef = event.getNode();
            Assert.assertNotNull((Object)nodeRef);
            Assert.assertEquals((Object)nodeUuid, (Object)nodeRef.getUuid());
            SchemaReference schemaRef = nodeRef.getSchema();
            Assert.assertNotNull((Object)schemaRef);
            Assert.assertEquals((Object)"folder", (Object)schemaRef.getName());
            Assert.assertEquals((Object)schemaUuid, (Object)schemaRef.getUuid());
            TagReference tagRef = event.getTag();
            Assert.assertNotNull((Object)tagRef);
            Assert.assertEquals((Object)"Bike", (Object)tagRef.getName());
            Assert.assertEquals((Object)tagUuid, (Object)tagRef.getUuid());
        }).one();
        ClientHelper.call(() -> this.client().removeTagFromNode("dummy", nodeUuid, tagUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().removeTagFromNode("dummy", nodeUuid, tagUuid, new ParameterProvider[0]));
        this.awaitEvents();
        NodeResponse restNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            MeshAssertions.assertThat((NodeResponse)restNode).contains(tag);
            Assert.assertFalse((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
    }

    @Test
    public void testRemoveBogusTagFromNode() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            String uuid = node.getUuid();
            ClientHelper.call(() -> this.client().removeTagFromNode("dummy", uuid, "bogus", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
        }
    }

    @Test
    public void testRemoveTagFromNoPermNode() throws Exception {
        TagDao tagDao;
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("bike");
        try (Tx tx = this.tx();){
            tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            tagDao = tx.tagDao();
            ClientHelper.call(() -> this.client().removeTagFromNode("dummy", node.getUuid(), tag.getUuid(), new ParameterProvider[]{new NodeParametersImpl()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{node.getUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertTrue((String)"The tag should not be removed from the node", (boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testTaggingAcrossMultipleBranches() throws Exception {
        HibTag tag2;
        HibTag tag1;
        NodeListResponse taggedNodes;
        HibTag tag3;
        NodeResponse response;
        TagListResponse tagsForNode;
        HibTag tag4;
        HibNode node;
        this.grantAdmin();
        String branchOne = "BranchV1";
        String branchTwo = "BranchV2";
        this.waitForLatestJob(() -> {
            try (Tx tx = this.tx();){
                BranchCreateRequest request = new BranchCreateRequest();
                request.setName(branchOne);
                BranchResponse branchResponse = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
                ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branchResponse).as("Branch Response", new Object[0])).isNotNull()).hasName(branchOne).isActive().isNotMigrated();
            }
        });
        try (Tx tx = this.tx();){
            node = this.content();
            tag4 = this.tag("red");
            ClientHelper.call(() -> this.client().addTagToNode("dummy", node.getUuid(), tag4.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
        }
        tx = this.tx();
        try {
            node = this.content();
            tagsForNode = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected the node to be tagged with the red tag but the tag was not found in the list.", (long)1L, (long)tagsForNode.getData().stream().filter(tag -> tag.getName().equals("red")).count());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected to find the red tag in the node response", (long)1L, (long)response.getTags().stream().filter(tag -> tag.getName().equals("red")).count());
            tag3 = this.tag("red");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag3.getTagFamily().getUuid(), tag3.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected to find the node in the list response but it was not included.", (long)1L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.waitForLatestJob(() -> {
            try (Tx tx = this.tx();){
                BranchCreateRequest request = new BranchCreateRequest();
                request.setName(branchTwo);
                BranchResponse branchResponse = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
                ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)branchResponse).as("Branch Response", new Object[0])).isNotNull()).hasName(branchTwo).isActive().isNotMigrated();
            }
        });
        tx = this.tx();
        try {
            node = this.content();
            tag4 = this.tag("blue");
            ClientHelper.call(() -> this.client().addTagToNode("dummy", node.getUuid(), tag4.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            node = this.content();
            tagsForNode = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected the node to be tagged with the red tag but the tag was not found in the list.", (long)1L, (long)tagsForNode.getData().stream().filter(tag -> tag.getName().equals("red")).count());
            Assert.assertEquals((String)"We expected the node to be tagged with the blue tag but the tag was not found in the list.", (long)1L, (long)tagsForNode.getData().stream().filter(tag -> tag.getName().equals("blue")).count());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the red tag in the node response", (long)1L, (long)response.getTags().stream().filter(tag -> tag.getName().equals("red")).count());
            Assert.assertEquals((String)"We expected to find the red tag in the node response", (long)1L, (long)response.getTags().stream().filter(tag -> tag.getName().equals("blue")).count());
            tag1 = this.tag("red");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag1.getTagFamily().getUuid(), tag1.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the node in the list response but it was not included.", (long)1L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
            tag2 = this.tag("blue");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag2.getTagFamily().getUuid(), tag2.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the node in the list response but it was not included.", (long)1L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            node = this.content();
            tag4 = this.tag("red");
            ClientHelper.call(() -> this.client().removeTagFromNode("dummy", node.getUuid(), tag4.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            node = this.content();
            tagsForNode = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected the node to be tagged with the red tag but the tag was not found in the list.", (long)1L, (long)tagsForNode.getData().stream().filter(tag -> tag.getName().equals("red")).count());
            Assert.assertEquals((String)"We expected the node to be tagged with the blue tag but the tag was not found in the list.", (long)1L, (long)tagsForNode.getData().stream().filter(tag -> tag.getName().equals("blue")).count());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the red tag in the node response", (long)1L, (long)response.getTags().stream().filter(tag -> tag.getName().equals("red")).count());
            Assert.assertEquals((String)"We expected to find the red tag in the node response", (long)1L, (long)response.getTags().stream().filter(tag -> tag.getName().equals("blue")).count());
            tag1 = this.tag("red");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag1.getTagFamily().getUuid(), tag1.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the node in the list response but it was not included.", (long)1L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
            tag2 = this.tag("blue");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag2.getTagFamily().getUuid(), tag2.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchTwo)}));
            Assert.assertEquals((String)"We expected to find the node in the list response but it was not included.", (long)1L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            node = this.content();
            tagsForNode = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected to find no tags for the node in branch one.", (long)0L, (long)tagsForNode.getData().size());
            response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected to find no tags for the node in branch one.", (long)0L, (long)response.getTags().size());
            tag3 = this.tag("red");
            taggedNodes = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", tag3.getTagFamily().getUuid(), tag3.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchOne)}));
            Assert.assertEquals((String)"We expected to find the node not be tagged by tag red.", (long)0L, (long)taggedNodes.getData().stream().filter(item -> item.getUuid().equals(node.getUuid())).count());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testRemoveNoPermTagFromNode() throws Exception {
        TagDao tagDao;
        HibNode node = this.folder("2015");
        HibTag tag = this.tag("bike");
        try (Tx tx = this.tx();){
            tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            Assert.assertTrue((boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().removeTagFromNode("dummy", node.getUuid(), tag.getUuid(), new ParameterProvider[]{new NodeParametersImpl()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tag.getUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            tagDao = tx.tagDao();
            Assert.assertTrue((String)"The tag should not have been removed from the node", (boolean)tagDao.getTags(node, this.project().getLatestBranch()).list().contains(tag));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateNodeWithTags() {
        NodeCreateRequest request = this.prepareCreateRequest();
        ArrayList<TagReference> tags = new ArrayList<TagReference>();
        tags.add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        request.setTags(tags);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        List loadedTags = response.getTags();
        ((AbstractListAssert)MeshAssertions.assertThat((List)loadedTags).isNotEmpty()).hasSize(1);
        TagReference tag = (TagReference)loadedTags.get(0);
        Assert.assertEquals((Object)"red", (Object)tag.getName());
        Assert.assertEquals((Object)"colors", (Object)tag.getTagFamily());
    }

    @Test
    public void testCreateNodeWithNewTags() {
        NodeCreateRequest request = this.prepareCreateRequest();
        ArrayList<TagReference> tags = new ArrayList<TagReference>();
        tags.add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        tags.add(((TagReference)new TagReference().setName("red123")).setTagFamily("colors"));
        request.setTags(tags);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        List loadedTags = response.getTags();
        ((AbstractListAssert)MeshAssertions.assertThat((List)loadedTags).isNotEmpty()).hasSize(2);
        Map tagMap = loadedTags.stream().collect(Collectors.toMap(AbstractNameUuidReference::getName, Function.identity()));
        TagReference tag = (TagReference)tagMap.get("red");
        Assert.assertEquals((Object)"colors", (Object)tag.getTagFamily());
        TagReference tag2 = (TagReference)tagMap.get("red123");
        Assert.assertEquals((Object)"colors", (Object)tag2.getTagFamily());
    }

    private NodeCreateRequest prepareCreateRequest() {
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setParentNodeUuid(folderUuid);
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setSchemaName("content");
        return request;
    }

    @Test
    public void testUpdateNodeWithTags() {
        NodeUpdateRequest request = this.prepareUpdateRequest();
        String nodeUuid = this.contentUuid();
        ArrayList<TagReference> tags = new ArrayList<TagReference>();
        tags.add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        request.setTags(tags);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        List loadedTags = response.getTags();
        ((AbstractListAssert)MeshAssertions.assertThat((List)loadedTags).isNotEmpty()).hasSize(1);
        TagReference tag = (TagReference)loadedTags.get(0);
        Assert.assertEquals((Object)"red", (Object)tag.getName());
        Assert.assertEquals((Object)"colors", (Object)tag.getTagFamily());
    }

    @Test
    public void testUpdateNodeWithNewTags() {
        NodeUpdateRequest request = this.prepareUpdateRequest();
        String nodeUuid = this.contentUuid();
        ArrayList<TagReference> tags = new ArrayList<TagReference>();
        tags.add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        tags.add(((TagReference)new TagReference().setName("red1234")).setTagFamily("colors"));
        request.setTags(tags);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        List loadedTags = response.getTags();
        ((AbstractListAssert)MeshAssertions.assertThat((List)loadedTags).isNotEmpty()).hasSize(2);
        loadedTags = loadedTags.stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        TagReference tag = (TagReference)loadedTags.get(0);
        Assert.assertEquals((Object)"red", (Object)tag.getName());
        Assert.assertEquals((Object)"colors", (Object)tag.getTagFamily());
        TagReference tag2 = (TagReference)loadedTags.get(1);
        Assert.assertEquals((Object)"red1234", (Object)tag2.getName());
        Assert.assertEquals((Object)"colors", (Object)tag2.getTagFamily());
    }

    private NodeUpdateRequest prepareUpdateRequest() {
        NodeUpdateRequest request = new NodeUpdateRequest();
        request.setLanguage("en");
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        request.setVersion("0.1");
        return request;
    }
}

