/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchReference;
import com.gentics.mesh.core.rest.event.node.NodeTaggedEventModel;
import com.gentics.mesh.core.rest.event.tag.TagMeshEventModel;
import com.gentics.mesh.core.rest.tag.TagFamilyReference;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagListUpdateRequest;
import com.gentics.mesh.core.rest.tag.TagReference;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeTagUpdateEndpointTest
extends AbstractMeshTest {
    @Test
    public void testMissingTagFamilyName() {
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("green")).setTagFamily(""));
        ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"tag_error_tagfamily_not_set", (String[])new String[0]);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
    }

    @Test
    public void testUnknownTagFamilyName() {
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("green")).setTagFamily("blub123"));
        ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"tagfamily_not_found", (String[])new String[]{"blub123"});
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
    }

    @Test
    public void testMissingTagName() {
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("")).setTagFamily("colors"));
        ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"tag_error_name_or_uuid_missing", (String[])new String[0]);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
    }

    @Test
    public void testUpdateByTagUuid() {
        long previousCount = (Long)this.tx(tx -> tx.tagDao().findAll((HibCoreElement)this.tagFamily("colors")).count());
        String tagUuid = (String)this.tx(() -> this.tag("red").getUuid());
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setUuid(tagUuid)).setTagFamily("colors"));
        TagListResponse response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)response.getMetainfo().getTotalCount());
        long afterCount = (Long)this.tx(tx -> tx.tagDao().findAll((HibCoreElement)this.tagFamily("colors")).count());
        Assert.assertEquals((String)"The colors tag family should not have any additional tags.", (long)previousCount, (long)afterCount);
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).storedAllContainers(this.content(), this.project(), this.latestBranch(), new String[]{"en", "de"}).hasEvents(4L, 0L, 0L, 0L, 0L);
        }
    }

    @Test
    public void testUpdateByTagName() {
        long previousCount = (Long)this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            return tagDao.findAll((HibCoreElement)this.tagFamily("colors")).count();
        });
        Assert.assertEquals((String)"The colors tag family did not have the expected amount of tags", (long)3L, (long)previousCount);
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String branchUuid = (String)this.tx(() -> this.initialBranchUuid());
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("purple")).setTagFamily("colors"));
        request.getTags().add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        this.expect(MeshEvent.TAG_CREATED).match(1, TagMeshEventModel.class, event -> {
            Assert.assertEquals((Object)"purple", (Object)event.getName());
            Assert.assertNotNull((Object)event.getUuid());
            TagFamilyReference tagFamilyRef = event.getTagFamily();
            Assert.assertEquals((Object)"colors", (Object)tagFamilyRef.getName());
            Assert.assertEquals((Object)tagFamilyUuid, (Object)tagFamilyRef.getUuid());
        }).one();
        this.expect(MeshEvent.TAG_DELETED).none();
        this.expect(MeshEvent.NODE_UNTAGGED).none();
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).none();
        this.expect(MeshEvent.NODE_TAGGED).match(2, NodeTaggedEventModel.class, event -> {
            MeshAssertions.assertThat((String)event.getTag().getName()).matches((CharSequence)"red|purple");
            BranchReference branchRef = event.getBranch();
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)branchUuid, (Object)branchRef.getUuid());
            NodeReference nodeRef = event.getNode();
            Assert.assertEquals((Object)nodeUuid, (Object)nodeRef.getUuid());
        }).two();
        TagListResponse response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        Assert.assertEquals((String)"The node should have two tags.", (long)2L, (long)response.getMetainfo().getTotalCount());
        long afterCount = (Long)this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            return tagDao.findAll((HibCoreElement)this.tagFamily("colors")).count();
        });
        Assert.assertEquals((String)"The colors tag family should now have one additional color tag.", (long)(previousCount + 1L), (long)afterCount);
        try (Tx tx2 = this.tx();){
            TagDao tagDao = tx2.tagDao();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).storedAllContainers(this.content(), this.project(), this.latestBranch(), new String[]{"en", "de"});
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).stored(this.tagFamily("colors"));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).stored((HibTag)tagDao.findByName((HibCoreElement)this.tagFamily("colors"), "purple"));
            long stores = 6L;
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(stores, 0L, 0L, 0L, 0L);
        }
        this.trackingSearchProvider().reset();
        this.expect(MeshEvent.TAG_DELETED).none();
        this.expect(MeshEvent.TAG_CREATED).none();
        this.expect(MeshEvent.NODE_TAGGED).none();
        this.expect(MeshEvent.NODE_UNTAGGED).none();
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).none();
        response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        this.expect(MeshEvent.TAG_CREATED).none();
        this.expect(MeshEvent.TAG_DELETED).none();
        this.expect(MeshEvent.NODE_TAGGED).none();
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).none();
        this.expect(MeshEvent.NODE_UNTAGGED).match(1, NodeTaggedEventModel.class, event -> {
            MeshAssertions.assertThat((String)event.getTag().getName()).matches((CharSequence)"purple");
            BranchReference branchRef = event.getBranch();
            Assert.assertEquals((Object)"dummy", (Object)branchRef.getName());
            Assert.assertEquals((Object)branchUuid, (Object)branchRef.getUuid());
            NodeReference nodeRef = event.getNode();
            Assert.assertEquals((Object)nodeUuid, (Object)nodeRef.getUuid());
        }).one();
        TagListUpdateRequest request2 = new TagListUpdateRequest();
        request2.getTags().add(((TagReference)new TagReference().setName("red")).setTagFamily("colors"));
        response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request2, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        long stores = 4L;
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(stores, 0L, 0L, 0L, 0L);
    }

    @Test
    public void testUpdateWithNewTagFamilyAndTag() {
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("blub1")).setTagFamily("colors"));
        request.getTags().add(((TagReference)new TagReference().setName("bla2")).setTagFamily("basic"));
        request.getTags().add(((TagReference)new TagReference().setName("blub3")).setTagFamily("colors"));
        request.getTags().add(((TagReference)new TagReference().setName("bla4")).setTagFamily("basic"));
        TagListResponse response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        Assert.assertEquals((long)4L, (long)response.getMetainfo().getTotalCount());
        this.waitForSearchIdleEvent();
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).storedAllContainers(this.content(), this.project(), this.latestBranch(), new String[]{"en", "de"}).hasEvents(10L, 0L, 0L, 0L, 0L);
        }
        this.trackingSearchProvider().clear().blockingAwait();
        request.getTags().clear();
        request.getTags().add(((TagReference)new TagReference().setName("bla2")).setTagFamily("basic"));
        request.getTags().add(((TagReference)new TagReference().setName("blub3")).setTagFamily("colors"));
        response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        Assert.assertEquals((long)2L, (long)response.getMetainfo().getTotalCount());
        this.waitForSearchIdleEvent();
        tx = this.tx();
        try {
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).storedAllContainers(this.content(), this.project(), this.latestBranch(), new String[]{"en", "de"}).hasEvents(4L, 0L, 0L, 0L, 0L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testTagOrder() {
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("blub1")).setTagFamily("colors"));
        request.getTags().add(((TagReference)new TagReference().setName("bla2")).setTagFamily("basic"));
        request.getTags().add(((TagReference)new TagReference().setName("blub3")).setTagFamily("colors"));
        request.getTags().add(((TagReference)new TagReference().setName("bla4")).setTagFamily("basic"));
        TagListResponse response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        MeshAssertions.assertThat((TagListResponse)response).containsExactly(new String[]{"blub1", "bla2", "blub3", "bla4"});
        request.getTags().clear();
        request.getTags().add(((TagReference)new TagReference().setName("bla2")).setTagFamily("basic"));
        request.getTags().add(((TagReference)new TagReference().setName("blub3")).setTagFamily("colors"));
        response = (TagListResponse)ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]));
        MeshAssertions.assertThat((TagListResponse)response).containsExactly(new String[]{"bla2", "blub3"});
    }

    @Test
    public void testUpdateWithNoNodePerm() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.content(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("blub1")).setTagFamily("colors"));
        ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
    }

    @Test
    public void testUpdateWithNoTagFamilyCreatePerm() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tagFamily("colors"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String nodeUuid = (String)this.tx(() -> this.content().getUuid());
        TagListUpdateRequest request = new TagListUpdateRequest();
        request.getTags().add(((TagReference)new TagReference().setName("blub1")).setTagFamily("colors"));
        ClientHelper.call(() -> this.client().updateTagsForNode("dummy", nodeUuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"tag_error_missing_perm_on_tag_family", (String[])new String[]{"colors", tagFamilyUuid, "blub1"});
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
    }
}

