/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.NodeMeshEventModelAssert;
import com.gentics.mesh.assertj.impl.PublishStatusModelAssert;
import com.gentics.mesh.assertj.impl.PublishStatusResponseAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.PublishStatusModel;
import com.gentics.mesh.core.rest.node.PublishStatusResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeTakeOfflineEndpointTest
extends AbstractMeshTest {
    @Test
    public void testTakeNodeOfflineManyChildren() throws Exception {
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String folderSchemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String contentSchemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        for (int i = 0; i < 1000; ++i) {
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("content");
            schemaReference.setUuid(schemaUuid);
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page" + i + ".html")));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setLanguage("en");
            request.setSchema((SchemaReference)schemaReference);
            request.setParentNodeUuid(parentNodeUuid);
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", response.getUuid(), new ParameterProvider[0]));
        }
        this.expect(MeshEvent.NODE_UNPUBLISHED).match(1029, NodeMeshEventModel.class, event -> {
            ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).uuidNotNull()).hasBranchUuid(this.initialBranchUuid());
            MeshAssertions.assertThat((String)event.getSchema().getUuid()).matches((CharSequence)(contentSchemaUuid + "|" + folderSchemaUuid));
            MeshAssertions.assertThat((String)event.getLanguageTag()).matches((CharSequence)"en|de");
            MeshAssertions.assertThat((String)event.getSchema().getName()).matches((CharSequence)"folder|content");
        }).total(1029L);
        this.expect(MeshEvent.NODE_DELETED).none();
        this.expect(MeshEvent.NODE_CONTENT_DELETED).none();
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.awaitEvents();
    }

    @Test
    public void testTakeNodeOffline() {
        HibNode node = this.folder("products");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        this.expect(MeshEvent.NODE_UNPUBLISHED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(baseNodeUuid)).hasSchema("folder", schemaUuid).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasProject("dummy", this.projectUuid()));
        this.expect(MeshEvent.NODE_UNPUBLISHED).total(29L);
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        this.awaitEvents();
        this.expect(MeshEvent.NODE_PUBLISHED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(nodeUuid)).hasSchema("folder", schemaUuid).hasBranchUuid(this.initialBranchUuid()).hasLanguage("de").hasProject("dummy", this.projectUuid()));
        this.expect(MeshEvent.NODE_PUBLISHED).match(1, NodeMeshEventModel.class, event -> ((NodeMeshEventModelAssert)MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(nodeUuid)).hasSchema("folder", schemaUuid).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasProject("dummy", this.projectUuid()));
        this.expect(MeshEvent.NODE_PUBLISHED).total(2L);
        ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish Status", new Object[0])).isPublished("en").isPublished("de");
        this.awaitEvents();
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en").isNotPublished("de");
    }

    @Test
    public void testTakeNodeLanguageOffline() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish Status", new Object[0])).isPublished("en").isPublished("de");
            ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "en", new ParameterProvider[0]));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en");
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en").isPublished("de");
            ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "de", new ParameterProvider[0]));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("de");
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en").isNotPublished("de");
        }
    }

    @Test
    public void testTakeNodeOfflineNoPermission() {
        String nodeUuid;
        HibNode node;
        try (Tx tx2 = this.tx();){
            node = this.folder("products");
            nodeUuid = node.getUuid();
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish Status", new Object[0])).isPublished("en").isPublished("de");
        }
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.PUBLISH_PERM});
            return null;
        });
        this.tx(() -> ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.PUBLISH_PERM.getRestPerm().getName()}));
    }

    @Test
    public void testTakeNodeLanguageOfflineNoPermission() {
        String nodeUuid;
        HibNode node;
        try (Tx tx2 = this.tx();){
            node = this.folder("products");
            nodeUuid = node.getUuid();
        }
        ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish Status", new Object[0])).isPublished("en").isPublished("de");
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.PUBLISH_PERM});
        });
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{nodeUuid, InternalPermission.PUBLISH_PERM.getRestPerm().getName()});
    }

    @Test
    public void testTakeOfflineNodeOffline() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en").isNotPublished("de");
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", nodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", nodeUuid, new ParameterProvider[0])))).as("Publish status", new Object[0])).isNotPublished("en").isNotPublished("de");
        }
    }

    @Test
    public void testTakeOfflineNodeLanguageOffline() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            String nodeUuid = node.getUuid();
            ((PublishStatusModelAssert)MeshAssertions.assertThat((PublishStatusModel)((PublishStatusModel)ClientHelper.call(() -> this.client().publishNodeLanguage("dummy", nodeUuid, "en", new ParameterProvider[0])))).as("Initial publish status", new Object[0])).isPublished();
            ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "de", new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "de", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_language_not_found", (String[])new String[]{"de"});
        }
    }

    @Test
    public void testTakeOfflineBogusUuid() {
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", "bogus", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testTakeOfflineEmptyLanguage() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("products");
            String nodeUuid = node.getUuid();
            ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", nodeUuid, "fr", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_language_not_found", (String[])new String[]{"fr"});
        }
    }

    @Test
    public void testTakeOfflineWithOnlineChild() {
        try (Tx tx = this.tx();){
            HibNode news = this.folder("news");
            HibNode news2015 = this.folder("2015");
            ClientHelper.call(() -> this.client().publishNode("dummy", news.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", news2015.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", news.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_children_containers_still_published", (String[])new String[0]);
        }
    }

    @Test
    public void testTakeOfflineLastLanguageWithOnlineChild() {
        String newsUuid = (String)this.db().tx(() -> this.folder("news").getUuid());
        String news2015Uuid = (String)this.db().tx(() -> this.folder("2015").getUuid());
        ClientHelper.call(() -> this.client().publishNode("dummy", newsUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", news2015Uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", newsUuid, "de", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", newsUuid, "en", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_children_containers_still_published", (String[])new String[]{news2015Uuid});
    }

    @Test
    public void testTakeOfflineForBranch() {
        HibNode news = this.folder("news");
        HibBranch initialBranch = (HibBranch)this.db().tx(() -> this.latestBranch());
        HibBranch newBranch = this.createBranch("newbranch", true);
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().publishNode("dummy", news.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranch.getName())}));
            ClientHelper.call(() -> this.client().publishNode("dummy", news.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())}));
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", news.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranch.getName()), new PublishParametersImpl().setRecursive(true)}));
        }
        tx = this.tx();
        try {
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", news.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranch.getName())})))).as("Initial branch publish status", new Object[0])).isNotPublished("en").isNotPublished("de");
            ((PublishStatusResponseAssert)MeshAssertions.assertThat((PublishStatusResponse)((PublishStatusResponse)ClientHelper.call(() -> this.client().getNodePublishStatus("dummy", news.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setBranch(newBranch.getName())})))).as("New branch publish status", new Object[0])).isPublished("en").isPublished("de");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testTakeNodeOfflineConsistency() {
        this.db().tx(() -> {
            System.out.println(this.project().getBaseNode().getUuid());
            System.out.println(this.folder("news").getUuid());
            System.out.println(this.folder("2015").getUuid());
            return null;
        });
        this.db().tx(() -> {
            HibNode node = this.folder("news");
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", node.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_children_containers_still_published", (String[])new String[0]);
            return null;
        });
        this.db().tx(() -> {
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.content("news overview").getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(false)}));
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", this.folder("2014").getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
            return null;
        });
        this.db().tx(() -> {
            HibNode node = this.folder("news");
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", node.getUuid(), new ParameterProvider[0]));
            return null;
        });
    }
}

