/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.NodeAssert;
import com.gentics.mesh.assertj.impl.NodeResponseAssert;
import com.gentics.mesh.context.BranchMigrationContext;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.BranchMigrationContextImpl;
import com.gentics.mesh.context.impl.DummyBulkActionContext;
import com.gentics.mesh.context.impl.LocalActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingNodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.RootDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.data.user.MeshAuthUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.SortOrder;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.handler.ActionContext;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.test.util.TestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.content();
            InternalActionContext ac = this.mockActionContext("?version=draft");
            NodeReference reference = tx.nodeDao().transformToReference(node, ac);
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)node.getUuid(), (Object)reference.getUuid());
        }
    }

    @Test
    public void testGetPath() throws Exception {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            ContentDao contentDao = tx.contentDao();
            HibNode newsNode = this.content("news overview");
            InternalActionContext ac = this.mockActionContext();
            String path = nodeDao.getPath(newsNode, (ActionContext)ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, new String[]{this.english()});
            Assert.assertEquals((Object)"/News/News%20Overview.en.html", (Object)path);
            String pathSegementFieldValue = contentDao.getPathSegment(newsNode, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, new String[]{this.english()});
            Assert.assertEquals((Object)"News Overview.en.html", (Object)pathSegementFieldValue);
        }
    }

    @Test
    public void testMeshNodeStructure() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            HibNode newsNode = this.content("news overview");
            Assert.assertNotNull((Object)newsNode);
            HibNode newSubNode = nodeDao.create(newsNode, this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), this.project());
            Assert.assertEquals((long)1L, (long)TestUtils.size((Iterable)nodeDao.getChildren(newsNode)));
            HibNode firstChild = (HibNode)nodeDao.getChildren(newsNode).iterator().next();
            Assert.assertEquals((Object)newSubNode.getUuid(), (Object)firstChild.getUuid());
        }
    }

    @Test
    public void testTaggingOfMeshNode() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibNode newsNode = this.content("news overview");
            Assert.assertNotNull((Object)newsNode);
            HibTag carTag = this.tag("car");
            Assert.assertNotNull((Object)carTag);
            tagDao.addTag(newsNode, carTag, this.project().getLatestBranch());
            Assert.assertEquals((long)1L, (long)tagDao.getTags(newsNode, this.project().getLatestBranch()).count());
            HibTag firstTag = (HibTag)tagDao.getTags(newsNode, this.project().getLatestBranch()).iterator().next();
            Assert.assertEquals((Object)carTag.getUuid(), (Object)firstTag.getUuid());
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            InternalActionContext ac = this.mockActionContext("version=draft");
            Page page = nodeDao.findAll((HibCoreElement)this.project(), ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10L)));
            Assert.assertEquals((long)this.getNodeCount(), (long)page.getTotalElements());
            Assert.assertEquals((long)10L, (long)page.getSize());
            page = nodeDao.findAll((HibCoreElement)this.project(), ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(15L)));
            Assert.assertEquals((long)this.getNodeCount(), (long)page.getTotalElements());
            Assert.assertEquals((long)15L, (long)page.getSize());
        }
    }

    @Test
    public void testMeshNodeFields() throws IOException {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            NodeDao nodeDao = tx.nodeDao();
            HibNode newsNode = this.content("news overview");
            String german = this.german();
            InternalActionContext ac = this.mockActionContext("lang=de,en&version=draft");
            MeshAssertions.assertThat((Object[])ac.getNodeParameters().getLanguages()).containsExactly((Object[])new String[]{"de", "en"});
            HibNodeFieldContainer germanFields = contentDao.getLatestDraftFieldContainer(newsNode, german);
            String expectedDisplayName = germanFields.getString(((HibSchemaVersion)newsNode.getSchemaContainer().getLatestVersion()).getSchema().getDisplayField()).getString();
            Assert.assertEquals((String)"The display name value did not match up", (Object)expectedDisplayName, (Object)nodeDao.getDisplayName(newsNode, ac));
        }
    }

    @Override
    @Test
    @Ignore(value="No need to cover this by test")
    public void testFindAllVisible() throws InvalidArgumentException {
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibNode root = project.getBaseNode();
            Assert.assertNotNull((Object)root);
        }
    }

    @Override
    @Test
    @Ignore(value="nodes can not be located using the name")
    public void testFindByName() {
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            HibNode node = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), newsNode.getUuid());
            Assert.assertNotNull((Object)node);
            Assert.assertEquals((Object)newsNode.getUuid(), (Object)node.getUuid());
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            InternalActionContext ac = this.mockActionContext("lang=en&version=draft");
            HibNode newsNode = this.content("concorde");
            NodeResponse response = (NodeResponse)nodeDao.transformToRestSync((Object)newsNode, ac, 0, new String[0]);
            String json = response.toJson();
            Assert.assertNotNull((Object)json);
            NodeResponse deserialized = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)deserialized);
            ((NodeResponseAssert)MeshAssertions.assertThat((NodeResponse)deserialized).as("node response", new Object[0])).hasVersion("1.0");
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)deserialized.getCreator()).as("Creator", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)deserialized.getCreated()).as("Created", new Object[0])).isNotEqualTo((Object)0);
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)deserialized.getEditor()).as("Editor", new Object[0])).isNotNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)deserialized.getEdited()).as("Edited", new Object[0])).isNotEqualTo((Object)0);
        }
    }

    @Override
    @Test
    public void testCreateDelete() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            HibNode folder = this.folder("2015");
            HibNode subNode = nodeDao.create(folder, this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), this.project());
            Assert.assertNotNull((Object)subNode.getUuid());
            BulkActionContext context = this.createBulkContext();
            InternalActionContext ac = this.mockActionContext("");
            tx.nodeDao().deleteFromBranch(subNode, ac, this.project().getLatestBranch(), context, false);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            UserDao userDao = tx.userDao();
            HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), this.project());
            InternalActionContext ac = this.mockActionContext("");
            Assert.assertFalse((boolean)userDao.hasPermission(this.user(), (HibBaseElement)node, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(this.user(), (HibBaseElement)this.folder("2015"), (HibBaseElement)node);
            ac.data().clear();
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)node, InternalPermission.CREATE_PERM));
        }
    }

    @Override
    @Test
    public void testRead() throws IOException {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            Assert.assertEquals((Object)"folder", (Object)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema().getName());
            Assert.assertTrue((boolean)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema().getContainer());
            HibNodeFieldContainer englishVersion = tx.contentDao().getFieldContainer(node, "en");
            Assert.assertNotNull((Object)englishVersion);
        }
    }

    @Override
    @Test
    public void testCreate() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            NodeDao nodeDao = tx.nodeDao();
            HibUser user = this.user();
            HibNode parentNode = this.folder("2015");
            HibSchemaVersion schemaVersion = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            HibNode node = nodeDao.create(parentNode, user, schemaVersion, this.project());
            long ts = System.currentTimeMillis();
            node.setCreationTimestamp(ts);
            Long creationTimeStamp = node.getCreationTimestamp();
            Assert.assertNotNull((Object)creationTimeStamp);
            Assert.assertEquals((long)ts, (long)creationTimeStamp);
            Assert.assertEquals((Object)user.getUuid(), (Object)node.getCreator().getUuid());
            String english = this.english();
            String german = this.german();
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, english, node.getProject().getLatestBranch(), user);
            schemaVersion.getSchema().addField((FieldSchema)new StringFieldSchemaImpl().setName("name"));
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)schemaVersion);
            englishContainer.createHTML("content").setHtml("english content");
            englishContainer.createString("name").setString("english.html");
            Assert.assertNotNull((Object)node.getUuid());
            Assert.assertEquals((Object)user.getUuid(), (Object)englishContainer.getEditor().getUuid());
            Assert.assertNotNull((Object)englishContainer.getLastEditedTimestamp());
            List allProperties = TestUtils.toList((Iterable)contentDao.getDraftFieldContainers(node));
            Assert.assertNotNull((Object)allProperties);
            Assert.assertEquals((long)1L, (long)allProperties.size());
            HibNodeFieldContainer germanContainer = tx.contentDao().createFieldContainer(node, german, node.getProject().getLatestBranch(), user);
            germanContainer.createHTML("content").setHtml("german content");
            Assert.assertEquals((long)2L, (long)TestUtils.size((Iterable)contentDao.getDraftFieldContainers(node)));
            HibNodeFieldContainer container = contentDao.getLatestDraftFieldContainer(node, english);
            Assert.assertNotNull((Object)container);
            String text = container.getHtml("content").getHTML();
            Assert.assertNotNull((Object)text);
            Assert.assertEquals((Object)"english content", (Object)text);
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = Tx.get().nodeDao().findByUuidGlobal(this.folder("news").getUuid());
            String uuid = node.getUuid();
            MeshAssert.assertElement((RootDao)tx.nodeDao(), (HibCoreElement)this.project(), (String)uuid, (boolean)true);
            InternalActionContext ac = this.mockActionContext("");
            ac.getDeleteParameters().setRecursive(true);
            try (Tx tx2 = this.tx();){
                tx.nodeDao().deleteFromBranch(node, ac, this.project().getLatestBranch(), this.createBulkContext(), false);
                tx2.success();
            }
            MeshAssert.assertElement((RootDao)tx.nodeDao(), (HibCoreElement)this.project(), (String)uuid, (boolean)false);
        }
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            HibNode node = this.content();
            try (Tx tx2 = this.tx();){
                UserDao userDao = tx2.userDao();
                HibUser newUser = userDao.create("newUser", this.user());
                userDao.addGroup(newUser, this.group());
                Assert.assertEquals((Object)this.user().getUuid(), (Object)node.getCreator().getUuid());
                System.out.println(newUser.getUuid());
                node.setCreator(newUser);
                System.out.println(node.getCreator().getUuid());
                Assert.assertEquals((Object)newUser.getUuid(), (Object)node.getCreator().getUuid());
            }
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)this.content());
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)this.content());
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)this.content());
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)this.content());
        }
    }

    @Test
    public void testDeleteWithChildren() {
        BulkActionContext bac = this.createBulkContext();
        AtomicReference folderUuid = new AtomicReference();
        AtomicReference subFolderUuid = new AtomicReference();
        AtomicReference subSubFolderUuid = new AtomicReference();
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibSchemaVersion folderSchema = (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion();
            HibNode folder = nodeDao.create(project.getBaseNode(), this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("Folder");
            folderUuid.set(folder.getUuid());
            HibNode subFolder = nodeDao.create(folder, this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(subFolder, this.english(), initialBranch, this.user()).createString("name").setString("SubFolder");
            subFolderUuid.set(subFolder.getUuid());
            HibNode subSubFolder = nodeDao.create(subFolder, this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(subSubFolder, this.english(), initialBranch, this.user()).createString("name").setString("SubSubFolder");
            subSubFolderUuid.set(subSubFolder.getUuid());
        });
        this.tx(tx -> {
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibNode subFolder = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)project, (String)subFolderUuid.get());
            InternalActionContext ac = this.mockActionContext("");
            ac.getDeleteParameters().setRecursive(true);
            tx.nodeDao().deleteFromBranch(subFolder, ac, initialBranch, bac, false);
        });
        this.tx(tx -> {
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibNode folder = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)project, (String)folderUuid.get());
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasNoChildren(initialBranch);
            List nodeUuids = tx.nodeDao().findAll((HibCoreElement)project).stream().map(HibElement::getUuid).collect(Collectors.toList());
            ((AbstractListAssert)MeshAssertions.assertThat(nodeUuids).as("All nodes", new Object[0]).contains((Object[])new String[]{(String)folderUuid.get()})).doesNotContain((Object[])new String[]{(String)subFolderUuid.get(), (String)subSubFolderUuid.get()});
        });
    }

    @Test
    public void testDeleteWithChildrenInBranch() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            HibBranch initialBranch = this.reloadBranch(this.initialBranch());
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            HibSchemaVersion folderSchema = (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion();
            HibNode folder = nodeDao.create(project.getBaseNode(), this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("Folder");
            HibNode subFolder = nodeDao.create(folder, this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(subFolder, this.english(), initialBranch, this.user()).createString("name").setString("SubFolder");
            String subFolderUuid = subFolder.getUuid();
            HibNode subSubFolder = nodeDao.create(subFolder, this.user(), folderSchema, project);
            tx.contentDao().createFieldContainer(subSubFolder, this.english(), initialBranch, this.user()).createString("name").setString("SubSubFolder");
            String subSubFolderUuid = subSubFolder.getUuid();
            HibBranch newBranch = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(initialBranch);
            this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasOnlyChildren(newBranch, new HibNode[]{subFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subFolder).as("subFolder", new Object[0])).hasOnlyChildren(newBranch, new HibNode[]{subSubFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subSubFolder).as("subSubFolder", new Object[0])).hasNoChildren(newBranch);
            EventQueueBatch batch = this.createBatch();
            nodeDao.moveTo(subSubFolder, this.mockActionContext(), folder, batch);
            nodeDao.moveTo(subFolder, this.mockActionContext(), subSubFolder, batch);
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasChildren(newBranch, new HibNode[]{subSubFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subSubFolder).as("subSubFolder", new Object[0])).hasChildren(newBranch, new HibNode[]{subFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subFolder).as("subFolder", new Object[0])).hasNoChildren(newBranch);
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasChildren(initialBranch, new HibNode[]{subFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subFolder).as("subFolder", new Object[0])).hasChildren(initialBranch, new HibNode[]{subSubFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subSubFolder).as("subSubFolder", new Object[0])).hasNoChildren(initialBranch);
            InternalActionContext ac = this.mockActionContext("");
            ac.getDeleteParameters().setRecursive(true);
            tx.nodeDao().deleteFromBranch(subFolder, ac, initialBranch, bac, false);
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasChildren(newBranch, new HibNode[]{subSubFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subSubFolder).as("subSubFolder", new Object[0])).hasChildren(newBranch, new HibNode[]{subFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)subFolder).as("subFolder", new Object[0])).hasNoChildren(newBranch);
            ArrayList nodes = new ArrayList();
            nodeDao.findAll((HibCoreElement)project, this.mockActionContext("release=" + initialBranch.getName()), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10000L))).forEach(node -> nodes.add(node));
            ((AbstractListAssert)MeshAssertions.assertThat(nodes).as("Nodes in initial branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).doesNotContain((Object[])new HibNode[]{subFolder, subSubFolder});
            ((NodeAssert)MeshAssertions.assertThat((HibNode)folder).as("folder", new Object[0])).hasNoChildren(initialBranch);
        }
    }

    @Test
    public void testDeletePublished() throws InvalidArgumentException {
        HibProject project = this.project();
        BulkActionContext bac = this.createBulkContext();
        try (Tx tx = this.tx();){
            HibBranch initialBranch = this.reloadBranch(this.initialBranch());
            HibSchemaVersion folderSchema = (HibSchemaVersion)((HibSchema)Tx.get().schemaDao().findByUuid(this.schemaContainer("folder").getUuid())).getLatestVersion();
            String folderUuid = (String)this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                RoleDao roleDao = tx2.roleDao();
                HibNode folder = nodeDao.create(project.getBaseNode(), this.user(), folderSchema, project);
                BulkActionContext bac2 = this.createBulkContext();
                tx2.roleDao().grantPermissions(this.role(), (HibBaseElement)folder, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM});
                tx.contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("Folder");
                nodeDao.publish(folder, this.mockActionContext(), bac2);
                Assert.assertEquals((long)1L, (long)bac2.batch().size());
                return folder.getUuid();
            });
            this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                ArrayList nodeUuids = new ArrayList();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=draft"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Draft nodes", new Object[0]).contains((Object[])new String[]{folderUuid});
                nodeUuids.clear();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=published"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Published nodes", new Object[0]).contains((Object[])new String[]{folderUuid});
            });
            InternalActionContext ac = this.mockActionContext("");
            this.tx(tx2 -> tx2.nodeDao().deleteFromBranch((HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), folderUuid), ac, initialBranch, bac, false));
            this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                ArrayList nodeUuids = new ArrayList();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=draft"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Draft nodes", new Object[0]).doesNotContain((Object[])new String[]{folderUuid});
                nodeUuids.clear();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=published"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Published nodes", new Object[0]).doesNotContain((Object[])new String[]{folderUuid});
            });
        }
    }

    @Test
    public void testDeletePublishedFromBranch() {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibSchemaVersion folderSchema = (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion();
            String folderUuid = (String)this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                HibNode folder = nodeDao.create(project.getBaseNode(), this.user(), folderSchema, project);
                BulkActionContext bac = this.createBulkContext();
                RoleDao roleDao = tx.roleDao();
                tx2.roleDao().grantPermissions(this.role(), (HibBaseElement)folder, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM});
                tx.contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("Folder");
                nodeDao.publish(folder, this.mockActionContext(), bac);
                return folder.getUuid();
            });
            HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
            this.mesh().branchCache().clear();
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(initialBranch);
            this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
            InternalActionContext ac = this.mockActionContext("");
            this.tx(() -> tx.nodeDao().deleteFromBranch((HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), folderUuid), ac, initialBranch, this.createBulkContext(), false));
            this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                ArrayList nodeUuids = new ArrayList();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=draft&branch=" + initialBranch.getUuid()), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Draft nodes", new Object[0]).doesNotContain((Object[])new String[]{folderUuid});
                nodeUuids.clear();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=published&branch=" + initialBranch.getUuid()), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Published nodes", new Object[0]).doesNotContain((Object[])new String[]{folderUuid});
            });
            this.tx(tx2 -> {
                NodeDao nodeDao = tx2.nodeDao();
                ArrayList nodeUuids = new ArrayList();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=draft"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Draft nodes", new Object[0]).contains((Object[])new String[]{folderUuid});
                nodeUuids.clear();
                nodeDao.findAll((HibCoreElement)project, this.mockActionContext("version=published"), (PagingParameters)new PagingParametersImpl(1L, Long.valueOf(10000L), null, SortOrder.UNSORTED)).forEach(node -> nodeUuids.add(node.getUuid()));
                MeshAssertions.assertThat(nodeUuids).as("Published nodes", new Object[0]).contains((Object[])new String[]{folderUuid});
            });
        }
    }

    @Test
    public void testDeletePublishedFromBranch2() {
        HibProject project = this.project();
        HibBranch initialBranch = (HibBranch)this.tx(() -> project.getInitialBranch());
        HibSchemaVersion folderSchema = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)this.schemaContainer("folder").getLatestVersion());
        PersistingNodeDao nodeDao = (PersistingNodeDao)this.tx(() -> CommonTx.get().nodeDao());
        HibNode node = (HibNode)this.tx(tx -> {
            HibNode folder = nodeDao.create(project.getBaseNode(), this.user(), folderSchema, project);
            this.tx().contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("1");
            this.tx().contentDao().createFieldContainer(folder, this.english(), initialBranch, this.user()).createString("name").setString("2");
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)folder, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM});
            return folder;
        });
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
        this.mesh().branchCache().clear();
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setNewBranch(newBranch);
        context.setOldBranch(initialBranch);
        this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
        this.tx(tx -> {
            HibNode reAttachedNode = (HibNode)nodeDao.mergeIntoPersisted((HibCoreElement)project, (HibCoreElement)node);
            this.tx().contentDao().createFieldContainer(reAttachedNode, this.english(), initialBranch, this.user()).createString("name").setString("3");
            this.tx().contentDao().createFieldContainer(reAttachedNode, this.english(), initialBranch, this.user()).createString("name").setString("4");
        });
        this.tx(() -> this.assertVersions(node.getUuid(), "en", "D(0.4)=>(0.3)=>I(0.2)=>I(0.1)", initialBranch.getName()));
        this.tx(tx -> {
            HibNode reAttachedNode = nodeDao.findByUuidGlobal(node.getUuid());
            this.tx().contentDao().createFieldContainer(reAttachedNode, this.english(), newBranch, this.user()).createString("name").setString("3");
            this.tx().contentDao().createFieldContainer(reAttachedNode, this.english(), newBranch, this.user()).createString("name").setString("4");
            this.tx().contentDao().createFieldContainer(reAttachedNode, this.english(), newBranch, this.user()).createString("name").setString("5");
            return node.getUuid();
        });
        this.tx(() -> this.assertVersions(node.getUuid(), "en", "D(0.5)=>(0.4)=>(0.3)=>I(0.2)=>I(0.1)", newBranch.getName()));
        this.tx(tx -> {
            HibNode reAttachedNode = nodeDao.findByUuidGlobal(node.getUuid());
            tx.nodeDao().deleteFromBranch(reAttachedNode, this.mockActionContext(""), newBranch, (BulkActionContext)new DummyBulkActionContext(), true);
        });
        this.tx(() -> this.assertVersions(node.getUuid(), "en", "D(0.4)=>(0.3)=>(0.2)=>I(0.1)", initialBranch.getName()));
        this.tx(() -> this.assertVersions(node.getUuid(), "en", "", newBranch.getName()));
    }

    @Test
    public void testGetChildrenStream() {
        String initialBranchUuid = (String)this.tx(() -> this.project().getInitialBranch().getUuid());
        String newsFolderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.createChild(newsFolderUuid, "in both branches", initialBranchUuid, new InternalPermission[0]);
        String newBranchUuid = (String)this.tx(() -> {
            HibBranch newBranch = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(newBranch.getPreviousBranch());
            this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
            return newBranch.getUuid();
        });
        this.createChild(newsFolderUuid, "in initial branch", initialBranchUuid, new InternalPermission[0]);
        this.createChild(newsFolderUuid, "in initial branch - no read", initialBranchUuid, InternalPermission.READ_PERM);
        this.createChild(newsFolderUuid, "in initial branch - no read_published", initialBranchUuid, InternalPermission.READ_PUBLISHED_PERM);
        this.createChild(newsFolderUuid, "in initial branch - no read, read_published", initialBranchUuid, InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM);
        this.createChild(newsFolderUuid, "in new branch", newBranchUuid, new InternalPermission[0]);
        this.createChild(newsFolderUuid, "in new branch - no read", newBranchUuid, InternalPermission.READ_PERM);
        this.createChild(newsFolderUuid, "in new branch - no read_published", newBranchUuid, InternalPermission.READ_PUBLISHED_PERM);
        this.createChild(newsFolderUuid, "in new branch - no read, read_published", newBranchUuid, InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM);
        ((AbstractListAssert)MeshAssertions.assertThat(this.getChildrenNames(initialBranchUuid)).as("Children in initial branch", new Object[0]).doesNotHaveDuplicates()).containsOnly((Object[])new String[]{"2014", "2015", "News Overview english title", "in both branches", "in initial branch", "in initial branch - no read", "in initial branch - no read_published"});
        ((AbstractListAssert)MeshAssertions.assertThat(this.getChildrenNames(newBranchUuid)).as("Children in new branch", new Object[0]).doesNotHaveDuplicates()).containsOnly((Object[])new String[]{"2014", "2015", "News Overview english title", "in both branches", "in new branch", "in new branch - no read", "in new branch - no read_published"});
        this.grantAdmin();
        ((AbstractListAssert)MeshAssertions.assertThat(this.getChildrenNames(initialBranchUuid)).as("Children in initial branch for admin", new Object[0]).doesNotHaveDuplicates()).containsOnly((Object[])new String[]{"2014", "2015", "News Overview english title", "in both branches", "in initial branch", "in initial branch - no read", "in initial branch - no read_published", "in initial branch - no read, read_published"});
        ((AbstractListAssert)MeshAssertions.assertThat(this.getChildrenNames(newBranchUuid)).as("Children in new branch for admin", new Object[0]).doesNotHaveDuplicates()).containsOnly((Object[])new String[]{"2014", "2015", "News Overview english title", "in both branches", "in new branch", "in new branch - no read", "in new branch - no read_published", "in new branch - no read, read_published"});
    }

    protected List<String> getChildrenNames(String branchUuid) {
        return (List)this.tx(tx -> {
            MeshAuthUser user = tx.userDao().findMeshAuthUserByUsername(this.user().getUsername());
            LocalActionContextImpl ac = new LocalActionContextImpl(this.boot(), user, RoleResponse.class, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid)});
            ac.setProject(this.project().getName());
            return tx.nodeDao().getChildrenStream(this.folder("news"), (InternalActionContext)ac, InternalPermission.READ_PUBLISHED_PERM).map(node -> Tx.get().nodeDao().getDisplayName(node, (InternalActionContext)ac)).collect(Collectors.toList());
        });
    }

    protected void createChild(String parentUuid, String name, String branchUuid, InternalPermission ... revoke) {
        String projectName = (String)this.tx(() -> this.project().getName());
        String nodeUuid = ((NodeResponse)ClientHelper.call(() -> {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest().setParentNode(new NodeReference().setUuid(parentUuid)).setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder")).setLanguage("en");
            nodeCreateRequest.getFields().put("name", (Field)new StringFieldImpl().setString(name));
            return this.client().createNode(projectName, nodeCreateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branchUuid)});
        })).getUuid();
        if (revoke.length > 0) {
            this.tx(tx -> {
                RoleDao roleDao = tx.roleDao();
                HibNode node = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)this.project(), nodeUuid);
                for (InternalPermission perm : revoke) {
                    roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{perm});
                }
            });
        }
    }
}

