/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BranchMigrationContext;
import com.gentics.mesh.context.impl.BranchMigrationContextImpl;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NodeWebRootConflictEndpointTest
extends AbstractMeshTest {
    @Test
    public void testDuplicateDueMove() {
        String conflictingName = "conflictName";
        try (Tx trx = this.tx();){
            HibNode folderA = this.folder("2014");
            NodeCreateRequest requestA = new NodeCreateRequest();
            requestA.setLanguage("en");
            requestA.setParentNodeUuid(folderA.getUuid());
            requestA.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            requestA.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"nodeA"));
            requestA.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            NodeResponse nodeA = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", requestA, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", nodeA.getUuid(), new ParameterProvider[0]));
            HibNode folderB = this.folder("2015");
            NodeCreateRequest requestB = new NodeCreateRequest();
            requestB.setLanguage("en");
            requestB.setParentNodeUuid(folderB.getUuid());
            requestB.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            requestB.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"nodeB"));
            requestB.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            NodeResponse nodeB = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", requestB, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().publishNode("dummy", nodeB.getUuid(), new ParameterProvider[0]));
            NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
            nodeUpdateRequest.setVersion(nodeB.getVersion());
            nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"nodeB"));
            nodeUpdateRequest.setLanguage("en");
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeB.getUuid(), nodeUpdateRequest, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().moveNode("dummy", nodeB.getUuid(), folderA.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_move", (String[])new String[]{"slug", conflictingName});
        }
    }

    @Test
    public void testCreateDuplicateWebrootPath() {
        String conflictingName = "filename.html";
        HibNode parent = (HibNode)this.tx(() -> this.folder("2015"));
        HibSchema contentSchema = (HibSchema)this.tx(() -> this.schemaContainer("content"));
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(parent.getUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
            create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
            ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
            NodeCreateRequest create2 = new NodeCreateRequest();
            create2.setParentNodeUuid(parent.getUuid());
            create2.setLanguage("en");
            create2.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some other title"));
            create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some other name"));
            create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"slug", conflictingName});
            return null;
        });
    }

    @Test
    public void testCreateCaseSensitivityOfWebrootPath() {
        String conflictingName = "filename.html";
        HibNode parent = (HibNode)this.tx(() -> this.folder("2015"));
        HibSchema contentSchema = (HibSchema)this.tx(() -> this.schemaContainer("content"));
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(parent.getUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
            create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
            NodeResponse response1 = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
            NodeCreateRequest create2 = new NodeCreateRequest();
            create2.setParentNodeUuid(parent.getUuid());
            create2.setLanguage("en");
            create2.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some other title"));
            create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some other name"));
            create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName.toUpperCase()));
            create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            NodeResponse response2 = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]));
            MeshWebrootResponse webrootResponse1 = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/News/2015/" + conflictingName, new ParameterProvider[0]));
            Assertions.assertThat((Object)webrootResponse1.getNodeResponse()).isEqualTo((Object)response1);
            MeshWebrootResponse webrootResponse2 = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/News/2015/" + conflictingName.toUpperCase(), new ParameterProvider[0]));
            Assertions.assertThat((Object)webrootResponse2.getNodeResponse()).isEqualTo((Object)response2);
        });
    }

    @Test
    public void testUpdateDuplicateWebrootPath() {
        String conflictingName = "filename.html";
        String nonConflictingName = "otherfilename.html";
        HibNode parent = (HibNode)this.tx(() -> this.folder("2015"));
        HibSchema contentSchema = (HibSchema)this.tx(() -> this.schemaContainer("content"));
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(parent.getUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
            create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
            NodeCreateRequest create2 = new NodeCreateRequest();
            create2.setParentNodeUuid(parent.getUuid());
            create2.setLanguage("en");
            create2.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some name"));
            create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)nonConflictingName));
            create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
            response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]));
            String uuid = response.getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("en");
            update.setVersion("0.1");
            update.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, update, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"slug", conflictingName});
            return null;
        });
    }

    @Test
    public void testTranslateDuplicateWebrootPath() {
        String conflictingName = "filename.html";
        HibNode parent = (HibNode)this.tx(() -> this.folder("2015"));
        HibSchema contentSchema = (HibSchema)this.tx(() -> this.schemaContainer("content"));
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(parent.getUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName())).setUuid(contentSchema.getUuid()));
            create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
            create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
            String uuid = ((NodeResponse)this.client().createNode("dummy", create, new ParameterProvider[0]).toSingle().blockingGet()).getUuid();
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("de");
            update.getFields().put("title", (Field)FieldUtil.createStringField((String)"Irgendein Titel"));
            update.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"Irgendein teaser"));
            update.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
            update.getFields().put("content", (Field)FieldUtil.createStringField((String)"Gesegnete Mahlzeit!"));
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, update, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"slug", conflictingName});
            return null;
        });
    }

    @Test
    public void testMoveDuplicateWebrootPath() {
        String conflictingName = "filename.html";
        String parentUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String otherParentUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(parentUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String uuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]))).getUuid();
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(otherParentUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some other title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some other teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().moveNode("dummy", uuid, otherParentUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_move", (String[])new String[]{"slug", conflictingName});
    }

    @Test
    public void testDuplicateCrossBranches() {
        String conflictingName = "filename.html";
        String newBranchName = "newbranch";
        HibBranch initialBranch = (HibBranch)this.tx(() -> this.initialBranch());
        String folderUuid = this.folderUuid();
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch(newBranchName));
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setNewBranch(newBranch);
        context.setOldBranch(initialBranch);
        this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(folderUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
    }

    @Test
    public void testDuplicateCrossBranchesSameNode() {
        String conflictingName = "filename.html";
        String newBranchName = "newbranch";
        HibBranch initialBranch = (HibBranch)this.tx(() -> this.initialBranch());
        String initialBranchUuid = this.initialBranchUuid();
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch(newBranchName));
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setNewBranch(newBranch);
        context.setOldBranch(initialBranch);
        this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(folderUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        ClientHelper.call(() -> this.client().createNode(response.getUuid(), "dummy", create2, new ParameterProvider[]{new VersioningParametersImpl().setBranch(initialBranchUuid)}));
    }

    @Test
    public void testDuplicateCrossBranchesSameNode1() {
        String conflictingName = "filename.html";
        String newBranchName = "newbranch";
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        HibBranch initialBranch = (HibBranch)this.tx(() -> this.initialBranch());
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch(newBranchName));
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setOldBranch(initialBranch);
        context.setNewBranch(newBranch);
        this.meshDagger().branchMigrationHandler().migrateBranch((BranchMigrationContext)context).blockingAwait();
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.initialBranchUuid())}));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(this.folder("2015").getUuid());
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        ClientHelper.call(() -> this.client().createNode(response.getUuid(), "dummy", create2, new ParameterProvider[0]));
    }

    @Test
    public void testDuplicateWithOldVersion() {
        String conflictingName = "filename.html";
        String newName = "changed.html";
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String nodeUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]))).getUuid();
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.setVersion("0.1");
        update.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(folderUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]))).getUuid();
    }

    @Test
    public void testDuplicateWithDrafts() {
        String initialName = "filename.html";
        String conflictingName = "changed.html";
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)initialName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String nodeUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]))).getUuid();
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.setVersion("0.1");
        update.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[0]));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(folderUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)initialName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String otherNodeUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]))).getUuid();
        NodeUpdateRequest update2 = new NodeUpdateRequest();
        update2.setLanguage("en");
        update2.setVersion("0.1");
        update2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        ClientHelper.call(() -> this.client().updateNode("dummy", otherNodeUuid, update2, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"slug", conflictingName});
    }

    @Test
    public void testDuplicateWithPublished() {
        String conflictingName = "filename.html";
        String newName = "changed.html";
        String folderUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeCreateRequest create = new NodeCreateRequest();
        create.setParentNodeUuid(folderUuid);
        create.setLanguage("en");
        create.setSchemaName("content");
        create.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String createdUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create, new ParameterProvider[0]))).getUuid();
        ClientHelper.call(() -> this.client().publishNode("dummy", createdUuid, new ParameterProvider[0]));
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage("en");
        update.setVersion("0.1");
        update.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", createdUuid, update, new ParameterProvider[0]));
        NodeCreateRequest create2 = new NodeCreateRequest();
        create2.setParentNodeUuid(folderUuid);
        create2.setLanguage("en");
        create2.setSchemaName("content");
        create2.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        create2.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        create2.getFields().put("slug", (Field)FieldUtil.createStringField((String)conflictingName));
        create2.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime!"));
        String otherNodeUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", create2, new ParameterProvider[0]))).getUuid();
        ClientHelper.call(() -> this.client().publishNode("dummy", otherNodeUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_publish", (String[])new String[]{"slug", conflictingName});
    }

    @Test
    public void testBinaryNonSegmentFieldBreaksUniquenessNodeApi() {
        SchemaResponse binContentSchema = (SchemaResponse)this.tx(tx -> {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("schema_" + System.currentTimeMillis());
            request.setContainer(Boolean.valueOf(false));
            request.setSegmentField("name");
            StringFieldSchemaImpl nameFieldSchema = new StringFieldSchemaImpl();
            nameFieldSchema.setName("name");
            nameFieldSchema.setLabel("Name");
            request.addField((FieldSchema)nameFieldSchema);
            BinaryFieldSchemaImpl binaryFieldSchema = new BinaryFieldSchemaImpl();
            binaryFieldSchema.setName("binary");
            binaryFieldSchema.setLabel("Binary Data");
            request.addField((FieldSchema)binaryFieldSchema);
            SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
            return schema;
        });
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(this.folderUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(binContentSchema.getName())).setUuid(binContentSchema.getUuid()));
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)"title_12345"));
            NodeResponse node1 = (NodeResponse)this.client().createNode(this.project().getName(), create, new ParameterProvider[0]).toSingle().blockingGet();
            NodeCreateRequest illegalCreate = new NodeCreateRequest();
            illegalCreate.setParentNodeUuid(this.folderUuid());
            illegalCreate.setLanguage("en");
            illegalCreate.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(binContentSchema.getName())).setUuid(binContentSchema.getUuid()));
            illegalCreate.getFields().put("name", (Field)FieldUtil.createStringField((String)"title_12345"));
            ClientHelper.call(() -> this.client().createNode("dummy", illegalCreate, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"name", "title_12345"});
            Buffer buffer = this.getBuffer("/pictures/android-gps.jpg");
            ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node1.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().createNode("dummy", illegalCreate, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"name", "title_12345"});
            ClientHelper.call(() -> this.client().deleteNode("dummy", node1.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().unassignSchemaFromProject("dummy", binContentSchema.getUuid()));
            ClientHelper.call(() -> this.client().deleteSchema(binContentSchema.getUuid()));
        });
    }

    @Test
    public void testBinaryNonSegmentFieldBreaksUniquenessWebrootApi() {
        SchemaResponse binContentSchema = (SchemaResponse)this.tx(tx -> {
            SchemaCreateRequest request = new SchemaCreateRequest();
            request.setName("schema_" + System.currentTimeMillis());
            request.setContainer(Boolean.valueOf(false));
            request.setSegmentField("name");
            StringFieldSchemaImpl nameFieldSchema = new StringFieldSchemaImpl();
            nameFieldSchema.setName("name");
            nameFieldSchema.setLabel("Name");
            request.addField((FieldSchema)nameFieldSchema);
            BinaryFieldSchemaImpl binaryFieldSchema = new BinaryFieldSchemaImpl();
            binaryFieldSchema.setName("binary");
            binaryFieldSchema.setLabel("Binary Data");
            request.addField((FieldSchema)binaryFieldSchema);
            SchemaResponse schema = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schema.getUuid()));
            return schema;
        });
        this.tx(() -> {
            NodeCreateRequest create = new NodeCreateRequest();
            create.setParentNodeUuid(this.folderUuid());
            create.setLanguage("en");
            create.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(binContentSchema.getName())).setUuid(binContentSchema.getUuid()));
            create.getFields().put("name", (Field)FieldUtil.createStringField((String)"title_12345"));
            NodeResponse node1 = (NodeResponse)this.client().webrootCreate("dummy", "/title_12345", create, new ParameterProvider[0]).toSingle().blockingGet();
            NodeCreateRequest illegalCreate = new NodeCreateRequest();
            illegalCreate.setParentNodeUuid(this.folderUuid());
            illegalCreate.setLanguage("en");
            illegalCreate.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName(binContentSchema.getName())).setUuid(binContentSchema.getUuid()));
            illegalCreate.getFields().put("name", (Field)FieldUtil.createStringField((String)"title_12345"));
            ClientHelper.call(() -> this.client().webrootCreate("dummy", "/title_12345", illegalCreate, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"name", "title_12345"});
            Buffer buffer = this.getBuffer("/pictures/android-gps.jpg");
            ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node1.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().webrootCreate("dummy", "/title_12345", illegalCreate, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_update", (String[])new String[]{"name", "title_12345"});
            ClientHelper.call(() -> this.client().deleteNode("dummy", node1.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().unassignSchemaFromProject("dummy", binContentSchema.getUuid()));
            ClientHelper.call(() -> this.client().deleteSchema(binContentSchema.getUuid()));
        });
    }
}

