/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.perm;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.DummyBulkActionContext;
import com.gentics.mesh.context.impl.DummyEventQueueBatch;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.mock.Mocks;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Set;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class PermissionCacheTest
extends AbstractMeshTest {
    @Before
    public void assertCacheEmpty() {
        this.assertPermissions("initialization", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM);
    }

    @Test
    public void testChangePermission() {
        this.db().tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.roleDao().revokePermissions(role, (HibBaseElement)project, new InternalPermission[]{InternalPermission.DELETE_PERM, InternalPermission.UPDATE_PERM});
        });
        this.assertPermissions("revoking permissions", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM);
        this.db().tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.roleDao().grantPermissions(role, (HibBaseElement)project, new InternalPermission[]{InternalPermission.UPDATE_PERM});
        });
        this.assertPermissions("granting permissions", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM);
    }

    @Test
    public void testUserGroupAssignment() {
        this.db().tx(tx -> {
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            tx.groupDao().removeUser(group, user);
        });
        this.assertPermissions("removing user from group", new InternalPermission[0]);
        this.db().tx(tx -> {
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            tx.groupDao().addUser(group, user);
        });
        this.assertPermissions("adding user to group", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM);
    }

    @Test
    public void testGroupRoleAssignment() {
        this.db().tx(tx -> {
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.groupDao().removeRole(group, role);
        });
        this.assertPermissions("removing role from group", new InternalPermission[0]);
        this.db().tx(tx -> {
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.groupDao().addRole(group, role);
        });
        this.assertPermissions("adding role to group", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM);
    }

    @Test
    public void testDeleteRole() {
        this.db().tx(tx -> {
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.roleDao().delete((HibBaseElement)role, (BulkActionContext)new DummyBulkActionContext());
        });
        this.assertPermissions("deleting role", new InternalPermission[0]);
    }

    @Test
    public void testDeleteGroup() {
        this.db().tx(tx -> {
            HibGroup group = (HibGroup)tx.groupDao().findByUuid(this.groupUuid());
            tx.groupDao().delete((HibBaseElement)group, (BulkActionContext)new DummyBulkActionContext());
        });
        this.assertPermissions("deleting group", new InternalPermission[0]);
    }

    @Test
    public void testDeleteUser() {
        String userUuid = (String)this.db().tx(tx -> tx.userDao().create("blub", this.user()).getUuid());
        ((AbstractLongAssert)Assertions.assertThat((long)this.getPermissionCacheSize()).as("Cache size before deleting user", new Object[0])).isEqualTo(1L);
        this.db().tx(tx -> {
            HibUser user = (HibUser)tx.userDao().findByUuid(userUuid);
            tx.userDao().delete((HibBaseElement)user, (BulkActionContext)new DummyBulkActionContext());
        });
        ((AbstractLongAssert)Assertions.assertThat((long)this.getPermissionCacheSize()).as("Cache size after deleting user", new Object[0])).isEqualTo(0L);
    }

    @Test
    public void testGrantAdmin() {
        this.db().tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.roleDao().revokePermissions(role, (HibBaseElement)project, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM});
        });
        this.revokeAdmin();
        this.db().tx(tx -> tx.permissionCache().clear());
        this.assertPermissions("clearing permissions and revoking admin flag", new InternalPermission[0]);
        this.db().tx(tx -> {
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            HibUser admin = tx.userDao().findByUsername("admin");
            UserUpdateRequest request = new UserUpdateRequest();
            request.setAdmin(Boolean.valueOf(true));
            InternalActionContext ac = Mocks.getMockedInternalActionContext("", admin, this.project(), request);
            tx.userDao().update((HibBaseElement)user, ac, (EventQueueBatch)new DummyEventQueueBatch());
        });
        this.assertPermissions("granting admin flag", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM);
    }

    @Test
    public void testRevokeAdmin() {
        this.db().tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            HibRole role = (HibRole)tx.roleDao().findByUuid(this.roleUuid());
            tx.roleDao().revokePermissions(role, (HibBaseElement)project, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM});
        });
        this.grantAdmin();
        this.db().tx(tx -> tx.permissionCache().clear());
        this.assertPermissions("clearing permissions and setting admin flag", InternalPermission.CREATE_PERM, InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM);
        this.db().tx(tx -> {
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            HibUser admin = tx.userDao().findByUsername("admin");
            UserUpdateRequest request = new UserUpdateRequest();
            request.setAdmin(Boolean.valueOf(false));
            InternalActionContext ac = Mocks.getMockedInternalActionContext("", admin, this.project(), request);
            tx.userDao().update((HibBaseElement)user, ac, (EventQueueBatch)new DummyEventQueueBatch());
        });
        this.assertPermissions("revoking admin flag", new InternalPermission[0]);
    }

    protected long getPermissionCacheSize() {
        return (Long)this.db().tx(tx -> tx.permissionCache().size());
    }

    protected Set<InternalPermission> getPermissionsOnProject() {
        return (Set)this.db().tx(tx -> {
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            return tx.userDao().getPermissions(user, (HibBaseElement)project);
        });
    }

    protected void assertPermissions(String state, InternalPermission ... perms) {
        ((AbstractLongAssert)Assertions.assertThat((long)this.getPermissionCacheSize()).as("Cache size after " + state, new Object[0])).isEqualTo(0L);
        Assertions.assertThat(this.getPermissionsOnProject()).as("Permissions after " + state, new Object[0]).containsOnly((Object[])perms);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getPermissionCacheSize()).as("Cache size after " + state, new Object[0])).isNotEqualTo(0L);
    }
}

