/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.job.JobListResponse;
import com.gentics.mesh.core.rest.job.JobType;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.JobParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class ProjectEndpointDeleteTest
extends AbstractMeshTest {
    @Test
    public void testDeleteByUUID() throws Exception {
        String uuid = this.projectUuid();
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        String parentNodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        for (int i = 0; i < 100; ++i) {
            NodeCreateRequest request = new NodeCreateRequest();
            SchemaReferenceImpl schemaReference = new SchemaReferenceImpl();
            schemaReference.setName("content");
            schemaReference.setUuid(schemaUuid);
            request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("new-page" + i + ".html")));
            request.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
            request.setSchema((SchemaReference)schemaReference);
            request.setLanguage("en");
            request.setParentNodeUuid(parentNodeUuid);
            ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[0]));
        }
        ClientHelper.call(() -> this.client().deleteProject(uuid));
    }

    @Test
    public void testDeleteAfterPurge() {
        this.adminCall(() -> this.client().purgeProject(this.projectUuid(), new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteProject(this.projectUuid()));
        ClientHelper.call(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        JobListResponse response = (JobListResponse)this.adminCall(() -> this.client().findJobs(new ParameterProvider[]{new JobParametersImpl().setType(new JobType[]{JobType.versionpurge})}));
        Assertions.assertThat((List)response.getData()).isEmpty();
    }
}

