/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.ProjectDao;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class ProjectEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String etag = ClientHelper.callETag(() -> this.client().findProjects(new ParameterProvider[0]));
            ClientHelper.callETag(() -> this.client().findProjects(new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            ProjectDao projectDao = tx.projectDao();
            String actualETag = ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]));
            String etag = projectDao.getETag((HibTransformableElement)this.project(), this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)actualETag);
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304));
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
            etag = ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid"})}));
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid"})}), (String)etag, (boolean)true, (int)304);
            etag = ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}));
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
            ClientHelper.callETag(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}), (String)etag, (boolean)true, (int)304);
        }
    }
}

