/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.DaoGlobal;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectListResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.project.ProjectUpdateRequest;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.core.rest.role.RoleResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class ProjectEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Test
    public void testCreateNoSchemaReference() {
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("Test1234");
        ClientHelper.call(() -> this.client().createProject(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_error_no_schema_reference", (String[])new String[0]);
        request.setSchema((SchemaReference)new SchemaReferenceImpl());
        ClientHelper.call(() -> this.client().createProject(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_error_no_schema_reference", (String[])new String[0]);
    }

    @Test
    public void testCreateBogusSchemaReference() {
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("Test1234");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("bogus42"));
        ClientHelper.call(() -> this.client().createProject(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_reference_not_found", (String[])new String[]{"bogus42", "-", "-"});
    }

    @Test
    public void testCreateBogusName() {
        String name = "T\u00e4\u1f921 \u00fcst";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName(name);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        Assert.assertEquals((String)"The name of the project did not match.", (Object)name, (Object)restProject.getName());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(name, restProject.getRootNode().getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        Assert.assertEquals((Object)"folder", (Object)response.getSchema().getName());
        request.setName("Bla/blub");
        ClientHelper.call(() -> this.client().createProject(request));
        ClientHelper.call(() -> this.client().findNodes(request.getName(), new ParameterProvider[0]));
    }

    @Test
    public void testCreateWithEndpointNames() {
        List<String> names = Arrays.asList("users", "groups", "projects");
        for (String name : names) {
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName(name);
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            ClientHelper.call(() -> this.client().createProject(request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_error_name_already_reserved", (String[])new String[]{name});
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        String name = "test12345";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test12345");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        this.expect(MeshEvent.PROJECT_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("test12345")).uuidNotNull());
        this.expect(MeshEvent.NODE_CREATED).match(1, NodeMeshEventModel.class, event -> {
            MeshAssertions.assertThat((NodeMeshEventModel)event).uuidNotNull();
            Assert.assertNull((String)"No name should be set for the base node.", (Object)event.getName());
        });
        ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        this.awaitEvents();
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("test12345", restProject.getRootNode().getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        Assert.assertEquals((Object)"folder", (Object)response.getSchema().getName());
        MeshAssertions.assertThat((ProjectResponse)restProject).matches(request);
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNotNull((String)"The project should have been created.", (Object)tx.projectDao().findByName("test12345"));
            HibProject project = (HibProject)tx.projectDao().findByUuid(restProject.getUuid());
            Assert.assertNotNull((Object)project);
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)project, InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)project.getBaseNode(), InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), project.getTagFamilyPermissionRoot(), InternalPermission.CREATE_PERM));
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), project.getNodePermissionRoot(), InternalPermission.CREATE_PERM));
            Assert.assertEquals((Object)"folder", (Object)((HibSchemaVersion)project.getBaseNode().getSchemaContainer().getLatestVersion()).getName());
        }
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        String name = "test12345";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test12345");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().project(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        String projectRootUuid = (String)this.db().tx(() -> Tx.get().data().permissionRoots().project().getUuid());
        ClientHelper.call(() -> this.client().createProject(request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{projectRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        try (Tx tx = this.tx();){
            String uuid = UUIDUtil.randomUUID();
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("New Name");
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
            ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(uuid, request));
            MeshAssertions.assertThat((ProjectResponse)restProject).hasUuid(uuid);
            HibProject reloadedProject = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertEquals((Object)"New Name", (Object)reloadedProject.getName());
        }
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        try (Tx noTx = this.tx();){
            String uuid = this.user().getUuid();
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("New Name");
            request.setSchemaRef("folder");
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
            ClientHelper.call(() -> this.client().createProject(uuid, request), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
        }
    }

    @Test
    public void testCreateWithHostname() throws Exception {
        String name = "test12345";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test12345");
        request.setHostname("dummy.host");
        request.setSsl(true);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ClientHelper.call(() -> this.client().createProject(request));
        BranchResponse response1 = (BranchResponse)((BranchListResponse)ClientHelper.call(() -> this.client().findBranches("test12345", new ParameterProvider[0]))).getData().get(0);
        MeshAssertions.assertThat((BranchResponse)response1).hasHostname("dummy.host").hasSSL((Object)true);
        BranchUpdateRequest updateRequest = new BranchUpdateRequest();
        updateRequest.setHostname("different.host");
        updateRequest.setSsl(null);
        BranchResponse response2 = (BranchResponse)ClientHelper.call(() -> this.client().updateBranch("test12345", response1.getUuid(), updateRequest));
        MeshAssertions.assertThat((BranchResponse)response2).hasHostname("different.host").hasSSL((Object)true);
    }

    @Test
    public void testCreateWithPathPrefix() throws Exception {
        String name = "test12345";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test12345");
        request.setHostname("dummy.host");
        request.setPathPrefix("my/prefix");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ClientHelper.call(() -> this.client().createProject(request));
        BranchResponse branch = (BranchResponse)((BranchListResponse)ClientHelper.call(() -> this.client().findBranches("test12345", new ParameterProvider[0]))).getData().get(0);
        MeshAssertions.assertThat((BranchResponse)branch).hasPathPrefix("my/prefix");
    }

    @Test
    public void testCreateDeleteMultiple() throws InterruptedException {
        String NAME = "dummy123";
        for (int i = 0; i < 500; ++i) {
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("dummy123");
            request.setHostname("dummy.host");
            request.setSsl(true);
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            ProjectResponse response = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
            String baseUuid = response.getRootNode().getUuid();
            ClientHelper.call(() -> this.client().deleteProject(response.getUuid()));
            ClientHelper.call(() -> this.client().findNodeByUuid("dummy123", baseUuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"project_not_found", (String[])new String[]{"dummy123"});
        }
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.project().getBaseNode(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.project().getBaseNode(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.project().getBaseNode(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().mesh(), new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.UPDATE_PERM, InternalPermission.READ_PERM});
            tx.success();
        }
        String name = "test12345";
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test12345");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        try (Tx tx = this.tx();){
            ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
            MeshAssertions.assertThat((ProjectResponse)restProject).matches(request);
            MeshAssertions.assertThat((PermissionInfo)restProject.getPermissions()).hasPerm(Permission.basicPermissions());
            Assert.assertNotNull((String)"The project should have been created.", (Object)tx.projectDao().findByName("test12345"));
            ClientHelper.call(() -> this.client().findProjectByUuid(restProject.getUuid(), new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().deleteProject(restProject.getUuid()));
        }
    }

    @Override
    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testReadMultiple() throws Exception {
        RoleDao roleDao;
        int nProjects = 142;
        String noPermProjectName = "no_perm_project";
        try (Tx tx = this.tx();){
            roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            roleDao = tx.roleDao();
            for (int i = 0; i < 142; ++i) {
                HibProject extraProject = this.createProject("extra_project_" + i, "folder");
                extraProject.setBaseNode(this.project().getBaseNode());
                roleDao.grantPermissions(this.role(), (HibBaseElement)extraProject, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            this.createProject("no_perm_project", "folder");
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ProjectListResponse restResponse = (ProjectListResponse)this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl()}).blockingGet();
        Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)143L, (long)restResponse.getData().size());
        long perPage = 11L;
        restResponse = (ProjectListResponse)this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(3, Long.valueOf(perPage))}).blockingGet();
        Assert.assertEquals((long)perPage, (long)restResponse.getData().size());
        int totalProjects = 143;
        int totalPages = (int)Math.ceil((double)totalProjects / (double)perPage);
        Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)perPage, (long)restResponse.getData().size());
        Assert.assertEquals((long)3L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)totalPages, (long)restResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)perPage, (long)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)totalProjects, (long)restResponse.getMetainfo().getTotalCount());
        ArrayList allProjects = new ArrayList();
        int page = 1;
        while (page <= totalPages) {
            int currentPage = page++;
            restResponse = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(currentPage, Long.valueOf(perPage))}));
            allProjects.addAll(restResponse.getData());
        }
        Assert.assertEquals((String)"Somehow not all projects were loaded when loading all pages.", (long)totalProjects, (long)allProjects.size());
        List filteredProjectList = allProjects.parallelStream().filter(restProject -> restProject.getName().equals("no_perm_project")).collect(Collectors.toList());
        Assert.assertTrue((String)"The no perm project should not be part of the list since no permissions were added.", (filteredProjectList.size() == 0 ? 1 : 0) != 0);
        ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(perPage))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
        ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
        ProjectListResponse listResponse = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(25L))}));
        Assert.assertNotNull((Object)listResponse.toJson());
        Assert.assertEquals((long)4242L, (long)listResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)25L, (long)listResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)143L, (long)listResponse.getMetainfo().getTotalCount());
        Assert.assertEquals((long)6L, (long)listResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)0L, (long)listResponse.getData().size());
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{param})), ProjectResponse::getName, "name", "List of project names");
    }

    @Test
    public void testReadProjects() {
        for (int i = 0; i < 10; ++i) {
            String name = "test12345_" + i;
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName(name);
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            ClientHelper.call(() -> this.client().createProject(request));
        }
        ProjectListResponse list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}));
        Assert.assertEquals((String)"The page count should be one.", (long)0L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"Total count should be one.", (long)11L, (long)list.getMetainfo().getTotalCount());
        Assert.assertEquals((String)"Total data size should be zero", (long)0L, (long)list.getData().size());
        list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(1L))}));
        Assert.assertEquals((String)"The page count should be one.", (long)11L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"Total count should be one.", (long)11L, (long)list.getMetainfo().getTotalCount());
        Assert.assertEquals((String)"Total data size should be one.", (long)1L, (long)list.getData().size());
        list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(2L))}));
        Assert.assertEquals((String)"The page count should be one.", (long)6L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"Total count should be one.", (long)11L, (long)list.getMetainfo().getTotalCount());
        Assert.assertEquals((String)"Total data size should be one.", (long)2L, (long)list.getData().size());
        list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[]{new PagingParametersImpl(6, Long.valueOf(2L))}));
        Assert.assertEquals((String)"The page count should be one.", (long)6L, (long)list.getMetainfo().getPageCount());
        Assert.assertEquals((String)"Total count should be one.", (long)11L, (long)list.getMetainfo().getTotalCount());
        Assert.assertEquals((String)"Total data size should be one.", (long)1L, (long)list.getData().size());
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            String uuid = project.getUuid();
            Assert.assertNotNull((String)"The UUID of the project must not be null.", (Object)project.getUuid());
            roleDao.grantPermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.READ_PERM, InternalPermission.UPDATE_PERM});
            ProjectResponse response = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByUuid(uuid, new ParameterProvider[0]));
            MeshAssertions.assertThat((ProjectResponse)response).matches(this.project());
            System.out.println(response.getRootNode().getDisplayName());
            response = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByUuid(uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
            Assert.assertNotNull((Object)response.getRootNode().getPath());
            PermissionInfo permissions = response.getPermissions();
            Assert.assertTrue((boolean)permissions.hasPerm(Permission.CREATE));
            Assert.assertTrue((boolean)permissions.hasPerm(Permission.READ));
            Assert.assertTrue((boolean)permissions.hasPerm(Permission.UPDATE));
            Assert.assertTrue((boolean)permissions.hasPerm(Permission.DELETE));
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            String uuid = project.getUuid();
            ProjectResponse response = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByUuid(uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.role().getUuid())}));
            Assert.assertNotNull((Object)response.getRolePerms());
            MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).hasPerm(Permission.basicPermissions());
        }
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.projectUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testUpdateWithBogusNames() {
        String uuid = this.projectUuid();
        this.tx(() -> this.createProject("Test234", "folder"));
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName("Test234");
        ClientHelper.call(() -> this.client().updateProject(uuid, request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"project_conflicting_name", (String[])new String[0]);
        request.setName("Bla/blub");
        ClientHelper.call(() -> this.client().updateProject(uuid, request));
        ClientHelper.call(() -> this.client().findNodes(request.getName(), new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            Assert.assertEquals((Object)request.getName(), (Object)((HibProject)Tx.get().projectDao().findByUuid(this.projectUuid())).getName());
        }
    }

    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testUpdateByAppendingToName() {
        String uuid = this.projectUuid();
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName("abc");
        ClientHelper.call(() -> this.client().updateProject(uuid, request));
        ClientHelper.call(() -> this.client().findNodes(request.getName(), new ParameterProvider[0]));
        request.setName("abcd");
        ClientHelper.call(() -> this.client().updateProject(uuid, request));
        ClientHelper.call(() -> this.client().findNodes(request.getName(), new ParameterProvider[0]));
    }

    @Test
    public void testUpdateWithEndpointName() {
        List<String> names = Arrays.asList("users", "groups", "projects");
        for (String name : names) {
            String uuid = this.projectUuid();
            ProjectUpdateRequest request = new ProjectUpdateRequest();
            request.setName(name);
            ClientHelper.call(() -> this.client().updateProject(uuid, request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_error_name_already_reserved", (String[])new String[]{name});
        }
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        String uuid = this.projectUuid();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            roleDao.grantPermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        String newName = "New Name";
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName(newName);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasNoStoreEvents();
        this.expect(MeshEvent.PROJECT_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(newName)).uuidNotNull());
        ProjectResponse restProject = (ProjectResponse)ClientHelper.call(() -> this.client().updateProject(uuid, request));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        Assert.assertTrue((String)"The new project router should have been added", (boolean)this.mesh().routerStorageRegistry().hasProject(newName));
        ClientHelper.call(() -> this.client().findNodes(newName, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid());
            MeshAssertions.assertThat((ProjectResponse)restProject).matches(project);
            int expectedCount = 1;
            for (HibNode node : tx.nodeDao().findAll((HibCoreElement)this.project())) {
                expectedCount = (int)((long)expectedCount + tx.contentDao().getFieldContainerCount(node));
            }
            expectedCount = (int)((long)expectedCount + tx.tagDao().count());
            expectedCount = (int)((long)expectedCount + tx.tagFamilyDao().count((HibCoreElement)project));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibProject.composeIndexName(), HibProject.composeDocumentId((String)uuid));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)expectedCount, 0L, 0L, 0L, 0L);
            HibProject reloadedProject = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertEquals((Object)newName, (Object)reloadedProject.getName());
        }
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName("new Name");
        ClientHelper.call(() -> this.client().updateProject("bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws JsonProcessingException, Exception {
        String uuid = this.projectUuid();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibProject project = this.project();
            roleDao.grantPermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)project, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName("New Name");
        ClientHelper.call(() -> this.client().updateProject(uuid, request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        try (Tx tx = this.tx();){
            HibProject reloadedProject = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertEquals((String)"The name should not have been changed", (Object)"dummy", (Object)reloadedProject.getName());
        }
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        String uuid = this.projectUuid();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        HashSet<String> droppedIndices = new HashSet<String>();
        try (Tx tx = this.tx();){
            HibProject project = this.project();
            droppedIndices.add(HibTagFamily.composeIndexName((String)this.projectUuid()));
            droppedIndices.add(HibTag.composeIndexName((String)this.projectUuid()));
            droppedIndices.add(ContentDao.composeIndexPattern((String)uuid));
        }
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        this.expect(MeshEvent.PROJECT_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("dummy")).hasUuid(this.projectUuid())).one();
        this.expect(MeshEvent.NODE_DELETED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasUuid(baseNodeUuid));
        this.expect(MeshEvent.BRANCH_DELETED).one();
        this.expect(MeshEvent.PROJECT_SCHEMA_UNASSIGNED).total(3L);
        this.expect(MeshEvent.TAG_FAMILY_DELETED).total(2L);
        ClientHelper.call(() -> this.client().deleteProject(uuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibProject.composeIndexName(), HibProject.composeDocumentId((String)uuid));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDrop(HibTagFamily.composeIndexName((String)uuid));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDrop(HibTag.composeIndexName((String)uuid));
        for (String index : droppedIndices) {
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDrop(index);
        }
        long deleted = 1L;
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, deleted, (long)droppedIndices.size(), 0L);
        try (Tx tx = this.tx();){
            MeshAssert.assertElement((DaoGlobal)tx.projectDao(), (String)uuid, (boolean)false);
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        String uuid = this.projectUuid();
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.project(), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().deleteProject(uuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.DELETE_PERM.getRestPerm().getName(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 0L, 0L, 0L);
        tx = this.tx();
        try {
            HibProject project = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertNotNull((String)"The project should not have been deleted", (Object)project);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testUpdateMultithreaded() throws Exception {
        int nJobs = 5;
        ProjectUpdateRequest request = new ProjectUpdateRequest();
        request.setName("New Name");
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().updateProject(this.projectUuid(), request).toCompletable()).blockingAwait();
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 10;
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]).toCompletable()).blockingAwait();
    }

    @Override
    @Test
    @Ignore(value="not yet enabled")
    public void testDeleteByUUIDMultithreaded() throws Exception {
        int nJobs = 3;
        String uuid = this.project().getUuid();
        ClientHelper.validateDeletion(i -> this.client().deleteProject(uuid), (int)nJobs);
    }

    @Override
    @Test
    @Ignore(value="Disabled since test is unstable - CL-246")
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 100;
        long nProjectsBefore = (Long)this.tx(tx -> tx.projectDao().count());
        MeshTestHelper.validateCreation(nJobs, i -> {
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("test12345_" + i);
            request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            return this.client().createProject(request);
        });
        try (Tx tx2 = this.tx();){
            CommonTx ctx = (CommonTx)tx2.unwrap();
            long n = ctx.count(ctx.projectDao().getPersistenceClass());
            long nProjectsAfter = ctx.projectDao().count();
            Assert.assertEquals((long)(nProjectsBefore + (long)nJobs), (long)nProjectsAfter);
            Assert.assertEquals((long)(nProjectsBefore + (long)nJobs), (long)n);
        }
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        int nJobs = 200;
        Observable.range((int)0, (int)nJobs).flatMapCompletable(i -> this.client().findProjectByUuid(this.projectUuid(), new ParameterProvider[0]).toCompletable()).blockingAwait();
    }

    @Override
    @Test
    public void testPermissionResponse() {
        ProjectResponse project = (ProjectResponse)((ProjectListResponse)this.client().findProjects(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)project.getPermissions()).hasNoPublishPermsSet();
    }

    @Test
    public void testDeleteWithBranches() throws Exception {
        String uuid = this.projectUuid();
        String branchName = "Branch_V1";
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(branchName);
        this.waitForJob(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Branch Response", new Object[0])).isNotNull()).hasName(branchName).isActive().isNotMigrated();
        });
        String nodeUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        for (BranchResponse branch : ((BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]))).getData()) {
            NodeUpdateRequest update = new NodeUpdateRequest();
            update.setLanguage("en");
            update.setVersion("0.1");
            update.getFields().put("name", (Field)FieldUtil.createStringField((String)("2015 in " + branch.getName())));
            ClientHelper.call(() -> this.client().updateNode("dummy", nodeUuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch.getName())}));
        }
        this.consistency.check();
        ClientHelper.call(() -> this.client().deleteProject(uuid));
    }

    @Test
    public void createProjectAfterDeletedRole() {
        RoleResponse role = this.createRole("test");
        this.client().updateRolePermissions(role.getUuid(), "/projects", RolePermissionRequest.withPermissions((Permission[])new Permission[]{Permission.CREATE})).blockingAwait();
        this.deleteRole(role.getUuid());
        this.createProject("testProject");
    }

    @Test
    public void testDeleteProjectNamedProject() {
        ProjectResponse project = this.createProject("project");
        ProjectListResponse list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[0]));
        MeshAssertions.assertThat(list.getData().stream().map(ProjectResponse::getName)).as("List of projects", new Object[0]).containsOnly((Object[])new String[]{"dummy", "project"});
        this.deleteProject(project.getUuid());
        list = (ProjectListResponse)ClientHelper.call(() -> this.client().findProjects(new ParameterProvider[0]));
        MeshAssertions.assertThat(list.getData().stream().map(ProjectResponse::getName)).as("List of projects", new Object[0]).containsOnly((Object[])new String[]{"dummy"});
    }
}

