/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.project;

import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.URIUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class ProjectInfoEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadProjectByName() {
        ProjectResponse project = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByName("dummy", new ParameterProvider[0]));
        Assert.assertEquals((Object)"dummy", (Object)project.getName());
    }

    @Test
    public void testReadUnknownProjectByName() {
        ClientHelper.call(() -> this.client().findProjectByName("Unknown", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_name", (String[])new String[]{"Unknown"});
    }

    @Test
    public void testReadProjectWithEndSlash() {
        ClientHelper.call(() -> this.client().get("/" + URIUtils.encodeSegment((String)"dummy") + "/", ProjectResponse.class));
    }
}

